/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagType;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import com.sk89q.worldedit.util.nbt.ByteBinaryTag;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.ShortBinaryTag;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import java.util.HashMap;
import java.util.Map;

public class NbtUtils {
    public static <T extends BinaryTag> T getChildTag(CompoundBinaryTag tag, String key, BinaryTagType<T> expected) throws InvalidFormatException {
        BinaryTag childTag = tag.get(key);
        if (childTag == null) {
            throw new InvalidFormatException("Missing a \"" + key + "\" tag");
        }
        if (childTag.type().id() != expected.id()) {
            throw new InvalidFormatException(key + " tag is not of tag type " + expected);
        }
        BinaryTag childTagCast = childTag;
        return (T)childTagCast;
    }

    public static int getInt(CompoundBinaryTag tag, String key) throws InvalidFormatException {
        BinaryTag childTag = tag.get(key);
        if (childTag == null) {
            throw new InvalidFormatException("Missing a \"" + key + "\" tag");
        }
        BinaryTagType type = childTag.type();
        if (type == BinaryTagTypes.INT) {
            return ((IntBinaryTag)childTag).intValue();
        }
        if (type == BinaryTagTypes.BYTE) {
            return ((ByteBinaryTag)childTag).intValue();
        }
        if (type == BinaryTagTypes.SHORT) {
            return ((ShortBinaryTag)childTag).intValue();
        }
        throw new InvalidFormatException(key + " tag is not of int, short or byte tag type.");
    }

    public static Map<String, BinaryTag> getCompoundBinaryTagValues(CompoundBinaryTag tag) {
        HashMap<String, BinaryTag> value = new HashMap<String, BinaryTag>();
        tag.forEach(e -> value.put((String)e.getKey(), (BinaryTag)e.getValue()));
        return value;
    }
}

