/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import sun.misc.Unsafe;

public class ReflectionUtils {
    private static Unsafe UNSAFE;

    public static <T> T as(Class<T> t, Object o) {
        return t.isInstance(o) ? (T)t.cast(o) : null;
    }

    public static void setAccessibleNonFinal(Field field) {
        field.setAccessible(true);
        if (Modifier.isFinal(field.getModifiers())) {
            try {
                Field lookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                lookupField.setAccessible(true);
                ((MethodHandles.Lookup)lookupField.get(null)).findSetter(Field.class, "modifiers", Integer.TYPE).invokeExact(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws IllegalAccessException {
        ReflectionUtils.setAccessibleNonFinal(field);
        field.set(target, value);
    }

    public static Object getHandle(Object wrapper) {
        Method getHandle = ReflectionUtils.makeMethod(wrapper.getClass(), "getHandle", new Class[0]);
        return ReflectionUtils.callMethod(getHandle, wrapper, new Object[0]);
    }

    public static Method makeMethod(Class<?> clazz, String methodName, Class<?> ... parameters) {
        try {
            return clazz.getDeclaredMethod(methodName, parameters);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T> T callMethod(Method method, Object instance, Object ... parameters) {
        if (method == null) {
            throw new RuntimeException("No such method");
        }
        method.setAccessible(true);
        try {
            return (T)method.invoke(instance, parameters);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getCause());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T extends AccessibleObject> T setAccessible(T ao) {
        ao.setAccessible(true);
        return ao;
    }

    public static <T> T getField(@Nonnull Field field, Object instance) {
        field.setAccessible(true);
        try {
            return (T)field.get(instance);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Class<?> getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static <T> Class<? extends T> getClass(String name, Class<T> superClass) {
        try {
            return Class.forName(name).asSubclass(superClass);
        }
        catch (ClassCastException | ClassNotFoundException ex) {
            return null;
        }
    }

    public static void unsafeSet(Field field, Object base, Object value) {
        UNSAFE.putObject(base, UNSAFE.objectFieldOffset(field), value);
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    static {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = (Unsafe)unsafeField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

