/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util.collection;

import com.fastasyncworldedit.core.util.collection.AdaptedSetCollection;
import com.fastasyncworldedit.core.util.collection.IAdaptedMap;
import com.google.common.base.Function;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AdaptedMap<K, V, K2, V2>
implements IAdaptedMap<K, V, K2, V2> {
    private final Map<K2, V2> parent;
    private final java.util.function.Function<V2, V> value2;
    private final java.util.function.Function<K2, K> key2;
    private final java.util.function.Function<V, V2> value;
    private final java.util.function.Function<K, K2> key;
    private static final java.util.function.Function SAME = o -> o;
    private static final java.util.function.Function IMMUTABLE = o -> {
        throw new UnsupportedOperationException("Immutable");
    };

    public static <K, K2, V> AdaptedMap<K, V, K2, V> keys(Map<K2, V> parent, java.util.function.Function<K, K2> key, java.util.function.Function<K2, K> key2) {
        return new AdaptedMap<K, V, K2, V>(parent, key, key2, SAME, SAME);
    }

    public static <K, V, V2> AdaptedMap<K, V, K, V2> values(Map<K, V2> parent, java.util.function.Function<V, V2> value, java.util.function.Function<V2, V> value2) {
        return new AdaptedMap<K, V, K, V2>(parent, SAME, SAME, value, value2);
    }

    public static <K, K2, V, V2> AdaptedMap<K, V, K2, V2> immutable(Map<K2, V2> parent, java.util.function.Function<K2, K> key, java.util.function.Function<V2, V> value) {
        return new AdaptedMap<K, V, K2, V2>(parent, IMMUTABLE, key, IMMUTABLE, value);
    }

    public AdaptedMap(Map<K2, V2> parent, java.util.function.Function<K, K2> key, java.util.function.Function<K2, K> key2, java.util.function.Function<V, V2> value, java.util.function.Function<V2, V> value2) {
        this.parent = parent;
        this.key = key;
        this.value = value;
        this.key2 = key2;
        this.value2 = value2;
    }

    @Override
    public Map<K2, V2> getParent() {
        return this.parent;
    }

    @Override
    public K2 adaptKey(K key) {
        return this.key.apply(key);
    }

    @Override
    public V2 adaptValue(V value) {
        return this.value.apply(value);
    }

    @Override
    public K adaptKey2(K2 key) {
        return this.key2.apply(key);
    }

    @Override
    public V adaptValue2(V2 value) {
        return this.value2.apply(value);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        return new AdaptedSetCollection(this.getParent().entrySet(), new Function<Map.Entry<K2, V2>, Map.Entry<K, V>>(){
            private final AdaptedPair entry;
            {
                this.entry = new AdaptedPair();
            }

            public Map.Entry<K, V> apply(@Nullable Map.Entry<K2, V2> input) {
                this.entry.input = input;
                return this.entry;
            }
        });
    }

    public class AdaptedPair
    implements Map.Entry<K, V> {
        private Map.Entry<K2, V2> input;

        @Override
        public K getKey() {
            return AdaptedMap.this.adaptKey2(this.input.getKey());
        }

        @Override
        public V getValue() {
            return AdaptedMap.this.adaptValue2(this.input.getValue());
        }

        @Override
        public V setValue(V value) {
            return AdaptedMap.this.adaptValue2(this.input.setValue(AdaptedMap.this.adaptValue(value)));
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                return Objects.equals(((Map.Entry)o).getKey(), this.getKey()) && Objects.equals(((Map.Entry)o).getValue(), this.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 1337;
        }
    }
}

