/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util.collection;

import com.fastasyncworldedit.core.math.BlockVectorSet;
import com.fastasyncworldedit.core.math.LocalBlockVectorSet;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import java.util.Set;

public interface BlockVector3Set
extends Set<BlockVector3> {
    public static BlockVector3Set getAppropriateVectorSet(Region region) {
        BlockVector3 max = region.getMaximumPoint();
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 size = region.getDimensions();
        if (size.getBlockX() > 2048 || size.getBlockZ() > 2048 || size.getBlockY() > 512) {
            return new BlockVectorSet();
        }
        int offsetX = (int)Math.ceil((double)(min.getX() + max.getX()) / 2.0);
        int offsetZ = (int)Math.ceil((double)(min.getZ() + max.getZ()) / 2.0);
        int offsetY = region.getMinimumY() < -128 || region.getMaximumY() > 320 ? (min.getY() + max.getY()) / 2 : 128;
        return new LocalBlockVectorSet(offsetX, offsetY, offsetZ);
    }

    public boolean add(int var1, int var2, int var3);

    public boolean contains(int var1, int var2, int var3);
}

