/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util.progress;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.util.StringMan;
import com.fastasyncworldedit.core.util.TaskManager;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.function.BiConsumer;

public class DefaultProgressTracker
implements BiConsumer<ProgressType, Integer> {
    private final Player player;
    private final long start;
    private int delay;
    private int interval;
    private int totalQueue;
    private int amountQueue;
    private int amountDispatch;
    private final int lastSize = 0;
    private boolean done;
    private long lastTick;

    public DefaultProgressTracker(Player player) {
        Settings.QUEUE cfr_ignored_0 = Settings.settings().QUEUE;
        this.delay = Settings.QUEUE.PROGRESS.DELAY;
        Settings.QUEUE cfr_ignored_1 = Settings.settings().QUEUE;
        this.interval = Settings.QUEUE.PROGRESS.INTERVAL;
        this.totalQueue = 0;
        this.amountQueue = 0;
        this.amountDispatch = 0;
        this.lastSize = 0;
        this.done = false;
        this.lastTick = 0L;
        this.start = System.currentTimeMillis();
        this.player = player;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getDelay() {
        return this.delay;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void accept(ProgressType type, Integer amount) {
        long currentTick;
        switch (type) {
            case DISPATCH: {
                ++this.amountDispatch;
                this.amountQueue = amount;
                break;
            }
            case QUEUE: {
                ++this.totalQueue;
                this.amountQueue = amount;
                break;
            }
            case DONE: {
                if (this.totalQueue > 64 && !this.done) {
                    this.done = true;
                    this.done();
                }
                return;
            }
        }
        long now = System.currentTimeMillis();
        if (now - this.start > (long)this.delay && (currentTick = now / 50L) > this.lastTick + (long)this.interval) {
            this.lastTick = currentTick;
            this.send();
        }
    }

    private void done() {
        TaskManager.taskManager().task(this::doneTask);
    }

    private void send() {
        TaskManager.taskManager().task(this::sendTask);
    }

    public void doneTask() {
        this.sendTile((Component)TextComponent.empty(), (Component)Caption.of("fawe.progress.progress.finished", new Object[0]));
    }

    public void sendTask() {
        String queue = StringMan.padRight(String.valueOf(this.totalQueue), 3);
        String dispatch = StringMan.padLeft(String.valueOf(this.amountDispatch), 3);
        int total = this.amountDispatch != 0 ? this.amountDispatch : this.amountQueue;
        int speed = total != 0 ? (int)((double)total / Math.max((double)(System.currentTimeMillis() - this.start) / 1000.0, 1.0)) : 0;
        String speedStr = StringMan.padRight(String.valueOf(speed), 3);
        String percent = StringMan.padRight(String.valueOf(this.amountDispatch != 0 ? this.amountDispatch * 100 / this.totalQueue : 0), 3);
        int remaining = speed != 0 ? this.amountQueue / speed : -1;
        this.sendTile((Component)TextComponent.empty(), (Component)Caption.of("fawe.progress.progress.message", queue, dispatch, percent, StringMan.padLeft("" + speed, 3), StringMan.padLeft("" + remaining, 3)));
    }

    public void sendTile(Component title, Component sub) {
        this.player.sendTitle(title, sub);
    }

    public static enum ProgressType {
        DISPATCH,
        QUEUE,
        DONE;

    }
}

