/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.DisallowedBlocksExtent;
import com.fastasyncworldedit.core.extent.FaweRegionExtent;
import com.fastasyncworldedit.core.extent.HistoryExtent;
import com.fastasyncworldedit.core.extent.LimitExtent;
import com.fastasyncworldedit.core.extent.MultiRegionExtent;
import com.fastasyncworldedit.core.extent.SingleRegionExtent;
import com.fastasyncworldedit.core.extent.SlowExtent;
import com.fastasyncworldedit.core.extent.StripNBTExtent;
import com.fastasyncworldedit.core.extent.processor.heightmap.HeightmapProcessor;
import com.fastasyncworldedit.core.extent.processor.lighting.NullRelighter;
import com.fastasyncworldedit.core.extent.processor.lighting.RelightMode;
import com.fastasyncworldedit.core.extent.processor.lighting.RelightProcessor;
import com.fastasyncworldedit.core.extent.processor.lighting.Relighter;
import com.fastasyncworldedit.core.history.DiskStorageHistory;
import com.fastasyncworldedit.core.history.MemoryOptimizedHistory;
import com.fastasyncworldedit.core.history.RollbackOptimizedHistory;
import com.fastasyncworldedit.core.history.changeset.AbstractChangeSet;
import com.fastasyncworldedit.core.history.changeset.BlockBagChangeSet;
import com.fastasyncworldedit.core.history.changeset.NullChangeSet;
import com.fastasyncworldedit.core.limit.FaweLimit;
import com.fastasyncworldedit.core.limit.PropertyRemap;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IQueueChunk;
import com.fastasyncworldedit.core.queue.IQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.ParallelQueueExtent;
import com.fastasyncworldedit.core.regions.RegionWrapper;
import com.fastasyncworldedit.core.util.MemUtil;
import com.fastasyncworldedit.core.util.Permission;
import com.fastasyncworldedit.core.wrappers.WorldWrapper;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.extent.EditSessionEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Locatable;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Identifiable;
import com.sk89q.worldedit.util.eventbus.EventBus;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.World;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public final class EditSessionBuilder {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final EventBus eventBus;
    private FaweLimit limit;
    private AbstractChangeSet changeSet;
    private Region[] allowedRegions;
    private Region[] disallowedRegions;
    private Boolean fastMode;
    private Boolean checkMemory;
    private Boolean combineStages;
    private EditSessionEvent event;
    private String command;
    private RelightMode relightMode;
    private Relighter relighter;
    private Boolean wnaMode;
    private AbstractChangeSet changeTask;
    private Extent bypassHistory;
    private Extent bypassAll;
    private Extent extent;
    private boolean compiled;
    private boolean wrapped;
    @Nullable
    private World world;
    private int maxBlocks = -1;
    @Nullable
    private Actor actor;
    @Nullable
    private BlockBag blockBag;
    private boolean tracing;

    EditSessionBuilder(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public EditSessionBuilder world(@Nullable World world) {
        this.world = world;
        return this.setDirty();
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    public EditSessionBuilder maxBlocks(int maxBlocks) {
        this.maxBlocks = maxBlocks;
        return this.setDirty();
    }

    @Nullable
    public Actor getActor() {
        return this.actor;
    }

    public EditSessionBuilder actor(@Nullable Actor actor) {
        this.actor = actor;
        return this.setDirty();
    }

    @Nullable
    public BlockBag getBlockBag() {
        return this.blockBag;
    }

    public EditSessionBuilder blockBag(@Nullable BlockBag blockBag) {
        this.blockBag = blockBag;
        return this.setDirty();
    }

    public boolean isTracing() {
        return this.tracing;
    }

    public EditSessionBuilder tracing(boolean tracing) {
        this.tracing = tracing;
        return this.setDirty();
    }

    public <A extends Actor & Locatable> EditSessionBuilder locatableActor(A locatable) {
        Extent extent = ((Locatable)locatable).getExtent();
        Preconditions.checkArgument((boolean)(extent instanceof World), (String)"%s is not located in a World", locatable);
        return this.world((World)extent).actor(locatable);
    }

    public EditSession build() {
        return new EditSession(this);
    }

    private EditSessionBuilder setDirty() {
        this.compiled = false;
        return this;
    }

    public EditSessionBuilder event(@Nullable EditSessionEvent event) {
        this.event = event;
        return this.setDirty();
    }

    public EditSessionBuilder limit(@Nullable FaweLimit limit) {
        this.limit = limit;
        return this.setDirty();
    }

    public EditSessionBuilder limitUnlimited() {
        return this.limit(FaweLimit.MAX.copy());
    }

    public EditSessionBuilder limitUnprocessed(@Nonnull Actor player) {
        this.limitUnlimited();
        FaweLimit tmp = player.getLimit();
        this.limit.INVENTORY_MODE = tmp.INVENTORY_MODE;
        return this.setDirty();
    }

    public EditSessionBuilder changeSet(@Nullable AbstractChangeSet changeSet) {
        this.changeSet = changeSet;
        return this.setDirty();
    }

    public EditSessionBuilder changeSetNull() {
        return this.changeSet(new NullChangeSet(this.world));
    }

    public EditSessionBuilder command(String command) {
        this.command = command;
        return this;
    }

    public EditSessionBuilder changeSet(boolean disk, @Nullable UUID uuid) {
        this.changeSet = disk ? (Settings.settings().HISTORY.USE_DATABASE ? new RollbackOptimizedHistory(this.world, uuid) : new DiskStorageHistory(this.world, uuid)) : new MemoryOptimizedHistory(this.world);
        return this.setDirty();
    }

    public EditSessionBuilder allowedRegions(@Nullable Region[] allowedRegions) {
        this.allowedRegions = allowedRegions;
        return this.setDirty();
    }

    @Deprecated
    public EditSessionBuilder allowedRegions(@Nullable RegionWrapper[] allowedRegions) {
        this.allowedRegions = allowedRegions;
        return this.setDirty();
    }

    public EditSessionBuilder allowedRegions(@Nullable RegionWrapper allowedRegion) {
        this.allowedRegions = allowedRegion == null ? null : allowedRegion.toArray();
        return this.setDirty();
    }

    public EditSessionBuilder disallowedRegions(@Nullable Region[] disallowedRegions) {
        this.disallowedRegions = disallowedRegions;
        return this.setDirty();
    }

    @Deprecated
    public EditSessionBuilder disallowedRegions(@Nullable RegionWrapper[] disallowedRegions) {
        this.disallowedRegions = disallowedRegions;
        return this.setDirty();
    }

    public EditSessionBuilder disallowedRegions(@Nullable RegionWrapper disallowedRegion) {
        this.disallowedRegions = disallowedRegion == null ? null : disallowedRegion.toArray();
        return this.setDirty();
    }

    public EditSessionBuilder allowedRegionsEverywhere() {
        return this.allowedRegions(new Region[]{RegionWrapper.GLOBAL()});
    }

    public EditSessionBuilder fastMode(@Nullable Boolean fastMode) {
        this.fastMode = fastMode;
        return this.setDirty();
    }

    public EditSessionBuilder relightMode(@Nullable RelightMode relightMode) {
        this.relightMode = relightMode;
        return this.setDirty();
    }

    public EditSessionBuilder checkMemory(@Nullable Boolean checkMemory) {
        this.checkMemory = checkMemory;
        return this.setDirty();
    }

    public EditSessionBuilder combineStages(@Nullable Boolean combineStages) {
        this.combineStages = combineStages;
        return this.setDirty();
    }

    public EditSessionBuilder compile() {
        if (this.compiled) {
            return this;
        }
        this.compiled = true;
        this.wrapped = false;
        if (this.event == null) {
            this.event = new EditSessionEvent(this.world, this.actor, -1, null);
        }
        if (this.actor == null && this.event.getActor() != null) {
            this.actor = this.event.getActor();
        }
        if (this.limit == null) {
            this.limit = this.actor == null ? FaweLimit.MAX : this.actor.getLimit();
        }
        if (this.fastMode == null) {
            this.fastMode = this.actor == null ? Boolean.valueOf(!Settings.settings().HISTORY.ENABLE_FOR_CONSOLE) : Boolean.valueOf(this.actor.getSession().hasFastMode());
        }
        if (this.checkMemory == null) {
            this.checkMemory = this.actor != null && this.fastMode == false;
        }
        if (this.checkMemory.booleanValue() && MemUtil.isMemoryLimitedSlow()) {
            if (Permission.hasPermission(this.actor, "worldedit.fast")) {
                this.actor.print((Component)Caption.of("fawe.info.worldedit.oom.admin", new Object[0]));
            }
            throw FaweCache.LOW_MEMORY;
        }
        this.blockBag = this.limit.INVENTORY_MODE != 0 ? this.blockBag : null;
        this.limit = this.limit.copy();
        if (this.extent == null) {
            Player player;
            boolean placeChunks;
            Extent queue = null;
            World unwrapped = WorldWrapper.unwrap(this.world);
            boolean bl = placeChunks = !(this.fastMode == false && !this.limit.FAST_PLACEMENT || this.wnaMode != null && this.wnaMode != false);
            if (placeChunks) {
                this.wnaMode = false;
                if (unwrapped instanceof IQueueExtent) {
                    this.extent = queue = (IQueueExtent<IQueueChunk>)((Object)unwrapped);
                } else if (Settings.settings().QUEUE.PARALLEL_THREADS > 1 && !Fawe.isMainThread()) {
                    ParallelQueueExtent parallel = new ParallelQueueExtent(Fawe.instance().getQueueHandler(), this.world, this.fastMode);
                    queue = parallel.getExtent();
                    this.extent = parallel;
                } else {
                    queue = Fawe.instance().getQueueHandler().getQueue(this.world);
                    this.extent = queue;
                }
            } else {
                this.wnaMode = true;
                this.extent = this.world;
            }
            if (this.combineStages == null) {
                this.combineStages = Settings.settings().HISTORY.COMBINE_STAGES && this.limit.FAST_PLACEMENT && this.blockBag == null;
            }
            this.extent = this.bypassAll = this.wrapExtent(this.extent, this.eventBus, this.event, EditSession.Stage.BEFORE_CHANGE);
            this.bypassHistory = this.extent = this.wrapExtent(this.bypassAll, this.eventBus, this.event, EditSession.Stage.BEFORE_REORDER);
            if (!this.fastMode.booleanValue() || this.changeSet != null) {
                if (this.changeSet == null) {
                    if (Settings.settings().HISTORY.USE_DISK) {
                        UUID uuid;
                        UUID uUID = uuid = this.actor == null ? Identifiable.CONSOLE : this.actor.getUniqueId();
                        this.changeSet = Settings.settings().HISTORY.USE_DATABASE ? new RollbackOptimizedHistory(this.world, uuid) : new DiskStorageHistory(this.world, uuid);
                    } else {
                        if (!this.combineStages.booleanValue() || Settings.settings().HISTORY.COMPRESSION_LEVEL == 0) {
                            // empty if block
                        }
                        this.changeSet = new MemoryOptimizedHistory(this.world);
                    }
                }
                if (this.limit.SPEED_REDUCTION > 0) {
                    this.extent = this.bypassHistory = new SlowExtent(this.bypassHistory, this.limit.SPEED_REDUCTION);
                }
                if (this.command != null && this.changeSet instanceof RollbackOptimizedHistory) {
                    ((RollbackOptimizedHistory)this.changeSet).setCommand(this.command);
                }
                if (!(this.changeSet instanceof NullChangeSet)) {
                    if (this.blockBag != null) {
                        this.changeSet = new BlockBagChangeSet(this.changeSet, this.blockBag, this.limit.INVENTORY_MODE == 1);
                    }
                    if (this.combineStages.booleanValue()) {
                        this.changeTask = this.changeSet;
                        this.extent = this.extent.enableHistory(this.changeSet);
                    } else {
                        this.extent = new HistoryExtent(this.extent, this.changeSet);
                    }
                }
            }
            if (this.allowedRegions == null && Settings.settings().REGION_RESTRICTIONS && this.actor != null && !this.actor.hasPermission("fawe.bypass.regions") && this.actor instanceof Player) {
                player = (Player)this.actor;
                this.allowedRegions = player.getAllowedRegions();
            }
            if (this.disallowedRegions == null && Settings.settings().REGION_RESTRICTIONS && Settings.settings().REGION_RESTRICTIONS_OPTIONS.ALLOW_BLACKLISTS && this.actor != null && !this.actor.hasPermission("fawe.bypass.regions") && this.actor instanceof Player) {
                player = (Player)this.actor;
                this.disallowedRegions = player.getDisallowedRegions();
            }
            FaweRegionExtent regionExtent = null;
            if (this.disallowedRegions != null) {
                regionExtent = new MultiRegionExtent(this.extent, this.limit, this.allowedRegions, this.disallowedRegions);
            } else if (this.allowedRegions == null) {
                this.allowedRegions = new Region[]{RegionWrapper.GLOBAL()};
            } else {
                regionExtent = this.allowedRegions.length == 0 ? new com.fastasyncworldedit.core.extent.NullExtent(this.extent, FaweCache.NO_REGION) : (this.allowedRegions.length == 1 ? new SingleRegionExtent(this.extent, this.limit, this.allowedRegions[0]) : new MultiRegionExtent(this.extent, this.limit, this.allowedRegions, null));
            }
            if (placeChunks) {
                IBatchProcessor platformPostProcessor;
                if (this.relightMode != null && this.relightMode != RelightMode.NONE || this.relightMode == null && Settings.settings().LIGHTING.MODE > 0) {
                    this.relighter = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getRelighterFactory().createRelighter(this.relightMode, this.world, (IQueueExtent<IQueueChunk>)queue);
                    queue.addProcessor(new RelightProcessor(this.relighter));
                }
                queue.addProcessor(new HeightmapProcessor(this.world.getMinY(), this.world.getMaxY()));
                IBatchProcessor platformProcessor = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getPlatformProcessor(this.fastMode);
                if (platformProcessor != null) {
                    queue.addProcessor(platformProcessor);
                }
                if ((platformPostProcessor = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getPlatformPostProcessor(this.fastMode)) != null) {
                    queue.addPostProcessor(platformPostProcessor);
                }
            } else {
                this.relighter = NullRelighter.INSTANCE;
            }
            if (this.limit != null && !this.limit.isUnlimited() && regionExtent != null) {
                this.extent = new LimitExtent(regionExtent, this.limit);
            } else if (this.limit != null && !this.limit.isUnlimited()) {
                this.extent = new LimitExtent(this.extent, this.limit);
            } else if (regionExtent != null) {
                this.extent = regionExtent;
            }
            if (this.limit != null && this.limit.STRIP_NBT != null && !this.limit.STRIP_NBT.isEmpty()) {
                if (placeChunks) {
                    queue.addProcessor(new StripNBTExtent(this.extent, this.limit.STRIP_NBT));
                } else {
                    this.extent = new StripNBTExtent(this.extent, this.limit.STRIP_NBT);
                }
            }
            if (this.limit != null && !this.limit.isUnlimited()) {
                HashSet<String> limitBlocks = new HashSet<String>();
                if ((this.getActor() == null || this.getActor().hasPermission("worldedit.anyblock")) && this.limit.UNIVERSAL_DISALLOWED_BLOCKS) {
                    limitBlocks.addAll(WorldEdit.getInstance().getConfiguration().disallowedBlocks);
                }
                if (this.limit.DISALLOWED_BLOCKS != null && !this.limit.DISALLOWED_BLOCKS.isEmpty()) {
                    limitBlocks.addAll(this.limit.DISALLOWED_BLOCKS);
                }
                Set<PropertyRemap<?>> remaps = this.limit.REMAP_PROPERTIES;
                if (!limitBlocks.isEmpty() || remaps != null && !remaps.isEmpty()) {
                    if (placeChunks) {
                        queue.addProcessor(new DisallowedBlocksExtent(this.extent, limitBlocks, remaps));
                    } else {
                        this.extent = new DisallowedBlocksExtent(this.extent, limitBlocks, remaps);
                    }
                }
            }
            this.extent = this.wrapExtent(this.extent, this.eventBus, this.event, EditSession.Stage.BEFORE_HISTORY);
        }
        return this;
    }

    public Relighter getRelighter() {
        return this.relighter;
    }

    public boolean isWNAMode() {
        return this.wnaMode;
    }

    @Nullable
    public Region[] getAllowedRegions() {
        return this.allowedRegions;
    }

    public EditSessionBuilder forceWNA() {
        this.wnaMode = true;
        return this.setDirty();
    }

    public boolean isWrapped() {
        return this.wrapped;
    }

    public Extent getBypassHistory() {
        return this.bypassHistory;
    }

    public Extent getBypassAll() {
        return this.bypassAll;
    }

    @Nonnull
    public FaweLimit getLimit() {
        return this.limit;
    }

    public AbstractChangeSet getChangeTask() {
        return this.changeTask;
    }

    public Extent getExtent() {
        return this.extent != null ? this.extent : this.world;
    }

    private Extent wrapExtent(Extent extent, EventBus eventBus, EditSessionEvent event, EditSession.Stage stage) {
        event = event.clone(stage);
        event.setExtent(extent);
        eventBus.post(event);
        if (event.isCancelled()) {
            return new com.fastasyncworldedit.core.extent.NullExtent(extent, FaweCache.MANUAL);
        }
        Extent toReturn = event.getExtent();
        if (toReturn instanceof NullExtent) {
            return new com.fastasyncworldedit.core.extent.NullExtent(toReturn, FaweCache.MANUAL);
        }
        if (toReturn != extent) {
            String className = toReturn.getClass().getName().toLowerCase(Locale.ROOT);
            for (String allowed : Settings.settings().EXTENT.ALLOWED_PLUGINS) {
                if (!className.contains(allowed.toLowerCase(Locale.ROOT))) continue;
                this.wrapped = true;
                return toReturn;
            }
            if (Settings.settings().EXTENT.DEBUG) {
                if (event.getActor() != null) {
                    event.getActor().printDebug((Component)TextComponent.of((String)("Potentially unsafe extent blocked: " + toReturn.getClass().getName())));
                    event.getActor().print((Component)TextComponent.of((String)"- For area restrictions and block logging, it is recommended that third party plugins use the FAWE API"));
                    event.getActor().print((Component)TextComponent.of((String)"- Add the following line to the `allowed-plugins` list in the FAWE config.yml to let FAWE recognize the extent:"));
                    event.getActor().print(toReturn.getClass().getName());
                } else {
                    LOGGER.warn("Potentially unsafe extent blocked: {}", (Object)toReturn.getClass().getName());
                    LOGGER.warn(" - For area restrictions and block logging, it is recommended that third party plugins use the FAWE API");
                    LOGGER.warn(" - Add the following classpath to the `allowed-plugins` list in the FAWE config.yml to let FAWE recognize the extent:");
                    LOGGER.warn(toReturn.getClass().getName());
                }
            }
        }
        return extent;
    }
}

