/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.BrushCommands;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.annotation.PatternList;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.annotation.ClipboardMask;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.factory.RegionFactory;
import com.sk89q.worldedit.util.TreeGenerator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class BrushCommandsRegistration
implements CommandRegistration<BrushCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Expression> expression_Key = Key.of(Expression.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Boolean> boolean_Key = Key.of(Boolean.class);
    private static final Key<Double> double_Key = Key.of(Double.class);
    private static final Key<Vector3> vector3_Key = Key.of(Vector3.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Pattern> pattern_patternList_Key = Key.of(Pattern.class, PatternList.class);
    private static final Key<RegionFactory> regionFactory_Key = Key.of(RegionFactory.class);
    private static final Key<TreeGenerator.TreeType> treeType_Key = Key.of(TreeGenerator.TreeType.class);
    private static final Key<Mask> mask_clipboardMask_Key = Key.of(Mask.class, ClipboardMask.class);
    private static final Key<InjectedValueAccess> injectedValueAccess_Key = Key.of(InjectedValueAccess.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private CommandManager commandManager;
    private BrushCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument radiusPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to sample for blending")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument minFreqDiffPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"minFreqDiff"), (Component)TextComponent.of((String)"Minimum difference in frequency to change block")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag onlyAirPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Compare only air vs existing blocks")).build();
    private final ArgAcceptingCommandFlag maskPart = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Mask to limit blocks being considered")).withRequiredArg().argNamed(TranslatableComponent.of((String)"mask")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument radiusPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius for eroding")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument erodefacesPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"erodefaces"), (Component)TextComponent.of((String)"erodeFaces")).defaultsTo((Iterable)ImmutableList.of((Object)"2")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument erodeRecPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"erodeRec"), (Component)TextComponent.of((String)"erodeRec")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument fillFacesPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"fillFaces"), (Component)TextComponent.of((String)"fillFaces")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument fillRecPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"fillRec"), (Component)TextComponent.of((String)"fillRec")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument erodefacesPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"erodefaces"), (Component)TextComponent.of((String)"erodeFaces")).defaultsTo((Iterable)ImmutableList.of((Object)"6")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument erodeRecPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"erodeRec"), (Component)TextComponent.of((String)"erodeRec")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument fillFacesPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"fillFaces"), (Component)TextComponent.of((String)"fillFaces")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument fillPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"fill"), (Component)TextComponent.of((String)"Pattern")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument filledPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"filled"), (Component)TextComponent.of((String)"Whether the circle should be filled")).defaultsTo((Iterable)ImmutableList.of((Object)"false")).ofTypes((Collection)ImmutableList.of(boolean_Key)).build();
    private final NoArgCommandFlag depthFirstPart = CommandParts.flag((char)'d', (Component)TextComponent.of((String)"Apply in depth first order")).build();
    private final CommandArgument radiusPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to sample for blending")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final NoArgCommandFlag shellPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Create only a shell")).build();
    private final NoArgCommandFlag selectPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Selects the clicked point after drawing")).build();
    private final NoArgCommandFlag flatPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Create a flat line")).build();
    private final CommandArgument radiusPart4 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to sample for blending")).defaultsTo((Iterable)ImmutableList.of((Object)"25")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument copiesPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"copies"), (Component)TextComponent.of((String)"int")).defaultsTo((Iterable)ImmutableList.of((Object)"-1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument lengthFactorPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"lengthFactor"), (Component)TextComponent.of((String)"Length of wire compared to distance between points")).defaultsTo((Iterable)ImmutableList.of((Object)"1.2")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag selectPart2 = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Select the clicked point after drawing")).build();
    private final NoArgCommandFlag facingDirectionPart = CommandParts.flag((char)'d', (Component)TextComponent.of((String)"sags the catenary toward the facing direction")).build();
    private final CommandArgument tensionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"tension"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument biasPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"bias"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument continuityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"continuity"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument qualityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"quality"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"10")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument radiusPart5 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"radii to multiply x,y,z by")).defaultsTo((Iterable)ImmutableList.of((Object)"10")).ofTypes((Collection)ImmutableList.of(vector3_Key)).build();
    private final CommandArgument sphericityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"roundness"), (Component)TextComponent.of((String)"roundness")).defaultsTo((Iterable)ImmutableList.of((Object)"100")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument frequencyPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"frequency"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"30")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument amplitudePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"amplitude"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"50")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument radiusPart6 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to sample for blending")).defaultsTo((Iterable)ImmutableList.of((Object)"10")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument countPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"count"), (Component)TextComponent.of((String)"Lines")).defaultsTo((Iterable)ImmutableList.of((Object)"10")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument radiusPart7 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"Expression")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument imagePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"image"), (Component)TextComponent.of((String)"String")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument rotationPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"rotation"), (Component)TextComponent.of((String)"rotation")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument yscalePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"yscale"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag onlyWhitePart = CommandParts.flag((char)'w', (Component)TextComponent.of((String)"Apply at maximum saturation")).build();
    private final NoArgCommandFlag randomRotatePart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Apply random rotation")).build();
    private final CommandArgument imageURLPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"imageURL"), (Component)TextComponent.of((String)"Image URL (imgur only)")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument radiusPart8 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The size of the brush")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument yscalePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"yscale"), (Component)TextComponent.of((String)"scale height")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag alphaPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Use image Alpha")).build();
    private final NoArgCommandFlag fadeOutPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Blend the image with existing terrain")).build();
    private final CommandArgument radiusPart9 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"radius")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument pointsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"points"), (Component)TextComponent.of((String)"points")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument distancePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"distance"), (Component)TextComponent.of((String)"distance")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag overlayPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Overlay the block")).build();
    private final CommandArgument maskPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"Mask")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument clipboardStrPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"clipboard"), (Component)TextComponent.of((String)"Clipboard uri")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument radiusPart10 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"Expression")).defaultsTo((Iterable)ImmutableList.of((Object)"30")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument densityPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"50")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag rotatePart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Apply random rotation")).build();
    private final CommandArgument radiusPart11 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"Expression")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument patternLayersPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"patternLayers"), (Component)TextComponent.of((String)"List of comma-separated patterns")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_patternList_Key)).build();
    private final CommandArgument pointsPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"points"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument recursionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"recursion"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument solidPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"solid"), (Component)TextComponent.of((String)"boolean")).defaultsTo((Iterable)ImmutableList.of((Object)"true")).ofTypes((Collection)ImmutableList.of(boolean_Key)).build();
    private final CommandArgument radiusPart12 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The minimum distance between each point")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument distancePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"distance"), (Component)TextComponent.of((String)"double")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument commandStrPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"commandStr"), (Component)TextComponent.of((String)"List of comma-separated commands")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag printPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Show any printed output")).build();
    private final NoArgCommandFlag randomRotatePart2 = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Random off-axis rotation")).build();
    private final NoArgCommandFlag layersPart = CommandParts.flag((char)'l', (Component)TextComponent.of((String)"Work on snow layers")).build();
    private final NoArgCommandFlag dontSmoothPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Disable smoothing")).build();
    private final NoArgCommandFlag randomRotatePart3 = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Enables random off-axis rotation")).build();
    private final NoArgCommandFlag layersPart2 = CommandParts.flag((char)'l', (Component)TextComponent.of((String)"Will work on snow layers")).build();
    private final NoArgCommandFlag dontSmoothPart2 = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Disables smoothing")).build();
    private final NoArgCommandFlag randomRotatePart4 = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Apply random rotation on paste")).build();
    private final NoArgCommandFlag autoRotatePart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Apply auto view based rotation on paste")).build();
    private final CommandArgument inputPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"input"), (Component)TextComponent.of((String)"Command to run")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument namePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"name"), (Component)TextComponent.of((String)"String name")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag rootPart = CommandParts.flag((char)'g', (Component)TextComponent.of((String)"Save the brush globally")).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Prints the requested page")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument shapePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"shape"), (Component)TextComponent.of((String)"The shape of the region")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(regionFactory_Key)).build();
    private final CommandArgument radiusPart13 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The size of the brush")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument expressionPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"expression"), (Component)TextComponent.of((String)"Expression to apply")).defaultsTo((Iterable)ImmutableList.of((Object)"y-=0.2")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag useRawCoordsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Use the game's coordinate origin")).build();
    private final NoArgCommandFlag usePlacementPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Use the placement position as the origin")).build();
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to set")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument densityPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"density"), (Component)TextComponent.of((String)"The density of the brush")).defaultsTo((Iterable)ImmutableList.of((Object)"20")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final CommandArgument typePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"type"), (Component)TextComponent.of((String)"The type of tree to use")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(treeType_Key)).build();
    private final NoArgCommandFlag stackPart = CommandParts.flag((char)'s', (Component)TextComponent.of((String)"Whether to stack snow")).build();
    private final CommandArgument radiusPart14 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the sphere")).defaultsTo((Iterable)ImmutableList.of((Object)"2")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final NoArgCommandFlag hollowPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Create hollow spheres instead")).build();
    private final NoArgCommandFlag fallingPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Create falling spheres instead")).build();
    private final CommandArgument radiusPart15 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius of the cylinder")).defaultsTo((Iterable)ImmutableList.of((Object)"2")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument heightPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"height"), (Component)TextComponent.of((String)"The height of the cylinder")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument thicknessPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"thickness"), (Component)TextComponent.of((String)"The thickness of the cylinder. Requires -h switch be given. 0 creates a standard hollow cylinder.")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(double_Key)).build();
    private final NoArgCommandFlag hollowPart2 = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Create hollow cylinders instead")).build();
    private final NoArgCommandFlag ignoreAirPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Don't paste air from the clipboard")).build();
    private final NoArgCommandFlag usingOriginPart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Paste starting at the target location, instead of centering on it")).build();
    private final NoArgCommandFlag pasteEntitiesPart = CommandParts.flag((char)'e', (Component)TextComponent.of((String)"Paste entities if available")).build();
    private final NoArgCommandFlag pasteBiomesPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Paste biomes if available")).build();
    private final ArgAcceptingCommandFlag sourceMaskPart = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"Skip blocks matching this mask in the clipboard")).withRequiredArg().argNamed(TranslatableComponent.of((String)"sourceMask")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mask_clipboardMask_Key)).build();
    private final CommandArgument radiusPart16 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to sample for softening")).defaultsTo((Iterable)ImmutableList.of((Object)"2")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument iterationsPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"iterations"), (Component)TextComponent.of((String)"The number of iterations to perform")).defaultsTo((Iterable)ImmutableList.of((Object)"4")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskPart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mask"), (Component)TextComponent.of((String)"The mask of blocks to use for the heightmap")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument iterationsPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"iterations"), (Component)TextComponent.of((String)"The number of iterations to perform")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final ArgAcceptingCommandFlag snowBlockCountPart = CommandParts.flag((char)'l', (Component)TextComponent.of((String)"The number of snow blocks under snow")).withRequiredArg().argNamed(TranslatableComponent.of((String)"snowBlockCount")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final ArgAcceptingCommandFlag maskPart4 = CommandParts.flag((char)'m', (Component)TextComponent.of((String)"The mask of blocks to use for the heightmap")).withRequiredArg().argNamed(TranslatableComponent.of((String)"mask")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument radiusPart17 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to extinguish")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final CommandArgument radiusPart18 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"The radius to apply gravity in")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final NoArgCommandFlag fromMaxYPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Affect blocks starting at max Y, rather than the target location Y + radius")).build();
    private final CommandArgument radiusPart19 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"radius"), (Component)TextComponent.of((String)"Radius to kill mobs in")).defaultsTo((Iterable)ImmutableList.of((Object)"5")).ofTypes((Collection)ImmutableList.of(expression_Key)).build();
    private final NoArgCommandFlag killPetsPart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Also kill pets")).build();
    private final NoArgCommandFlag killNpcsPart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"Also kill NPCs")).build();
    private final NoArgCommandFlag killGolemsPart = CommandParts.flag((char)'g', (Component)TextComponent.of((String)"Also kill golems")).build();
    private final NoArgCommandFlag killAnimalsPart = CommandParts.flag((char)'a', (Component)TextComponent.of((String)"Also kill animals")).build();
    private final NoArgCommandFlag killAmbientPart = CommandParts.flag((char)'b', (Component)TextComponent.of((String)"Also kill ambient mobs")).build();
    private final NoArgCommandFlag killWithNamePart = CommandParts.flag((char)'t', (Component)TextComponent.of((String)"Also kill mobs with name tags")).build();
    private final NoArgCommandFlag killFriendlyPart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Also kill all friendly mobs (Applies the flags `-abgnpt`)")).build();
    private final NoArgCommandFlag killArmorStandsPart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Also destroy armor stands")).build();
    private final NoArgCommandFlag killWaterPart = CommandParts.flag((char)'w', (Component)TextComponent.of((String)"Also kill water mobs")).build();

    private BrushCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static BrushCommandsRegistration builder() {
        return new BrushCommandsRegistration();
    }

    public BrushCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public BrushCommandsRegistration containerInstance(BrushCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public BrushCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public BrushCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("blendball", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"bb", (Object)"blend"));
            b.description((Component)TextComponent.of((String)"Smooths and blends terrain"));
            b.footer((Component)TextComponent.of((String)"Smooths and blends terrain\nPic: https://i.imgur.com/cNUQUkj.png \u2192 https://i.imgur.com/hFOFsNf.png"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart, (Object)this.minFreqDiffPart, (Object)this.onlyAirPart, (Object)this.maskPart));
            b.action(this::cmd$blendball);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"blendBallBrush", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, Integer.TYPE, Boolean.TYPE, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("erode", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Erodes terrain"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart2, (Object)this.erodefacesPart, (Object)this.erodeRecPart, (Object)this.fillFacesPart, (Object)this.fillRecPart));
            b.action(this::cmd$erode);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"erodeBrush", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("pull", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Pull terrain towards you"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart, (Object)this.erodefacesPart2, (Object)this.erodeRecPart2, (Object)this.fillFacesPart2, (Object)this.fillRecPart));
            b.action(this::cmd$pull);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"pullBrush", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("circle", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Creates a circle, which revolves around your facing direction"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart, (Object)this.filledPart));
            b.action(this::cmd$circle);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"circleBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("recursive", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"recurse", (Object)"r"));
            b.description((Component)TextComponent.of((String)"Set all connected blocks"));
            b.footer((Component)TextComponent.of((String)"Set all connected blocks\nNote: Set a mask to recurse along specific blocks"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart, (Object)this.depthFirstPart));
            b.action(this::cmd$recursive);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"recursiveBrush", (Class[])new Class[]{InjectedValueAccess.class, EditSession.class, Pattern.class, Expression.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("line", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"l"));
            b.description((Component)TextComponent.of((String)"Create lines"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart3, (Object)this.shellPart, (Object)this.selectPart, (Object)this.flatPart));
            b.action(this::cmd$line);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"lineBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("spline", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"spl", (Object)"curve"));
            b.description((Component)TextComponent.of((String)"Join multiple objects together in a curve"));
            b.footer((Component)TextComponent.of((String)"Click to select some objects,click the same block twice to connect the objects.\nInsufficient brush radius, or clicking the the wrong spot will result in undesired shapes. The shapes must be simple lines or loops.\nPic1: http://i.imgur.com/CeRYAoV.jpg -> http://i.imgur.com/jtM0jA4.png\nPic2: http://i.imgur.com/bUeyc72.png -> http://i.imgur.com/tg6MkcF.pngTutorial: https://www.planetminecraft.com/blog/fawe-tutorial/"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart4));
            b.action(this::cmd$spline);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"splineBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Pattern.class, Expression.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("sweep", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"sw", (Object)"vaesweep"));
            b.description((Component)TextComponent.of((String)"Sweep your clipboard content along a curve"));
            b.footer((Component)TextComponent.of((String)"Sweeps your clipboard content along a curve.\nDefine a curve by selecting the individual points with a brush\nSet [copies] to a value > 0 if you want to have your selection pasted a limited amount of times equally spaced on the curve"));
            b.parts((Collection)ImmutableList.of((Object)this.copiesPart));
            b.action(this::cmd$sweep);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"sweepBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("catenary", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"cat", (Object)"gravityline", (Object)"saggedline"));
            b.description((Component)TextComponent.of((String)"Create a hanging line between two points"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.lengthFactorPart, (Object)this.radiusPart3, (Object)this.shellPart, (Object)this.selectPart2, (Object)this.facingDirectionPart));
            b.action(this::cmd$catenary);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"catenaryBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Double.TYPE, Expression.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("surfacespline", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"sspline", (Object)"sspl"));
            b.description((Component)TextComponent.of((String)"Draws a spline (curved line) on the surface"));
            b.footer((Component)TextComponent.of((String)"Create a spline on the surface\nVideo: https://www.youtube.com/watch?v=CukvVOi4jv8"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart3, (Object)this.tensionPart, (Object)this.biasPart, (Object)this.continuityPart, (Object)this.qualityPart));
            b.action(this::cmd$surfacespline);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"surfaceSpline", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Pattern.class, Expression.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("rock", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"blob"));
            b.description((Component)TextComponent.of((String)"Creates a distorted sphere"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart5, (Object)this.sphericityPart, (Object)this.frequencyPart, (Object)this.amplitudePart));
            b.action(this::cmd$rock);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"blobBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Vector3.class, Double.TYPE, Double.TYPE, Double.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("shatter", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"partition", (Object)"split"));
            b.description((Component)TextComponent.of((String)"Creates random lines to break the terrain into pieces"));
            b.footer((Component)TextComponent.of((String)"Creates uneven lines separating terrain into multiple pieces\nPic: https://i.imgur.com/2xKsZf2.png"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart6, (Object)this.countPart));
            b.action(this::cmd$shatter);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"shatterBrush", (Class[])new Class[]{EditSession.class, InjectedValueAccess.class, Pattern.class, Expression.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("stencil", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Use a height map to paint a surface"));
            b.footer((Component)TextComponent.of((String)"Use a height map to paint any surface."));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart7, (Object)this.imagePart, (Object)this.rotationPart, (Object)this.yscalePart, (Object)this.onlyWhitePart, (Object)this.randomRotatePart));
            b.action(this::cmd$stencil);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"stencilBrush", (Class[])new Class[]{Player.class, LocalSession.class, InjectedValueAccess.class, Pattern.class, Expression.class, String.class, Integer.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("image", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Use a height map to paint a surface"));
            b.footer((Component)TextComponent.of((String)"Use a height map to paint any surface.\n"));
            b.parts((Collection)ImmutableList.of((Object)this.imageURLPart, (Object)this.radiusPart8, (Object)this.yscalePart2, (Object)this.alphaPart, (Object)this.fadeOutPart));
            b.action(this::cmd$image);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"imageBrush", (Class[])new Class[]{LocalSession.class, InjectedValueAccess.class, String.class, Expression.class, Double.TYPE, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("surface", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"surf"));
            b.description((Component)TextComponent.of((String)"Use a height map to paint a surface"));
            b.footer((Component)TextComponent.of((String)"Use a height map to paint any surface."));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart7));
            b.action(this::cmd$surface);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"surfaceBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("scatter", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Scatter a pattern on a surface"));
            b.footer((Component)TextComponent.of((String)"Set a number of blocks randomly on a surface each a certain distance apart.\nVideo: https://youtu.be/RPZIaTbqoZw?t=34s"));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart9, (Object)this.pointsPart, (Object)this.distancePart, (Object)this.overlayPart));
            b.action(this::cmd$scatter);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"scatterBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Double.TYPE, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("populateschematic", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"populateschem", (Object)"popschem", (Object)"pschem", (Object)"ps"));
            b.description((Component)TextComponent.of((String)"Scatter a schematic on a surface"));
            b.parts((Collection)ImmutableList.of((Object)this.maskPart2, (Object)this.clipboardStrPart, (Object)this.radiusPart10, (Object)this.densityPart, (Object)this.rotatePart));
            b.action(this::cmd$populateschematic);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"scatterSchemBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Mask.class, String.class, Expression.class, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("layer", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Replaces terrain with a layer."));
            b.footer((Component)TextComponent.of((String)"Replaces terrain with a layer.\nExample: /br layer 5 oak_planks,orange_stained_glass,magenta_stained_glass,black_wool - Places several layers on a surface\nPic: https://i.imgur.com/XV0vYoX.png"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart11, (Object)this.patternLayersPart));
            b.action(this::cmd$layer);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"surfaceLayer", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("splatter", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Splatter a pattern on a surface"));
            b.footer((Component)TextComponent.of((String)"Sets a bunch of blocks randomly on a surface.\nPic: https://i.imgur.com/hMD29oO.png\nExample: /br splatter stone,dirt 30 15\nNote: The seeds define how many splotches there are, recursion defines how large, solid defines whether the pattern is applied per seed, else per block."));
            b.parts((Collection)ImmutableList.of((Object)this.fillPart, (Object)this.radiusPart7, (Object)this.pointsPart2, (Object)this.recursionPart, (Object)this.solidPart));
            b.action(this::cmd$splatter);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"splatterBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Double.TYPE, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("scattercommand", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"scattercmd", (Object)"scmd", (Object)"scommand"));
            b.description((Component)TextComponent.of((String)"Run commands at random points on a surface"));
            b.footer((Component)TextComponent.of((String)"Run commands at random points on a surface\n - Your selection will be expanded to the specified size around each point\n - Placeholders: {x}, {y}, {z}, {world}, {size}"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart12, (Object)this.pointsPart2, (Object)this.distancePart2, (Object)this.commandStrPart, (Object)this.printPart));
            b.action(this::cmd$scattercommand);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"scatterCommandBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Expression.class, Double.TYPE, Double.TYPE, List.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("height", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"heightmap"));
            b.description((Component)TextComponent.of((String)"Raise or lower terrain using a heightmap"));
            b.footer((Component)TextComponent.of((String)"This brush raises and lowers land.\nNote: Use a negative yscale to reduce height\nSnow Pic: https://i.imgur.com/Hrzn0I4.png"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart7, (Object)this.yscalePart, (Object)this.imagePart, (Object)this.rotationPart, (Object)this.randomRotatePart2, (Object)this.layersPart, (Object)this.dontSmoothPart));
            b.action(this::cmd$height);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"heightBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, Double.TYPE, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, InjectedValueAccess.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("cliff", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"flatcylinder"));
            b.description((Component)TextComponent.of((String)"Cliff brush"));
            b.footer((Component)TextComponent.of((String)"This brush flattens terrain and creates cliffs."));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart7, (Object)this.imagePart, (Object)this.rotationPart, (Object)this.yscalePart, (Object)this.randomRotatePart3, (Object)this.layersPart2, (Object)this.dontSmoothPart2));
            b.action(this::cmd$cliff);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"cliffBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, String.class, Integer.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, InjectedValueAccess.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("flatten", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"flatmap", (Object)"flat"));
            b.description((Component)TextComponent.of((String)"This brush raises or lowers land towards the clicked point"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart7, (Object)this.imagePart, (Object)this.rotationPart, (Object)this.yscalePart, (Object)this.randomRotatePart3, (Object)this.layersPart2, (Object)this.dontSmoothPart2));
            b.action(this::cmd$flatten);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"flattenBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, String.class, Integer.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, InjectedValueAccess.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("copypaste", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"cp", (Object)"copypasta"));
            b.description((Component)TextComponent.of((String)"Copy Paste brush"));
            b.footer((Component)TextComponent.of((String)"Left click the base of an object to copy.\nRight click to paste\nNote: Works well with the clipboard scroll action\nVideo: https://www.youtube.com/watch?v=RPZIaTbqoZw"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart7, (Object)this.randomRotatePart4, (Object)this.autoRotatePart));
            b.action(this::cmd$copypaste);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"copy", (Class[])new Class[]{Player.class, LocalSession.class, InjectedValueAccess.class, Expression.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("command", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"cmd"));
            b.description((Component)TextComponent.of((String)"Command brush"));
            b.footer((Component)TextComponent.of((String)"Run the commands at the clicked position.\n - Your selection will be expanded to the specified size around each point\n - Placeholders: {x}, {y}, {z}, {world}, {size}"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart11, (Object)this.inputPart));
            b.action(this::cmd$command);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"command", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("savebrush", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"save"));
            b.description((Component)TextComponent.of((String)"Save your current brush"));
            b.parts((Collection)ImmutableList.of((Object)this.namePart, (Object)this.rootPart));
            b.action(this::cmd$savebrush);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"saveBrush", (Class[])new Class[]{Player.class, LocalSession.class, String.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/listbrush", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"List saved brushes"));
            b.footer((Component)TextComponent.of((String)"List all brushes in the brush directory"));
            b.parts((Collection)ImmutableList.of((Object)this.pagePart));
            b.action(this::cmd$_listbrush);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"list", (Class[])new Class[]{Actor.class, InjectedValueAccess.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("deform", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Deform brush, applies an expression to an area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart13, (Object)this.expressionPart, (Object)this.useRawCoordsPart, (Object)this.usePlacementPart));
            b.action(this::cmd$deform);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"deform", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, String.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("set", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set brush, sets all blocks in the area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart8, (Object)this.patternPart));
            b.action(this::cmd$set);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"set", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Expression.class, Pattern.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("forest", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Forest brush, creates a forest in the area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart8, (Object)this.densityPart2, (Object)this.typePart));
            b.action(this::cmd$forest);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"forest", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Expression.class, Double.TYPE, TreeGenerator.TreeType.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("raise", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Raise brush, raise all blocks by one"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart8));
            b.action(this::cmd$raise);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"raise", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Expression.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("lower", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Lower brush, lower all blocks by one"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart8));
            b.action(this::cmd$lower);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"lower", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Expression.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("snow", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Snow brush, sets snow in the area"));
            b.parts((Collection)ImmutableList.of((Object)this.shapePart, (Object)this.radiusPart13, (Object)this.stackPart));
            b.action(this::cmd$snow);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"snow", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("sphere", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"s"));
            b.description((Component)TextComponent.of((String)"Choose the sphere brush"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiusPart14, (Object)this.hollowPart, (Object)this.fallingPart));
            b.action(this::cmd$sphere);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"sphereBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Pattern.class, Expression.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("cylinder", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"cyl", (Object)"c"));
            b.description((Component)TextComponent.of((String)"Choose the cylinder brush"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.radiusPart15, (Object)this.heightPart, (Object)this.thicknessPart, (Object)this.hollowPart2));
            b.action(this::cmd$cylinder);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"cylinderBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Integer.TYPE, Double.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("clipboard", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"@Deprecated use instead: `/br copypaste`)"));
            b.footer((Component)TextComponent.of((String)"Choose the clipboard brush.\nWithout the -o flag, the paste will appear centered at the target location. With the flag, then the paste will appear relative to where you had stood relative to the copied area when you copied it."));
            b.parts((Collection)ImmutableList.of((Object)this.ignoreAirPart, (Object)this.usingOriginPart, (Object)this.pasteEntitiesPart, (Object)this.pasteBiomesPart, (Object)this.sourceMaskPart));
            b.action(this::cmd$clipboard);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"clipboardBrush", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class, InjectedValueAccess.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("smooth", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Choose the terrain softener brush"));
            b.footer((Component)TextComponent.of((String)"Example: '/brush smooth 2 4 grass_block,dirt,stone'"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart16, (Object)this.iterationsPart, (Object)this.maskPart3));
            b.action(this::cmd$smooth);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"smoothBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, Integer.TYPE, Mask.class, InjectedValueAccess.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("snowsmooth", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Choose the snow terrain softener brush"));
            b.footer((Component)TextComponent.of((String)"Example: '/brush snowsmooth 5 1 -l 3'"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart16, (Object)this.iterationsPart2, (Object)this.snowBlockCountPart, (Object)this.maskPart4));
            b.action(this::cmd$snowsmooth);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"snowSmoothBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, Integer.TYPE, Integer.TYPE, Mask.class, InjectedValueAccess.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("extinguish", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"ex"));
            b.description((Component)TextComponent.of((String)"Shortcut fire extinguisher brush"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart17));
            b.action(this::cmd$extinguish);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"extinguishBrush", (Class[])new Class[]{InjectedValueAccess.class, EditSession.class, Expression.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("gravity", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"grav"));
            b.description((Component)TextComponent.of((String)"Gravity brush, simulates the effect of gravity"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart18, (Object)this.fromMaxYPart));
            b.action(this::cmd$gravity);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"gravityBrush", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("butcher", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"kill"));
            b.description((Component)TextComponent.of((String)"Butcher brush, kills mobs within a radius"));
            b.parts((Collection)ImmutableList.of((Object)this.radiusPart19, (Object)this.killPetsPart, (Object)this.killNpcsPart, (Object)this.killGolemsPart, (Object)this.killAnimalsPart, (Object)this.killAmbientPart, (Object)this.killWithNamePart, (Object)this.killFriendlyPart, (Object)this.killArmorStandsPart, (Object)this.killWaterPart));
            b.action(this::cmd$butcher);
            Method commandMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"butcherBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, InjectedValueAccess.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$blendball(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"blendBallBrush", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, Integer.TYPE, Boolean.TYPE, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.blendBallBrush(this.extract$context(parameters), this.extract$radius(parameters), this.extract$minFreqDiff(parameters), this.extract$onlyAir(parameters), this.extract$mask(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$erode(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"erodeBrush", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.erodeBrush(this.extract$context(parameters), this.extract$radius2(parameters), this.extract$erodefaces(parameters), this.extract$erodeRec(parameters), this.extract$fillFaces(parameters), this.extract$fillRec(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$pull(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"pullBrush", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.pullBrush(this.extract$context(parameters), this.extract$radius(parameters), this.extract$erodefaces2(parameters), this.extract$erodeRec2(parameters), this.extract$fillFaces2(parameters), this.extract$fillRec(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$circle(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"circleBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.circleBrush(this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius(parameters), this.extract$filled(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$recursive(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"recursiveBrush", (Class[])new Class[]{InjectedValueAccess.class, EditSession.class, Pattern.class, Expression.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.recursiveBrush(this.extract$context(parameters), this.extract$editSession(parameters), this.extract$fill(parameters), this.extract$radius(parameters), this.extract$depthFirst(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$line(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"lineBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.lineBrush(this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius3(parameters), this.extract$shell(parameters), this.extract$select(parameters), this.extract$flat(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$spline(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"splineBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Pattern.class, Expression.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.splineBrush(this.extract$player(parameters), this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius4(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$sweep(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"sweepBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.sweepBrush(this.extract$player(parameters), this.extract$context(parameters), this.extract$copies(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$catenary(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"catenaryBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Double.TYPE, Expression.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.catenaryBrush(this.extract$context(parameters), this.extract$fill(parameters), this.extract$lengthFactor(parameters), this.extract$radius3(parameters), this.extract$shell(parameters), this.extract$select2(parameters), this.extract$facingDirection(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$surfacespline(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"surfaceSpline", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Pattern.class, Expression.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.surfaceSpline(this.extract$player(parameters), this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius3(parameters), this.extract$tension(parameters), this.extract$bias(parameters), this.extract$continuity(parameters), this.extract$quality(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$rock(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"blobBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Vector3.class, Double.TYPE, Double.TYPE, Double.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.blobBrush(this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius5(parameters), this.extract$sphericity(parameters), this.extract$frequency(parameters), this.extract$amplitude(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$shatter(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"shatterBrush", (Class[])new Class[]{EditSession.class, InjectedValueAccess.class, Pattern.class, Expression.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.shatterBrush(this.extract$editSession(parameters), this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius6(parameters), this.extract$count(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$stencil(CommandParameters parameters) throws WorldEditException, FileNotFoundException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"stencilBrush", (Class[])new Class[]{Player.class, LocalSession.class, InjectedValueAccess.class, Pattern.class, Expression.class, String.class, Integer.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.stencilBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius7(parameters), this.extract$image(parameters), this.extract$rotation(parameters), this.extract$yscale(parameters), this.extract$onlyWhite(parameters), this.extract$randomRotate(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$image(CommandParameters parameters) throws WorldEditException, IOException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"imageBrush", (Class[])new Class[]{LocalSession.class, InjectedValueAccess.class, String.class, Expression.class, Double.TYPE, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.imageBrush(this.extract$session(parameters), this.extract$context(parameters), this.extract$imageURL(parameters), this.extract$radius8(parameters), this.extract$yscale2(parameters), this.extract$alpha(parameters), this.extract$fadeOut(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$surface(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"surfaceBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.surfaceBrush(this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius7(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$scatter(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"scatterBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Double.TYPE, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.scatterBrush(this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius9(parameters), this.extract$points(parameters), this.extract$distance(parameters), this.extract$overlay(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$populateschematic(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"scatterSchemBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Mask.class, String.class, Expression.class, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.scatterSchemBrush(this.extract$player(parameters), this.extract$context(parameters), this.extract$mask2(parameters), this.extract$clipboardStr(parameters), this.extract$radius10(parameters), this.extract$density(parameters), this.extract$rotate(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$layer(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"surfaceLayer", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.surfaceLayer(this.extract$context(parameters), this.extract$radius11(parameters), this.extract$patternLayers(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$splatter(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"splatterBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Double.TYPE, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.splatterBrush(this.extract$context(parameters), this.extract$fill(parameters), this.extract$radius7(parameters), this.extract$points2(parameters), this.extract$recursion(parameters), this.extract$solid(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$scattercommand(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"scatterCommandBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Expression.class, Double.TYPE, Double.TYPE, List.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.scatterCommandBrush(this.extract$player(parameters), this.extract$context(parameters), this.extract$radius12(parameters), this.extract$points2(parameters), this.extract$distance2(parameters), this.extract$commandStr(parameters), this.extract$print(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$height(CommandParameters parameters) throws WorldEditException, FileNotFoundException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"heightBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, Double.TYPE, String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, InjectedValueAccess.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.heightBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius7(parameters), this.extract$yscale(parameters), this.extract$image(parameters), this.extract$rotation(parameters), this.extract$randomRotate2(parameters), this.extract$layers(parameters), this.extract$dontSmooth(parameters), this.extract$context(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$cliff(CommandParameters parameters) throws WorldEditException, FileNotFoundException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"cliffBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, String.class, Integer.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, InjectedValueAccess.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.cliffBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius7(parameters), this.extract$image(parameters), this.extract$rotation(parameters), this.extract$yscale(parameters), this.extract$randomRotate3(parameters), this.extract$layers2(parameters), this.extract$dontSmooth2(parameters), this.extract$context(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$flatten(CommandParameters parameters) throws WorldEditException, FileNotFoundException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"flattenBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, String.class, Integer.TYPE, Double.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, InjectedValueAccess.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.flattenBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius7(parameters), this.extract$image(parameters), this.extract$rotation(parameters), this.extract$yscale(parameters), this.extract$randomRotate3(parameters), this.extract$layers2(parameters), this.extract$dontSmooth2(parameters), this.extract$context(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$copypaste(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"copy", (Class[])new Class[]{Player.class, LocalSession.class, InjectedValueAccess.class, Expression.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.copy(this.extract$player(parameters), this.extract$session(parameters), this.extract$context(parameters), this.extract$radius7(parameters), this.extract$randomRotate4(parameters), this.extract$autoRotate(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$command(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"command", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.command(this.extract$context(parameters), this.extract$radius11(parameters), this.extract$input(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$savebrush(CommandParameters parameters) throws WorldEditException, IOException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"saveBrush", (Class[])new Class[]{Player.class, LocalSession.class, String.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.saveBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$name(parameters), this.extract$root(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_listbrush(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"list", (Class[])new Class[]{Actor.class, InjectedValueAccess.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.list(this.extract$actor(parameters), this.extract$args(parameters), this.extract$page(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$deform(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"deform", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, String.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.deform(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius13(parameters), this.extract$expression(parameters), this.extract$useRawCoords(parameters), this.extract$usePlacement(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$set(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"set", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Expression.class, Pattern.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.set(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius8(parameters), this.extract$pattern(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$forest(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"forest", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Expression.class, Double.TYPE, TreeGenerator.TreeType.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.forest(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius8(parameters), this.extract$density2(parameters), this.extract$type(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$raise(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"raise", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Expression.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.raise(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius8(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$lower(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"lower", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Expression.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.lower(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius8(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$snow(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"snow", (Class[])new Class[]{Player.class, LocalSession.class, RegionFactory.class, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.snow(this.extract$player(parameters), this.extract$localSession(parameters), this.extract$shape(parameters), this.extract$radius13(parameters), this.extract$stack(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$sphere(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"sphereBrush", (Class[])new Class[]{Player.class, InjectedValueAccess.class, Pattern.class, Expression.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.sphereBrush(this.extract$player(parameters), this.extract$context(parameters), this.extract$pattern(parameters), this.extract$radius14(parameters), this.extract$hollow(parameters), this.extract$falling(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$cylinder(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"cylinderBrush", (Class[])new Class[]{InjectedValueAccess.class, Pattern.class, Expression.class, Integer.TYPE, Double.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.cylinderBrush(this.extract$context(parameters), this.extract$pattern(parameters), this.extract$radius15(parameters), this.extract$height(parameters), this.extract$thickness(parameters), this.extract$hollow2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$clipboard(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"clipboardBrush", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Mask.class, InjectedValueAccess.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.clipboardBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$ignoreAir(parameters), this.extract$usingOrigin(parameters), this.extract$pasteEntities(parameters), this.extract$pasteBiomes(parameters), this.extract$sourceMask(parameters), this.extract$context(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$smooth(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"smoothBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, Integer.TYPE, Mask.class, InjectedValueAccess.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.smoothBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius16(parameters), this.extract$iterations(parameters), this.extract$mask3(parameters), this.extract$context(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$snowsmooth(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"snowSmoothBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, Integer.TYPE, Integer.TYPE, Mask.class, InjectedValueAccess.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.snowSmoothBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius16(parameters), this.extract$iterations2(parameters), this.extract$snowBlockCount(parameters), this.extract$mask4(parameters), this.extract$context(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$extinguish(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"extinguishBrush", (Class[])new Class[]{InjectedValueAccess.class, EditSession.class, Expression.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.extinguishBrush(this.extract$context(parameters), this.extract$editSession(parameters), this.extract$radius17(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$gravity(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"gravityBrush", (Class[])new Class[]{InjectedValueAccess.class, Expression.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.gravityBrush(this.extract$context(parameters), this.extract$radius18(parameters), this.extract$fromMaxY(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$butcher(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(BrushCommands.class, (String)"butcherBrush", (Class[])new Class[]{Player.class, LocalSession.class, Expression.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, InjectedValueAccess.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.butcherBrush(this.extract$player(parameters), this.extract$session(parameters), this.extract$radius19(parameters), this.extract$killPets(parameters), this.extract$killNpcs(parameters), this.extract$killGolems(parameters), this.extract$killAnimals(parameters), this.extract$killAmbient(parameters), this.extract$killWithName(parameters), this.extract$killFriendly(parameters), this.extract$killArmorStands(parameters), this.extract$killWater(parameters), this.extract$context(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private InjectedValueAccess extract$context(CommandParameters parameters) {
        return (InjectedValueAccess)RegistrationUtil.requireOptional(injectedValueAccess_Key, (String)"context", (Optional)parameters.injectedValue(injectedValueAccess_Key));
    }

    private Expression extract$radius(CommandParameters parameters) {
        return (Expression)this.radiusPart.value(parameters).asSingle(expression_Key);
    }

    private int extract$minFreqDiff(CommandParameters parameters) {
        return (Integer)this.minFreqDiffPart.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$onlyAir(CommandParameters parameters) {
        return this.onlyAirPart.in(parameters);
    }

    private Mask extract$mask(CommandParameters parameters) {
        return (Mask)this.maskPart.value(parameters).asSingle(mask_Key);
    }

    private Expression extract$radius2(CommandParameters parameters) {
        return (Expression)this.radiusPart2.value(parameters).asSingle(expression_Key);
    }

    private int extract$erodefaces(CommandParameters parameters) {
        return (Integer)this.erodefacesPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$erodeRec(CommandParameters parameters) {
        return (Integer)this.erodeRecPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$fillFaces(CommandParameters parameters) {
        return (Integer)this.fillFacesPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$fillRec(CommandParameters parameters) {
        return (Integer)this.fillRecPart.value(parameters).asSingle(integer_Key);
    }

    private int extract$erodefaces2(CommandParameters parameters) {
        return (Integer)this.erodefacesPart2.value(parameters).asSingle(integer_Key);
    }

    private int extract$erodeRec2(CommandParameters parameters) {
        return (Integer)this.erodeRecPart2.value(parameters).asSingle(integer_Key);
    }

    private int extract$fillFaces2(CommandParameters parameters) {
        return (Integer)this.fillFacesPart2.value(parameters).asSingle(integer_Key);
    }

    private Pattern extract$fill(CommandParameters parameters) {
        return (Pattern)this.fillPart.value(parameters).asSingle(pattern_Key);
    }

    private boolean extract$filled(CommandParameters parameters) {
        return (Boolean)this.filledPart.value(parameters).asSingle(boolean_Key);
    }

    private EditSession extract$editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private boolean extract$depthFirst(CommandParameters parameters) {
        return this.depthFirstPart.in(parameters);
    }

    private Expression extract$radius3(CommandParameters parameters) {
        return (Expression)this.radiusPart3.value(parameters).asSingle(expression_Key);
    }

    private boolean extract$shell(CommandParameters parameters) {
        return this.shellPart.in(parameters);
    }

    private boolean extract$select(CommandParameters parameters) {
        return this.selectPart.in(parameters);
    }

    private boolean extract$flat(CommandParameters parameters) {
        return this.flatPart.in(parameters);
    }

    private Player extract$player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private Expression extract$radius4(CommandParameters parameters) {
        return (Expression)this.radiusPart4.value(parameters).asSingle(expression_Key);
    }

    private int extract$copies(CommandParameters parameters) {
        return (Integer)this.copiesPart.value(parameters).asSingle(integer_Key);
    }

    private double extract$lengthFactor(CommandParameters parameters) {
        return (Double)this.lengthFactorPart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$select2(CommandParameters parameters) {
        return this.selectPart2.in(parameters);
    }

    private boolean extract$facingDirection(CommandParameters parameters) {
        return this.facingDirectionPart.in(parameters);
    }

    private double extract$tension(CommandParameters parameters) {
        return (Double)this.tensionPart.value(parameters).asSingle(double_Key);
    }

    private double extract$bias(CommandParameters parameters) {
        return (Double)this.biasPart.value(parameters).asSingle(double_Key);
    }

    private double extract$continuity(CommandParameters parameters) {
        return (Double)this.continuityPart.value(parameters).asSingle(double_Key);
    }

    private double extract$quality(CommandParameters parameters) {
        return (Double)this.qualityPart.value(parameters).asSingle(double_Key);
    }

    private Vector3 extract$radius5(CommandParameters parameters) {
        return (Vector3)this.radiusPart5.value(parameters).asSingle(vector3_Key);
    }

    private double extract$sphericity(CommandParameters parameters) {
        return (Double)this.sphericityPart.value(parameters).asSingle(double_Key);
    }

    private double extract$frequency(CommandParameters parameters) {
        return (Double)this.frequencyPart.value(parameters).asSingle(double_Key);
    }

    private double extract$amplitude(CommandParameters parameters) {
        return (Double)this.amplitudePart.value(parameters).asSingle(double_Key);
    }

    private Expression extract$radius6(CommandParameters parameters) {
        return (Expression)this.radiusPart6.value(parameters).asSingle(expression_Key);
    }

    private int extract$count(CommandParameters parameters) {
        return (Integer)this.countPart.value(parameters).asSingle(integer_Key);
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private Expression extract$radius7(CommandParameters parameters) {
        return (Expression)this.radiusPart7.value(parameters).asSingle(expression_Key);
    }

    private String extract$image(CommandParameters parameters) {
        return (String)this.imagePart.value(parameters).asSingle(string_Key);
    }

    private int extract$rotation(CommandParameters parameters) {
        return (Integer)this.rotationPart.value(parameters).asSingle(integer_Key);
    }

    private double extract$yscale(CommandParameters parameters) {
        return (Double)this.yscalePart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$onlyWhite(CommandParameters parameters) {
        return this.onlyWhitePart.in(parameters);
    }

    private boolean extract$randomRotate(CommandParameters parameters) {
        return this.randomRotatePart.in(parameters);
    }

    private String extract$imageURL(CommandParameters parameters) {
        return (String)this.imageURLPart.value(parameters).asSingle(string_Key);
    }

    private Expression extract$radius8(CommandParameters parameters) {
        return (Expression)this.radiusPart8.value(parameters).asSingle(expression_Key);
    }

    private double extract$yscale2(CommandParameters parameters) {
        return (Double)this.yscalePart2.value(parameters).asSingle(double_Key);
    }

    private boolean extract$alpha(CommandParameters parameters) {
        return this.alphaPart.in(parameters);
    }

    private boolean extract$fadeOut(CommandParameters parameters) {
        return this.fadeOutPart.in(parameters);
    }

    private Expression extract$radius9(CommandParameters parameters) {
        return (Expression)this.radiusPart9.value(parameters).asSingle(expression_Key);
    }

    private double extract$points(CommandParameters parameters) {
        return (Double)this.pointsPart.value(parameters).asSingle(double_Key);
    }

    private double extract$distance(CommandParameters parameters) {
        return (Double)this.distancePart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$overlay(CommandParameters parameters) {
        return this.overlayPart.in(parameters);
    }

    private Mask extract$mask2(CommandParameters parameters) {
        return (Mask)this.maskPart2.value(parameters).asSingle(mask_Key);
    }

    private String extract$clipboardStr(CommandParameters parameters) {
        return (String)this.clipboardStrPart.value(parameters).asSingle(string_Key);
    }

    private Expression extract$radius10(CommandParameters parameters) {
        return (Expression)this.radiusPart10.value(parameters).asSingle(expression_Key);
    }

    private double extract$density(CommandParameters parameters) {
        return (Double)this.densityPart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$rotate(CommandParameters parameters) {
        return this.rotatePart.in(parameters);
    }

    private Expression extract$radius11(CommandParameters parameters) {
        return (Expression)this.radiusPart11.value(parameters).asSingle(expression_Key);
    }

    private List<Pattern> extract$patternLayers(CommandParameters parameters) {
        return this.patternLayersPart.value(parameters).asMultiple(pattern_patternList_Key);
    }

    private double extract$points2(CommandParameters parameters) {
        return (Double)this.pointsPart2.value(parameters).asSingle(double_Key);
    }

    private double extract$recursion(CommandParameters parameters) {
        return (Double)this.recursionPart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$solid(CommandParameters parameters) {
        return (Boolean)this.solidPart.value(parameters).asSingle(boolean_Key);
    }

    private Expression extract$radius12(CommandParameters parameters) {
        return (Expression)this.radiusPart12.value(parameters).asSingle(expression_Key);
    }

    private double extract$distance2(CommandParameters parameters) {
        return (Double)this.distancePart2.value(parameters).asSingle(double_Key);
    }

    private List<String> extract$commandStr(CommandParameters parameters) {
        return this.commandStrPart.value(parameters).asMultiple(string_Key);
    }

    private boolean extract$print(CommandParameters parameters) {
        return this.printPart.in(parameters);
    }

    private boolean extract$randomRotate2(CommandParameters parameters) {
        return this.randomRotatePart2.in(parameters);
    }

    private boolean extract$layers(CommandParameters parameters) {
        return this.layersPart.in(parameters);
    }

    private boolean extract$dontSmooth(CommandParameters parameters) {
        return this.dontSmoothPart.in(parameters);
    }

    private boolean extract$randomRotate3(CommandParameters parameters) {
        return this.randomRotatePart3.in(parameters);
    }

    private boolean extract$layers2(CommandParameters parameters) {
        return this.layersPart2.in(parameters);
    }

    private boolean extract$dontSmooth2(CommandParameters parameters) {
        return this.dontSmoothPart2.in(parameters);
    }

    private boolean extract$randomRotate4(CommandParameters parameters) {
        return this.randomRotatePart4.in(parameters);
    }

    private boolean extract$autoRotate(CommandParameters parameters) {
        return this.autoRotatePart.in(parameters);
    }

    private List<String> extract$input(CommandParameters parameters) {
        return this.inputPart.value(parameters).asMultiple(string_Key);
    }

    private String extract$name(CommandParameters parameters) {
        return (String)this.namePart.value(parameters).asSingle(string_Key);
    }

    private boolean extract$root(CommandParameters parameters) {
        return this.rootPart.in(parameters);
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private InjectedValueAccess extract$args(CommandParameters parameters) {
        return (InjectedValueAccess)RegistrationUtil.requireOptional(injectedValueAccess_Key, (String)"args", (Optional)parameters.injectedValue(injectedValueAccess_Key));
    }

    private int extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private LocalSession extract$localSession(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"localSession", (Optional)parameters.injectedValue(localSession_Key));
    }

    private RegionFactory extract$shape(CommandParameters parameters) {
        return (RegionFactory)this.shapePart.value(parameters).asSingle(regionFactory_Key);
    }

    private double extract$radius13(CommandParameters parameters) {
        return (Double)this.radiusPart13.value(parameters).asSingle(double_Key);
    }

    private String extract$expression(CommandParameters parameters) {
        return (String)this.expressionPart.value(parameters).asSingle(string_Key);
    }

    private boolean extract$useRawCoords(CommandParameters parameters) {
        return this.useRawCoordsPart.in(parameters);
    }

    private boolean extract$usePlacement(CommandParameters parameters) {
        return this.usePlacementPart.in(parameters);
    }

    private Pattern extract$pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private double extract$density2(CommandParameters parameters) {
        return (Double)this.densityPart2.value(parameters).asSingle(double_Key);
    }

    private TreeGenerator.TreeType extract$type(CommandParameters parameters) {
        return (TreeGenerator.TreeType)((Object)this.typePart.value(parameters).asSingle(treeType_Key));
    }

    private boolean extract$stack(CommandParameters parameters) {
        return this.stackPart.in(parameters);
    }

    private Expression extract$radius14(CommandParameters parameters) {
        return (Expression)this.radiusPart14.value(parameters).asSingle(expression_Key);
    }

    private boolean extract$hollow(CommandParameters parameters) {
        return this.hollowPart.in(parameters);
    }

    private boolean extract$falling(CommandParameters parameters) {
        return this.fallingPart.in(parameters);
    }

    private Expression extract$radius15(CommandParameters parameters) {
        return (Expression)this.radiusPart15.value(parameters).asSingle(expression_Key);
    }

    private int extract$height(CommandParameters parameters) {
        return (Integer)this.heightPart.value(parameters).asSingle(integer_Key);
    }

    private double extract$thickness(CommandParameters parameters) {
        return (Double)this.thicknessPart.value(parameters).asSingle(double_Key);
    }

    private boolean extract$hollow2(CommandParameters parameters) {
        return this.hollowPart2.in(parameters);
    }

    private boolean extract$ignoreAir(CommandParameters parameters) {
        return this.ignoreAirPart.in(parameters);
    }

    private boolean extract$usingOrigin(CommandParameters parameters) {
        return this.usingOriginPart.in(parameters);
    }

    private boolean extract$pasteEntities(CommandParameters parameters) {
        return this.pasteEntitiesPart.in(parameters);
    }

    private boolean extract$pasteBiomes(CommandParameters parameters) {
        return this.pasteBiomesPart.in(parameters);
    }

    private Mask extract$sourceMask(CommandParameters parameters) {
        return (Mask)this.sourceMaskPart.value(parameters).asSingle(mask_clipboardMask_Key);
    }

    private Expression extract$radius16(CommandParameters parameters) {
        return (Expression)this.radiusPart16.value(parameters).asSingle(expression_Key);
    }

    private int extract$iterations(CommandParameters parameters) {
        return (Integer)this.iterationsPart.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$mask3(CommandParameters parameters) {
        return (Mask)this.maskPart3.value(parameters).asSingle(mask_Key);
    }

    private int extract$iterations2(CommandParameters parameters) {
        return (Integer)this.iterationsPart2.value(parameters).asSingle(integer_Key);
    }

    private int extract$snowBlockCount(CommandParameters parameters) {
        return (Integer)this.snowBlockCountPart.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$mask4(CommandParameters parameters) {
        return (Mask)this.maskPart4.value(parameters).asSingle(mask_Key);
    }

    private Expression extract$radius17(CommandParameters parameters) {
        return (Expression)this.radiusPart17.value(parameters).asSingle(expression_Key);
    }

    private Expression extract$radius18(CommandParameters parameters) {
        return (Expression)this.radiusPart18.value(parameters).asSingle(expression_Key);
    }

    private boolean extract$fromMaxY(CommandParameters parameters) {
        return this.fromMaxYPart.in(parameters);
    }

    private Expression extract$radius19(CommandParameters parameters) {
        return (Expression)this.radiusPart19.value(parameters).asSingle(expression_Key);
    }

    private boolean extract$killPets(CommandParameters parameters) {
        return this.killPetsPart.in(parameters);
    }

    private boolean extract$killNpcs(CommandParameters parameters) {
        return this.killNpcsPart.in(parameters);
    }

    private boolean extract$killGolems(CommandParameters parameters) {
        return this.killGolemsPart.in(parameters);
    }

    private boolean extract$killAnimals(CommandParameters parameters) {
        return this.killAnimalsPart.in(parameters);
    }

    private boolean extract$killAmbient(CommandParameters parameters) {
        return this.killAmbientPart.in(parameters);
    }

    private boolean extract$killWithName(CommandParameters parameters) {
        return this.killWithNamePart.in(parameters);
    }

    private boolean extract$killFriendly(CommandParameters parameters) {
        return this.killFriendlyPart.in(parameters);
    }

    private boolean extract$killArmorStands(CommandParameters parameters) {
        return this.killArmorStandsPart.in(parameters);
    }

    private boolean extract$killWater(CommandParameters parameters) {
        return this.killWaterPart.in(parameters);
    }
}

