/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.fastasyncworldedit.core.util.CachedTextureUtil;
import com.fastasyncworldedit.core.util.CleanTextureUtil;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.RandomTextureUtil;
import com.fastasyncworldedit.core.util.StringMan;
import com.fastasyncworldedit.core.util.TextureUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.GeneralCommandsRegistration;
import com.sk89q.worldedit.command.util.CommandPermissions;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.command.util.HookMode;
import com.sk89q.worldedit.command.util.WorldEditAsyncCommandBuilder;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Locatable;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.internal.command.CommandRegistrationHandler;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.internal.cui.ServerCUIHandler;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.SideEffectSet;
import com.sk89q.worldedit.util.auth.AuthorizationException;
import com.sk89q.worldedit.util.formatting.component.PaginationBox;
import com.sk89q.worldedit.util.formatting.component.SideEffectBox;
import com.sk89q.worldedit.util.formatting.text.BuildableComponent;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.item.ItemType;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandManagerService;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.annotation.Command;
import org.enginehub.piston.annotation.CommandContainer;
import org.enginehub.piston.annotation.param.Arg;
import org.enginehub.piston.annotation.param.ArgFlag;
import org.enginehub.piston.annotation.param.Switch;

@CommandContainer(superTypes={CommandPermissionsConditionGenerator.Registration.class})
public class GeneralCommands {
    private final WorldEdit worldEdit;

    public GeneralCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    public static void register(CommandRegistrationHandler registration, CommandManager commandManager, CommandManagerService commandManagerService, WorldEdit worldEdit) {
        CommandManager collect = commandManagerService.newCommandManager();
        registration.register(collect, GeneralCommandsRegistration.builder(), new GeneralCommands(worldEdit));
        Set commands = collect.getAllCommands().collect(Collectors.toSet());
        for (org.enginehub.piston.Command command : commands) {
            commandManager.register(command);
        }
    }

    private static Component replaceFastForPerf(org.enginehub.piston.Command oldCmd, CommandParameters oldParams) {
        String flipped;
        String arg0;
        if (oldParams.getMetadata() == null) {
            return CommandUtil.createNewCommandReplacementText("//perf");
        }
        ImmutableList args = oldParams.getMetadata().getArguments();
        if (args.isEmpty()) {
            return TextComponent.of((String)"There is not yet a replacement for //fast with no arguments");
        }
        switch (arg0 = ((String)args.get(0)).toLowerCase(Locale.ENGLISH)) {
            case "on": {
                flipped = "off";
                break;
            }
            case "off": {
                flipped = "on";
                break;
            }
            default: {
                return TextComponent.of((String)("There is no replacement for //fast " + arg0));
            }
        }
        return CommandUtil.createNewCommandReplacementText("//perf " + flipped);
    }

    @Command(name="/limit", desc="Modify block change limit")
    @CommandPermissions(value={"worldedit.limit"})
    public void limit(Actor actor, LocalSession session, @Arg(desc="The limit to set", def={""}) Integer limit) {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        boolean mayDisable = actor.hasPermission("worldedit.limit.unrestricted");
        limit = limit == null ? config.defaultChangeLimit : Math.max(-1, limit);
        if (!mayDisable && config.maxChangeLimit > -1 && limit > config.maxChangeLimit) {
            actor.print((Component)Caption.of("worldedit.limit.too-high", TextComponent.of((int)config.maxChangeLimit)));
            return;
        }
        session.setBlockChangeLimit(limit);
        Component component = TextComponent.empty().append((Component)Caption.of("worldedit.limit.set", TextComponent.of((int)limit)));
        if (limit != config.defaultChangeLimit) {
            component.append((Component)TextComponent.space()).append((Component)Caption.of("worldedit.limit.return-to-default", new Object[0]));
        }
        actor.print(component);
    }

    @Command(name="/timeout", desc="Modify evaluation timeout time.")
    @CommandPermissions(value={"worldedit.timeout"})
    public void timeout(Actor actor, LocalSession session, @Arg(desc="The timeout time to set", def={""}) Integer limit) {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        boolean mayDisable = actor.hasPermission("worldedit.timeout.unrestricted");
        limit = limit == null ? config.calculationTimeout : Math.max(-1, limit);
        if (!mayDisable && config.maxCalculationTimeout > -1 && limit > config.maxCalculationTimeout) {
            actor.print((Component)Caption.of("worldedit.timeout.too-high", TextComponent.of((int)config.maxCalculationTimeout)));
            return;
        }
        session.setTimeout(limit);
        Component component = TextComponent.empty().append((Component)Caption.of("worldedit.timeout.set", TextComponent.of((int)limit)));
        if (limit != config.calculationTimeout) {
            component.append((Component)Caption.of("worldedit.timeout.return-to-default", new Object[0]));
        }
        actor.print(component);
    }

    @Command(name="/perf", desc="Toggle side effects for performance", descFooter="Note that this command is GOING to change in the future. Do not depend on the exact format of this command yet.")
    @CommandPermissions(value={"worldedit.perf"})
    void perf(Actor actor, LocalSession session, @Arg(desc="The side effect", def={""}) SideEffect sideEffect, @Arg(desc="The new side effect state", def={""}) SideEffect.State newState, @Switch(name=104, desc="Show the info box") boolean showInfoBox) throws WorldEditException {
        if (sideEffect != null) {
            SideEffect.State currentState = session.getSideEffectSet().getState(sideEffect);
            if (newState != null && newState == currentState) {
                if (!showInfoBox) {
                    actor.print((Component)Caption.of("worldedit.perf.sideeffect.already-set", TranslatableComponent.of((String)sideEffect.getDisplayName()), TranslatableComponent.of((String)newState.getDisplayName())));
                }
                return;
            }
            if (newState != null) {
                session.setSideEffectSet(session.getSideEffectSet().with(sideEffect, newState));
                if (!showInfoBox) {
                    actor.print((Component)Caption.of("worldedit.perf.sideeffect.set", TranslatableComponent.of((String)sideEffect.getDisplayName()), TranslatableComponent.of((String)newState.getDisplayName())));
                }
            } else {
                actor.print((Component)Caption.of("worldedit.perf.sideeffect.get", TranslatableComponent.of((String)sideEffect.getDisplayName()), TranslatableComponent.of((String)currentState.getDisplayName())));
            }
        } else if (newState != null) {
            SideEffectSet applier = session.getSideEffectSet();
            for (SideEffect sideEffectEntry : SideEffect.values()) {
                applier = applier.with(sideEffectEntry, newState);
            }
            session.setSideEffectSet(applier);
            if (!showInfoBox) {
                actor.print((Component)Caption.of("worldedit.perf.sideeffect.set-all", TranslatableComponent.of((String)newState.getDisplayName())));
            }
        }
        if (sideEffect == null || showInfoBox) {
            SideEffectBox sideEffectBox = new SideEffectBox(session.getSideEffectSet());
            actor.print(sideEffectBox.create(1));
        }
    }

    @Command(name="/reorder", desc="Sets the reorder mode of WorldEdit")
    @CommandPermissions(value={"worldedit.reorder"})
    public void reorderMode(Actor actor, LocalSession session, @Arg(desc="The reorder mode", def={""}) EditSession.ReorderMode reorderMode) {
        if (reorderMode == null) {
            actor.print((Component)Caption.of("worldedit.reorder.current", TextComponent.of((String)session.getReorderMode().getDisplayName())));
        } else {
            session.setReorderMode(reorderMode);
            actor.print((Component)Caption.of("worldedit.reorder.set", TextComponent.of((String)session.getReorderMode().getDisplayName())));
        }
    }

    @Command(name="/drawsel", desc="Toggle drawing the current selection")
    @CommandPermissions(value={"worldedit.drawsel"})
    public void drawSelection(Player player, LocalSession session, @Arg(desc="The new draw selection state", def={""}) Boolean drawSelection) throws WorldEditException {
        if (!WorldEdit.getInstance().getConfiguration().serverSideCUI) {
            throw new AuthorizationException((Component)Caption.of("worldedit.error.disabled", new Object[0]));
        }
        boolean useServerCui = session.shouldUseServerCUI();
        if (drawSelection != null && drawSelection == useServerCui) {
            player.print((Component)Caption.of("worldedit.drawsel." + (useServerCui ? "enabled" : "disabled") + ".already", new Object[0]));
            return;
        }
        if (useServerCui) {
            session.setUseServerCUI(false);
            session.updateServerCUI(player);
            player.print((Component)Caption.of("worldedit.drawsel.disabled", new Object[0]));
        } else {
            session.setUseServerCUI(true);
            session.updateServerCUI(player);
            int maxSize = ServerCUIHandler.getMaxServerCuiSize();
            player.print((Component)Caption.of("worldedit.drawsel.enabled", TextComponent.of((int)maxSize), TextComponent.of((int)maxSize), TextComponent.of((int)maxSize)));
        }
    }

    @Command(name="/world", desc="Sets the world override")
    @CommandPermissions(value={"worldedit.world"})
    public void world(Actor actor, LocalSession session, @Arg(desc="The world override", def={""}) World world) {
        session.setWorldOverride(world);
        if (world == null) {
            actor.print((Component)Caption.of("worldedit.world.remove", new Object[0]));
        } else {
            actor.print((Component)Caption.of("worldedit.world.set", TextComponent.of((String)world.getId())));
        }
    }

    @Command(name="/watchdog", desc="Changes watchdog hook state.", descFooter="This is dependent on platform implementation. Not all platforms support watchdog hooks, or contain a watchdog.")
    @CommandPermissions(value={"worldedit.watchdog"})
    public void watchdog(Actor actor, LocalSession session, @Arg(desc="The mode to set the watchdog hook to", def={""}) HookMode hookMode) {
        if (WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.GAME_HOOKS).getWatchdog() == null) {
            actor.print((Component)Caption.of("worldedit.watchdog.no-hook", new Object[0]));
            return;
        }
        boolean previousMode = session.isTickingWatchdog();
        if (hookMode != null && hookMode == HookMode.ACTIVE == previousMode) {
            actor.print((Component)Caption.of(previousMode ? "worldedit.watchdog.active.already" : "worldedit.watchdog.inactive.already", new Object[0]));
            return;
        }
        session.setTickingWatchdog(!previousMode);
        actor.print((Component)Caption.of(previousMode ? "worldedit.watchdog.inactive" : "worldedit.watchdog.active", new Object[0]));
    }

    @Command(name="gmask", aliases={"/gmask"}, desc="Set the global mask")
    @CommandPermissions(value={"worldedit.global-mask"})
    public void gmask(Actor actor, LocalSession session, @Arg(desc="The mask to set", def={""}) Mask mask) {
        if (mask == null) {
            session.setMask(null);
            actor.print((Component)Caption.of("worldedit.gmask.disabled", new Object[0]));
        } else {
            session.setMask(mask);
            actor.print((Component)Caption.of("worldedit.gmask.set", new Object[0]));
        }
    }

    @Command(name="toggleplace", aliases={"/toggleplace"}, desc="Switch between your position and pos1 for placement")
    @CommandPermissions(value={"worldedit.toggleplace"})
    public void togglePlace(Actor actor, LocalSession session) {
        if (!(actor instanceof Locatable)) {
            actor.print((Component)Caption.of("worldedit.toggleplace.not-locatable", new Object[0]));
            return;
        }
        if (session.togglePlacementPosition()) {
            actor.print((Component)Caption.of("worldedit.toggleplace.pos1", new Object[0]));
        } else {
            actor.print((Component)Caption.of("worldedit.toggleplace.player", new Object[0]));
        }
    }

    @Command(name="searchitem", aliases={"/searchitem", "/l", "/search"}, desc="Search for an item")
    @CommandPermissions(value={"worldedit.searchitem"})
    public void searchItem(Actor actor, @Switch(name=98, desc="Only search for blocks") boolean blocksOnly, @Switch(name=105, desc="Only search for items") boolean itemsOnly, @ArgFlag(name=112, desc="Page of results to return", def={"1"}) int page, @Arg(desc="Search query", variable=true) List<String> query) {
        String search = String.join((CharSequence)" ", query);
        if (search.length() <= 2) {
            actor.print((Component)Caption.of("worldedit.searchitem.too-short", new Object[0]));
            return;
        }
        if (blocksOnly && itemsOnly) {
            actor.print((Component)Caption.of("worldedit.searchitem.either-b-or-i", new Object[0]));
            return;
        }
        WorldEditAsyncCommandBuilder.createAndSendMessage(actor, (Callable<Component>)new ItemSearcher(search, blocksOnly, itemsOnly, page), (Component)Caption.of("worldedit.searchitem.searching", new Object[0]));
    }

    @Command(name="/gtexture", aliases={"gtexture"}, descFooter="The global destination mask applies to all edits you do and masks based on the destination blocks (i.e., the blocks in the world).", desc="Set the global mask")
    @CommandPermissions(value={"worldedit.global-texture"})
    public void gtexture(Actor actor, World worldArg, LocalSession session, EditSession editSession, @Arg(name="context", desc="InjectedValueAccess", def={""}) List<String> arguments) throws WorldEditException, FileNotFoundException {
        if (arguments.isEmpty()) {
            session.setTextureUtil(null);
            actor.print((Component)Caption.of("fawe.worldedit.general.texture.disabled", new Object[0]));
        } else {
            boolean random;
            String arg = arguments.get(0);
            String argLower = arg.toLowerCase(Locale.ROOT);
            TextureUtil util = Fawe.instance().getTextureUtil();
            int randomIndex = 1;
            boolean checkRandomization = true;
            if (arguments.size() >= 2 && MathMan.isInteger(arguments.get(0)) && MathMan.isInteger(arguments.get(1))) {
                int min = Integer.parseInt(arguments.get(0));
                int max = Integer.parseInt(arguments.get(1));
                if (min < 0 || max > 100) {
                    throw new InputParseException((Component)Caption.of("fawe.error.too-simple", new Object[0]));
                }
                if (min != 0 || max != 100) {
                    util = new CleanTextureUtil(util, min, max);
                }
                randomIndex = 2;
            } else if (arguments.size() == 1 && argLower.equals("true") || argLower.equals("false")) {
                if (argLower.equals("true")) {
                    util = new RandomTextureUtil(util);
                }
                checkRandomization = false;
            } else if (argLower.equals("#copy") || argLower.equals("#clipboard")) {
                Clipboard clipboard = session.getClipboard().getClipboard();
                util = TextureUtil.fromClipboard(clipboard);
            } else if (argLower.equals("*") || argLower.equals("true")) {
                util = Fawe.instance().getTextureUtil();
            } else {
                ParserContext parserContext = new ParserContext();
                parserContext.setActor(actor);
                parserContext.setWorld(worldArg);
                parserContext.setSession(session);
                parserContext.setExtent(editSession);
                Mask mask = this.worldEdit.getMaskFactory().parseFromInput(arg, parserContext);
                util = TextureUtil.fromMask(mask);
            }
            if (checkRandomization && arguments.size() > randomIndex && (random = Boolean.parseBoolean(arguments.get(randomIndex)))) {
                util = new RandomTextureUtil(util);
            }
            if (!(util instanceof CachedTextureUtil)) {
                util = new CachedTextureUtil(util);
            }
            session.setTextureUtil(util);
            actor.print((Component)Caption.of("fawe.worldedit.general.texture.set", StringMan.join(arguments, " ")));
        }
    }

    @Command(name="/gsmask", aliases={"gsmask", "globalsourcemask", "/globalsourcemask"}, desc="Set the global source mask", descFooter="The global source mask applies to all edits you do and masks based on the source blocks (e.g., the blocks in your clipboard)")
    @CommandPermissions(value={"worldedit.global-mask", "worldedit.mask.global"})
    public void gsmask(Actor actor, LocalSession session, EditSession editSession, @Arg(desc="The mask to set", def={""}) Mask maskOpt) throws WorldEditException {
        session.setSourceMask(maskOpt);
        if (maskOpt == null) {
            actor.print((Component)Caption.of("fawe.worldedit.general.source.mask.disabled", new Object[0]));
        } else {
            actor.print((Component)Caption.of("fawe.worldedit.general.source.mask", new Object[0]));
        }
    }

    @Command(name="/gtransform", aliases={"gtransform"}, desc="Set the global transform")
    @CommandPermissions(value={"worldedit.global-transform", "worldedit.transform.global"})
    public void gtransform(Actor actor, EditSession editSession, LocalSession session, @Arg(desc="The transform to set", def={""}) ResettableExtent transform) throws WorldEditException {
        session.setTransform(transform);
        if (transform == null) {
            actor.print((Component)Caption.of("fawe.worldedit.general.transform.disabled", new Object[0]));
        } else {
            actor.print((Component)Caption.of("fawe.worldedit.general.transform", new Object[0]));
        }
    }

    @Command(name="/tips", aliases={"tips"}, desc="Toggle FAWE tips")
    @CommandPermissions(value={"fawe.tips"})
    public void tips(Actor actor, LocalSession session) throws WorldEditException {
        if (actor.togglePermission("fawe.tips")) {
            actor.print((Component)Caption.of("fawe.info.worldedit.toggle.tips.on", new Object[0]));
        } else {
            actor.print((Component)Caption.of("fawe.info.worldedit.toggle.tips.off", new Object[0]));
        }
    }

    @Command(name="/fast", desc="Toggle fast mode")
    @CommandPermissions(value={"worldedit.fast"})
    @Deprecated
    void fast(Actor actor, LocalSession session, @Arg(desc="The new fast mode state", def={""}) Boolean fastMode) {
        boolean hasFastMode = session.hasFastMode();
        if (fastMode != null && fastMode == hasFastMode) {
            actor.print((Component)Caption.of(fastMode != false ? "worldedit.fast.enabled.already" : "worldedit.fast.disabled.already", new Object[0]));
            return;
        }
        if (hasFastMode) {
            session.setFastMode(false);
            actor.print((Component)Caption.of("worldedit.fast.disabled", new Object[0]));
        } else {
            session.setFastMode(true);
            actor.print((Component)Caption.of("worldedit.fast.enabled", new Object[0]));
        }
    }

    private static class ItemSearcher
    implements Callable<Component> {
        private final boolean blocksOnly;
        private final boolean itemsOnly;
        private final String search;
        private final int page;

        ItemSearcher(String search, boolean blocksOnly, boolean itemsOnly, int page) {
            this.blocksOnly = blocksOnly;
            this.itemsOnly = itemsOnly;
            this.search = search;
            this.page = page;
        }

        @Override
        public Component call() throws Exception {
            String command = "/searchitem " + (this.blocksOnly ? "-b " : "") + (this.itemsOnly ? "-i " : "") + "-p %page% " + this.search;
            TreeMap<String, BuildableComponent> results = new TreeMap<String, BuildableComponent>();
            String idMatch = this.search.replace(' ', '_');
            String nameMatch = this.search.toLowerCase(Locale.ROOT);
            for (ItemType searchType : ItemType.REGISTRY) {
                String id;
                if (this.blocksOnly && !searchType.hasBlockType() || this.itemsOnly && searchType.hasBlockType() || !(id = searchType.getId()).contains(idMatch)) continue;
                Component name = searchType.getRichName();
                results.put(id, ((TextComponent.Builder)((TextComponent.Builder)TextComponent.builder().append(name)).append(" (" + id + ")")).build());
            }
            ArrayList<Component> list = new ArrayList<Component>(results.values());
            return PaginationBox.fromComponents("Search results for '" + this.search + "'", command, list).create(this.page);
        }
    }
}

