/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.fastasyncworldedit.core.command.tool.scroll.Scroll;
import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ToolUtilCommands;
import com.sk89q.worldedit.command.argument.Arguments;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class ToolUtilCommandsRegistration
implements CommandRegistration<ToolUtilCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<Mask> mask_Key = Key.of(Mask.class);
    private static final Key<Pattern> pattern_Key = Key.of(Pattern.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Boolean> boolean_Key = Key.of(Boolean.class);
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Scroll.Action> action_Key = Key.of(Scroll.Action.class);
    private static final Key<ResettableExtent> resettableExtent_Key = Key.of(ResettableExtent.class);
    private static final Key<Player> player_Key = Key.of(Player.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Arguments> arguments_Key = Key.of(Arguments.class);
    private static final Key<EditSession> editSession_Key = Key.of(EditSession.class);
    private CommandManager commandManager;
    private ToolUtilCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final NoArgCommandFlag offHandPart = CommandParts.flag((char)'h', (Component)TextComponent.of((String)"Whether the offhand should be considered or not")).build();
    private final CommandArgument maskOptPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"maskOpt"), (Component)TextComponent.of((String)"The destination mask")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument patternPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"pattern"), (Component)TextComponent.of((String)"The pattern of blocks to use")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(pattern_Key)).build();
    private final CommandArgument rangePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"range"), (Component)TextComponent.of((String)"The range of the brush")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument sizePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"size"), (Component)TextComponent.of((String)"The size of the brush")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument maskOptPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"maskOpt"), (Component)TextComponent.of((String)"The trace mask to set")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument superPickaxePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"superPickaxe"), (Component)TextComponent.of((String)"The new super pickaxe state")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(boolean_Key)).build();
    private final CommandArgument commandStrPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"commandStr"), (Component)TextComponent.of((String)"The brush command")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();
    private final CommandArgument modePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mode"), (Component)TextComponent.of((String)"int")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument offsetPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"offset"), (Component)TextComponent.of((String)"offset")).defaultsTo((Iterable)ImmutableList.of((Object)"0")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final CommandArgument modePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"mode"), (Component)TextComponent.of((String)"Target Modes")).defaultsTo((Iterable)ImmutableList.of((Object)"none")).ofTypes((Collection)ImmutableList.of(action_Key)).build();
    private final CommandArgument commandStrPart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"commandStr"), (Component)TextComponent.of((String)"The scroll action")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).variable(true).build();
    private final CommandArgument maskArgPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"maskArg"), (Component)TextComponent.of((String)"The destination mask")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(mask_Key)).build();
    private final CommandArgument transformPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"transform"), (Component)TextComponent.of((String)"The transform")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(resettableExtent_Key)).build();

    private ToolUtilCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static ToolUtilCommandsRegistration builder() {
        return new ToolUtilCommandsRegistration();
    }

    public ToolUtilCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public ToolUtilCommandsRegistration containerInstance(ToolUtilCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public ToolUtilCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public ToolUtilCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("mask", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/mask"));
            b.description((Component)TextComponent.of((String)"Set the brush destination mask"));
            b.parts((Collection)ImmutableList.of((Object)this.offHandPart, (Object)this.maskOptPart));
            b.action(this::cmd$mask);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"mask", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Mask.class, Arguments.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("material", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"mat", (Object)"/material", (Object)"pattern"));
            b.description((Component)TextComponent.of((String)"Set the brush material"));
            b.parts((Collection)ImmutableList.of((Object)this.patternPart, (Object)this.offHandPart));
            b.action(this::cmd$material);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"material", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Boolean.TYPE, Arguments.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("range", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/range"));
            b.description((Component)TextComponent.of((String)"Set the brush range"));
            b.parts((Collection)ImmutableList.of((Object)this.rangePart));
            b.action(this::cmd$range);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"range", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("size", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Set the brush size"));
            b.parts((Collection)ImmutableList.of((Object)this.sizePart));
            b.action(this::cmd$size);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"size", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("tracemask", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"tarmask", (Object)"tm", (Object)"targetmask"));
            b.description((Component)TextComponent.of((String)"Set the mask used to stop tool traces"));
            b.parts((Collection)ImmutableList.of((Object)this.maskOptPart2));
            b.action(this::cmd$tracemask);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"traceMask", (Class[])new Class[]{Player.class, LocalSession.class, Mask.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("/", b -> {
            b.aliases((Collection)ImmutableList.of((Object)","));
            b.description((Component)TextComponent.of((String)"Toggle the super pickaxe function"));
            b.parts((Collection)ImmutableList.of((Object)this.superPickaxePart));
            b.action(this::cmd$_);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"togglePickaxe", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("primary", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/primary"));
            b.description((Component)TextComponent.of((String)"Set the right click brush"));
            b.footer((Component)TextComponent.of((String)"Set the right click brush"));
            b.parts((Collection)ImmutableList.of((Object)this.commandStrPart));
            b.action(this::cmd$primary);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"primary", (Class[])new Class[]{Player.class, LocalSession.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("secondary", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/secondary"));
            b.description((Component)TextComponent.of((String)"Set the left click brush"));
            b.footer((Component)TextComponent.of((String)"Set the left click brush"));
            b.parts((Collection)ImmutableList.of((Object)this.commandStrPart));
            b.action(this::cmd$secondary);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"secondary", (Class[])new Class[]{Player.class, LocalSession.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("target", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"tar", (Object)"/target", (Object)"/tar"));
            b.description((Component)TextComponent.of((String)"Toggle between different target modes"));
            b.parts((Collection)ImmutableList.of((Object)this.modePart));
            b.action(this::cmd$target);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"target", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("targetoffset", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"to"));
            b.description((Component)TextComponent.of((String)"Set the targeting mask"));
            b.parts((Collection)ImmutableList.of((Object)this.offsetPart));
            b.action(this::cmd$targetoffset);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"targetOffset", (Class[])new Class[]{Player.class, EditSession.class, LocalSession.class, Integer.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("scroll", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Toggle between different target modes"));
            b.parts((Collection)ImmutableList.of((Object)this.offHandPart, (Object)this.modePart2, (Object)this.commandStrPart2));
            b.action(this::cmd$scroll);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"scroll", (Class[])new Class[]{Player.class, EditSession.class, LocalSession.class, Boolean.TYPE, Scroll.Action.class, List.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("smask", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/smask", (Object)"/sourcemask", (Object)"sourcemask"));
            b.description((Component)TextComponent.of((String)"Set the brush source mask"));
            b.footer((Component)TextComponent.of((String)"Set the brush source mask"));
            b.parts((Collection)ImmutableList.of((Object)this.maskArgPart, (Object)this.offHandPart));
            b.action(this::cmd$smask);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"smask", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Mask.class, Boolean.TYPE, Arguments.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("transform", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"/transform"));
            b.description((Component)TextComponent.of((String)"Set the brush transform"));
            b.parts((Collection)ImmutableList.of((Object)this.transformPart, (Object)this.offHandPart));
            b.action(this::cmd$transform);
            Method commandMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"transform", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, ResettableExtent.class, Boolean.TYPE, Arguments.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$mask(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"mask", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.TYPE, Mask.class, Arguments.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.mask(this.extract$player(parameters), this.extract$session(parameters), this.extract$offHand(parameters), this.extract$maskOpt(parameters), this.extract$arguments(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$material(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"material", (Class[])new Class[]{Player.class, LocalSession.class, Pattern.class, Boolean.TYPE, Arguments.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.material(this.extract$player(parameters), this.extract$session(parameters), this.extract$pattern(parameters), this.extract$offHand(parameters), this.extract$arguments(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$range(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"range", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.range(this.extract$player(parameters), this.extract$session(parameters), this.extract$range(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$size(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"size", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.size(this.extract$player(parameters), this.extract$session(parameters), this.extract$size(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$tracemask(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"traceMask", (Class[])new Class[]{Player.class, LocalSession.class, Mask.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.traceMask(this.extract$player(parameters), this.extract$session(parameters), this.extract$maskOpt2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$_(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"togglePickaxe", (Class[])new Class[]{Player.class, LocalSession.class, Boolean.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.togglePickaxe(this.extract$player(parameters), this.extract$session(parameters), this.extract$superPickaxe(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$primary(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"primary", (Class[])new Class[]{Player.class, LocalSession.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.primary(this.extract$player(parameters), this.extract$session(parameters), this.extract$commandStr(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$secondary(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"secondary", (Class[])new Class[]{Player.class, LocalSession.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.secondary(this.extract$player(parameters), this.extract$session(parameters), this.extract$commandStr(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$target(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"target", (Class[])new Class[]{Player.class, LocalSession.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.target(this.extract$player(parameters), this.extract$session(parameters), this.extract$mode(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$targetoffset(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"targetOffset", (Class[])new Class[]{Player.class, EditSession.class, LocalSession.class, Integer.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.targetOffset(this.extract$player(parameters), this.extract$editSession(parameters), this.extract$session(parameters), this.extract$offset(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$scroll(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"scroll", (Class[])new Class[]{Player.class, EditSession.class, LocalSession.class, Boolean.TYPE, Scroll.Action.class, List.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.scroll(this.extract$player(parameters), this.extract$editSession(parameters), this.extract$session(parameters), this.extract$offHand(parameters), this.extract$mode2(parameters), this.extract$commandStr2(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$smask(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"smask", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, Mask.class, Boolean.TYPE, Arguments.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.smask(this.extract$player(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$maskArg(parameters), this.extract$offHand(parameters), this.extract$arguments(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$transform(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(ToolUtilCommands.class, (String)"transform", (Class[])new Class[]{Player.class, LocalSession.class, EditSession.class, ResettableExtent.class, Boolean.TYPE, Arguments.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.transform(this.extract$player(parameters), this.extract$session(parameters), this.extract$editSession(parameters), this.extract$transform(parameters), this.extract$offHand(parameters), this.extract$arguments(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Player extract$player(CommandParameters parameters) {
        return (Player)RegistrationUtil.requireOptional(player_Key, (String)"player", (Optional)parameters.injectedValue(player_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private boolean extract$offHand(CommandParameters parameters) {
        return this.offHandPart.in(parameters);
    }

    private Mask extract$maskOpt(CommandParameters parameters) {
        return (Mask)this.maskOptPart.value(parameters).asSingle(mask_Key);
    }

    private Arguments extract$arguments(CommandParameters parameters) {
        return (Arguments)RegistrationUtil.requireOptional(arguments_Key, (String)"arguments", (Optional)parameters.injectedValue(arguments_Key));
    }

    private Pattern extract$pattern(CommandParameters parameters) {
        return (Pattern)this.patternPart.value(parameters).asSingle(pattern_Key);
    }

    private int extract$range(CommandParameters parameters) {
        return (Integer)this.rangePart.value(parameters).asSingle(integer_Key);
    }

    private int extract$size(CommandParameters parameters) {
        return (Integer)this.sizePart.value(parameters).asSingle(integer_Key);
    }

    private Mask extract$maskOpt2(CommandParameters parameters) {
        return (Mask)this.maskOptPart2.value(parameters).asSingle(mask_Key);
    }

    private Boolean extract$superPickaxe(CommandParameters parameters) {
        return (Boolean)this.superPickaxePart.value(parameters).asSingle(boolean_Key);
    }

    private List<String> extract$commandStr(CommandParameters parameters) {
        return this.commandStrPart.value(parameters).asMultiple(string_Key);
    }

    private int extract$mode(CommandParameters parameters) {
        return (Integer)this.modePart.value(parameters).asSingle(integer_Key);
    }

    private EditSession extract$editSession(CommandParameters parameters) {
        return (EditSession)RegistrationUtil.requireOptional(editSession_Key, (String)"editSession", (Optional)parameters.injectedValue(editSession_Key));
    }

    private int extract$offset(CommandParameters parameters) {
        return (Integer)this.offsetPart.value(parameters).asSingle(integer_Key);
    }

    private Scroll.Action extract$mode2(CommandParameters parameters) {
        return (Scroll.Action)((Object)this.modePart2.value(parameters).asSingle(action_Key));
    }

    private List<String> extract$commandStr2(CommandParameters parameters) {
        return this.commandStrPart2.value(parameters).asMultiple(string_Key);
    }

    private Mask extract$maskArg(CommandParameters parameters) {
        return (Mask)this.maskArgPart.value(parameters).asSingle(mask_Key);
    }

    private ResettableExtent extract$transform(CommandParameters parameters) {
        return (ResettableExtent)this.transformPart.value(parameters).asSingle(resettableExtent_Key);
    }
}

