/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.platform;

import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.util.TaskManager;
import com.fastasyncworldedit.core.util.task.AsyncNotifyQueue;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractNonPlayerActor
implements Actor {
    private final ConcurrentHashMap<String, Object> meta = new ConcurrentHashMap();
    private final AtomicInteger runningCount = new AtomicInteger();
    private final AsyncNotifyQueue asyncNotifyQueue = new AsyncNotifyQueue((thread, throwable) -> {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof WorldEditException) {
            this.printError((Component)TextComponent.of((String)throwable.getLocalizedMessage()));
        } else {
            FaweException fe = FaweException.get(throwable);
            if (fe != null) {
                this.printError(fe.getComponent());
            } else {
                throwable.printStackTrace();
            }
        }
    });

    @Override
    public boolean canDestroyBedrock() {
        return true;
    }

    @Override
    public boolean isPlayer() {
        return false;
    }

    @Override
    public File openFileOpenDialog(String[] extensions) {
        return null;
    }

    @Override
    public File openFileSaveDialog(String[] extensions) {
        return null;
    }

    @Override
    public void dispatchCUIEvent(CUIEvent event) {
    }

    @Override
    public Map<String, Object> getRawMeta() {
        return this.meta;
    }

    @Override
    public boolean runAction(Runnable ifFree, boolean checkFree, boolean async) {
        if (checkFree && this.runningCount.get() != 0) {
            return false;
        }
        Runnable wrapped = () -> {
            try {
                this.runningCount.addAndGet(1);
                ifFree.run();
            }
            finally {
                this.runningCount.decrementAndGet();
            }
        };
        if (async) {
            this.asyncNotifyQueue.run(wrapped);
        } else {
            TaskManager.taskManager().taskNow(wrapped, false);
        }
        return true;
    }
}

