/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.transform;

import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.fastasyncworldedit.core.registry.state.PropertyKey;
import com.fastasyncworldedit.core.registry.state.PropertyKeySet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.helper.MCDirections;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class BlockTransformExtent
extends ResettableExtent {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private static final Set<PropertyKey> directional = PropertyKeySet.of(PropertyKey.HALF, PropertyKey.ROTATION, PropertyKey.AXIS, PropertyKey.FACING, PropertyKey.FACE, PropertyKey.SHAPE, PropertyKey.NORTH, PropertyKey.EAST, PropertyKey.SOUTH, PropertyKey.WEST);
    private static final Map<Direction, PropertyKey> directionMap = ImmutableMap.of((Object)((Object)Direction.NORTH), (Object)PropertyKey.NORTH, (Object)((Object)Direction.EAST), (Object)PropertyKey.EAST, (Object)((Object)Direction.SOUTH), (Object)PropertyKey.SOUTH, (Object)((Object)Direction.WEST), (Object)PropertyKey.WEST);
    private final int[] ALL = new int[0];
    private Transform transform;
    private Transform transformInverse;
    private int[] BLOCK_ROTATION_BITMASK;
    private int[][] BLOCK_TRANSFORM;
    private int[][] BLOCK_TRANSFORM_INVERSE;

    public BlockTransformExtent(Extent parent) {
        this(parent, new AffineTransform());
    }

    public BlockTransformExtent(Extent extent, Transform transform) {
        super(extent);
        Preconditions.checkNotNull((Object)transform);
        this.transform = transform;
        this.transformInverse = this.transform.inverse();
        this.cache();
    }

    private static long combine(Direction ... directions) {
        long mask = 0L;
        for (Direction dir : directions) {
            mask |= 1L << dir.ordinal();
        }
        return mask;
    }

    private static long[] adapt(Direction ... dirs) {
        long[] arr = new long[dirs.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = 1L << dirs[i].ordinal();
        }
        return arr;
    }

    private static long[] adapt(Long ... dirs) {
        long[] arr = new long[dirs.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = dirs[i];
        }
        return arr;
    }

    private static long[] getDirections(AbstractProperty property) {
        if (property instanceof DirectionalProperty) {
            DirectionalProperty directional = (DirectionalProperty)property;
            return BlockTransformExtent.adapt(directional.getValues().toArray(new Direction[0]));
        }
        List values = property.getValues();
        PropertyKey key = property.getKey();
        switch (key.getName().toLowerCase()) {
            case "half": {
                return BlockTransformExtent.adapt(Direction.UP, Direction.DOWN);
            }
            case "type": {
                return BlockTransformExtent.adapt(BlockTransformExtent.combine(Direction.UP), BlockTransformExtent.combine(Direction.DOWN), 0L);
            }
            case "rotation": {
                ArrayList<Direction> directions = new ArrayList<Direction>();
                for (Object value : values) {
                    directions.add(Direction.fromRotationIndex((Integer)value).get());
                }
                return BlockTransformExtent.adapt(directions.toArray(new Direction[0]));
            }
            case "axis": {
                switch (property.getValues().size()) {
                    case 3: {
                        return BlockTransformExtent.adapt(BlockTransformExtent.combine(Direction.EAST, Direction.WEST), BlockTransformExtent.combine(Direction.UP, Direction.DOWN), BlockTransformExtent.combine(Direction.SOUTH, Direction.NORTH));
                    }
                    case 2: {
                        return BlockTransformExtent.adapt(BlockTransformExtent.combine(Direction.EAST, Direction.WEST), BlockTransformExtent.combine(Direction.SOUTH, Direction.NORTH));
                    }
                }
                LOGGER.error("Invalid {} {}", (Object)property.getName(), property.getValues());
                return null;
            }
            case "facing": {
                ArrayList<Direction> directions = new ArrayList<Direction>();
                for (Object value : values) {
                    directions.add(Direction.valueOf(value.toString().toUpperCase(Locale.ROOT)));
                }
                return BlockTransformExtent.adapt(directions.toArray(new Direction[0]));
            }
            case "face": {
                if (values.size() == 3) {
                    return BlockTransformExtent.adapt(BlockTransformExtent.combine(Direction.UP), BlockTransformExtent.combine(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST), BlockTransformExtent.combine(Direction.DOWN));
                }
                return null;
            }
            case "hinge": {
                return BlockTransformExtent.adapt(BlockTransformExtent.combine(Direction.NORTHEAST, Direction.NORTHWEST, Direction.SOUTHEAST, Direction.SOUTHWEST), BlockTransformExtent.combine(Direction.NORTHEAST, Direction.NORTHWEST, Direction.SOUTHEAST, Direction.SOUTHWEST));
            }
            case "shape": {
                if (values.contains("left")) {
                    return BlockTransformExtent.adapt(BlockTransformExtent.combine(Direction.EAST, Direction.WEST), BlockTransformExtent.combine(Direction.NORTH, Direction.SOUTH));
                }
                if (values.contains("straight")) {
                    ArrayList<Long> result = new ArrayList<Long>();
                    block64: for (Object value : values) {
                        switch (value.toString()) {
                            case "straight": {
                                result.add(BlockTransformExtent.combine(Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST));
                                continue block64;
                            }
                            case "inner_left": {
                                result.add(BlockTransformExtent.orIndex(BlockTransformExtent.combine(Direction.NORTHEAST, Direction.NORTHWEST, Direction.SOUTHWEST, Direction.SOUTHEAST), property.getIndexFor("outer_right"), property.getIndexFor("outer_left")));
                                continue block64;
                            }
                            case "inner_right": {
                                result.add(BlockTransformExtent.orIndex(BlockTransformExtent.combine(Direction.NORTHEAST, Direction.NORTHWEST, Direction.SOUTHWEST, Direction.SOUTHEAST), property.getIndexFor("outer_right"), property.getIndexFor("outer_left")));
                                continue block64;
                            }
                            case "outer_left": {
                                result.add(BlockTransformExtent.orIndex(BlockTransformExtent.combine(Direction.NORTHEAST, Direction.NORTHWEST, Direction.SOUTHWEST, Direction.SOUTHEAST), property.getIndexFor("inner_left"), property.getIndexFor("inner_right")));
                                continue block64;
                            }
                            case "outer_right": {
                                result.add(BlockTransformExtent.orIndex(BlockTransformExtent.combine(Direction.NORTHEAST, Direction.NORTHWEST, Direction.SOUTHWEST, Direction.SOUTHEAST), property.getIndexFor("inner_left"), property.getIndexFor("inner_right")));
                                continue block64;
                            }
                        }
                        LOGGER.warn("Unknown direction {}", value);
                        result.add(0L);
                    }
                    return BlockTransformExtent.adapt(result.toArray(new Long[0]));
                }
                ArrayList<Long> directions = new ArrayList<Long>();
                block65: for (Object value : values) {
                    switch (value.toString()) {
                        case "north_south": {
                            directions.add(BlockTransformExtent.combine(Direction.NORTH, Direction.SOUTH));
                            continue block65;
                        }
                        case "east_west": {
                            directions.add(BlockTransformExtent.combine(Direction.EAST, Direction.WEST));
                            continue block65;
                        }
                        case "ascending_east": {
                            directions.add(BlockTransformExtent.combine(Direction.ASCENDING_EAST));
                            continue block65;
                        }
                        case "ascending_west": {
                            directions.add(BlockTransformExtent.combine(Direction.ASCENDING_WEST));
                            continue block65;
                        }
                        case "ascending_north": {
                            directions.add(BlockTransformExtent.combine(Direction.ASCENDING_NORTH));
                            continue block65;
                        }
                        case "ascending_south": {
                            directions.add(BlockTransformExtent.combine(Direction.ASCENDING_SOUTH));
                            continue block65;
                        }
                        case "south_east": {
                            directions.add(BlockTransformExtent.combine(Direction.SOUTHEAST));
                            continue block65;
                        }
                        case "south_west": {
                            directions.add(BlockTransformExtent.combine(Direction.SOUTHWEST));
                            continue block65;
                        }
                        case "north_west": {
                            directions.add(BlockTransformExtent.combine(Direction.NORTHWEST));
                            continue block65;
                        }
                        case "north_east": {
                            directions.add(BlockTransformExtent.combine(Direction.NORTHEAST));
                            continue block65;
                        }
                    }
                    LOGGER.warn("Unknown direction {}", value);
                    directions.add(0L);
                }
                return BlockTransformExtent.adapt(directions.toArray(new Long[0]));
            }
        }
        return null;
    }

    private static boolean hasDirection(long mask, Direction dir) {
        return (mask & 1L << dir.ordinal()) != 0L;
    }

    private static long orIndex(long mask, int ... indexes) {
        for (int index : indexes) {
            mask |= 1L << index + Direction.values().length;
        }
        return mask;
    }

    private static boolean hasIndex(long mask, int index) {
        return (mask >> Direction.values().length & (long)(1 << index)) == 0L;
    }

    @Nullable
    private static Integer getNewStateIndex(Transform transform, long[] directions, int oldIndex) {
        long oldDirMask = directions[oldIndex];
        if (oldDirMask == 0L) {
            return null;
        }
        Integer newIndex = null;
        for (Direction oldDirection : Direction.values()) {
            if (!BlockTransformExtent.hasDirection(oldDirMask, oldDirection)) continue;
            Vector3 oldVector = oldDirection.toVector();
            Vector3 newVector = transform.apply(oldVector).subtract(transform.apply(Vector3.ZERO)).normalize();
            boolean flip = false;
            if (transform instanceof AffineTransform) {
                flip = ((AffineTransform)transform).isScaled(oldVector);
            }
            if (!flip && oldVector.equalsFuzzy(newVector)) continue;
            double closest = oldVector.normalize().dot(newVector);
            for (int i = 0; i < directions.length; ++i) {
                int j = (oldIndex + i) % directions.length;
                long newDirMask = directions[j];
                if (!BlockTransformExtent.hasIndex(oldDirMask, j)) continue;
                for (Direction v : Direction.values()) {
                    double dot;
                    if (!BlockTransformExtent.hasDirection(newDirMask, v) || !((dot = v.toVector().normalize().dot(newVector)) > closest) && (!flip || !(dot >= closest))) continue;
                    closest = dot;
                    newIndex = j;
                }
            }
            if (newIndex == null) continue;
            return newIndex;
        }
        return newIndex;
    }

    private static boolean isDirectional(Property property) {
        if (property instanceof DirectionalProperty) {
            return true;
        }
        if (directional.contains(property.getKey())) {
            return true;
        }
        List values = property.getValues();
        return values.contains("top") || values.contains("left");
    }

    private static BaseBlock transformBaseBlockNBT(BlockState transformed, CompoundTag tag, Transform transform) {
        if (tag != null) {
            int rot;
            Direction direction;
            if (tag.containsKey("Rot") && (direction = MCDirections.fromRotation(rot = tag.asInt("Rot"))) != null) {
                Vector3 applyAbsolute = transform.apply(direction.toVector());
                Vector3 applyOrigin = transform.apply(Vector3.ZERO);
                applyAbsolute.mutX(applyAbsolute.getX() - applyOrigin.getX());
                applyAbsolute.mutY(applyAbsolute.getY() - applyOrigin.getY());
                applyAbsolute.mutZ(applyAbsolute.getZ() - applyOrigin.getZ());
                Direction newDirection = Direction.findClosest(applyAbsolute, Direction.Flag.CARDINAL | Direction.Flag.ORDINAL | Direction.Flag.SECONDARY_ORDINAL);
                if (newDirection != null) {
                    HashMap<String, Tag> values = new HashMap<String, Tag>((Map<String, Tag>)tag.getValue());
                    values.put("Rot", new ByteTag((byte)MCDirections.toRotation(newDirection)));
                    tag = new CompoundTag(values);
                }
            }
            return new BaseBlock(transformed, tag);
        }
        return transformed.toBaseBlock();
    }

    private static int transformState(BlockState state, Transform transform) {
        int newMaskedId = state.getInternalId();
        BlockType type = state.getBlockType();
        if (type.hasProperty(PropertyKey.NORTH) && type.hasProperty(PropertyKey.EAST) && type.hasProperty(PropertyKey.SOUTH) && type.hasProperty(PropertyKey.WEST)) {
            BlockStateHolder<BlockState> tmp = state;
            for (Map.Entry<Direction, PropertyKey> entry : directionMap.entrySet()) {
                Direction newDir = Direction.findClosest(transform.apply(entry.getKey().toVector()), Direction.Flag.CARDINAL);
                if (newDir == null) continue;
                Object dirState = state.getState(entry.getValue());
                tmp = tmp.with(directionMap.get((Object)newDir), dirState);
            }
            newMaskedId = tmp.getInternalId();
        }
        for (AbstractProperty abstractProperty : type.getProperties()) {
            long[] directions;
            if (!BlockTransformExtent.isDirectional(abstractProperty) || (directions = BlockTransformExtent.getDirections(abstractProperty)) == null) continue;
            int oldIndex = abstractProperty.getIndex(state.getInternalId());
            if (oldIndex >= directions.length) {
                if (!Settings.settings().ENABLED_COMPONENTS.DEBUG) continue;
                LOGGER.warn(String.format("Index outside direction array length found for block:{%s} property:{%s}", state.getBlockType().getId(), abstractProperty.getName()));
                continue;
            }
            Integer newIndex = BlockTransformExtent.getNewStateIndex(transform, directions, oldIndex);
            if (newIndex == null) continue;
            newMaskedId = abstractProperty.modifyIndex(newMaskedId, newIndex);
        }
        return newMaskedId;
    }

    private void cache() {
        this.BLOCK_ROTATION_BITMASK = new int[BlockTypes.size()];
        this.BLOCK_TRANSFORM = new int[BlockTypes.size()][];
        this.BLOCK_TRANSFORM_INVERSE = new int[BlockTypes.size()][];
        for (int i = 0; i < this.BLOCK_TRANSFORM.length; ++i) {
            this.BLOCK_TRANSFORM[i] = this.ALL;
            this.BLOCK_TRANSFORM_INVERSE[i] = this.ALL;
            BlockType type = BlockTypes.get(i);
            int bitMask = 0;
            for (AbstractProperty abstractProperty : type.getProperties()) {
                if (!BlockTransformExtent.isDirectional(abstractProperty)) continue;
                this.BLOCK_TRANSFORM[i] = null;
                this.BLOCK_TRANSFORM_INVERSE[i] = null;
                bitMask |= abstractProperty.getBitMask();
            }
            if (bitMask == 0) continue;
            this.BLOCK_ROTATION_BITMASK[i] = bitMask;
        }
    }

    public Transform getTransform() {
        return this.transform;
    }

    private <T extends BlockStateHolder<T>> T transformBlock(T block, boolean reverse) {
        return BlockTransformExtent.transform(block, reverse ? this.transform.inverse() : this.transform);
    }

    @Override
    public BlockState getBlock(BlockVector3 position) {
        return this.transformBlock(super.getBlock(position), false).toImmutableState();
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return this.transformBlock(super.getBlock(x, y, z), false).toImmutableState();
    }

    @Override
    public BaseBlock getFullBlock(BlockVector3 position) {
        return this.transformBlock(super.getFullBlock(position), false).toBaseBlock();
    }

    @Override
    public BaseBlock getFullBlock(int x, int y, int z) {
        return this.transformBlock(super.getFullBlock(x, y, z), false).toBaseBlock();
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        return super.setBlock(location, this.transformInverse(block));
    }

    @Override
    public <T extends BlockStateHolder<T>> boolean setBlock(int x, int y, int z, T block) throws WorldEditException {
        return super.setBlock(x, y, z, this.transformInverse(block));
    }

    public void setTransform(Transform affine) {
        this.transform = affine;
        this.transformInverse = this.transform.inverse();
        this.cache();
    }

    public static <B extends BlockStateHolder<B>> B transform(@Nonnull B block, @Nonnull Transform transform) {
        BlockState state = block.toImmutableState();
        int transformedId = BlockTransformExtent.transformState(state, transform);
        BlockState transformed = BlockState.getFromInternalId(transformedId);
        boolean baseBlock = block instanceof BaseBlock;
        if (baseBlock && block.hasNbtData()) {
            return (B)BlockTransformExtent.transformBaseBlockNBT(transformed, block.getNbtData(), transform);
        }
        return (B)(baseBlock ? transformed.toBaseBlock() : transformed);
    }

    private BlockState transform(BlockState state, int[][] transformArray, Transform transform) {
        int typeId = state.getInternalBlockTypeId();
        int[] arr = transformArray[typeId];
        if (arr == this.ALL) {
            return state;
        }
        if (arr == null) {
            transformArray[typeId] = new int[state.getBlockType().getMaxStateId() + 1];
            arr = transformArray[typeId];
            Arrays.fill(arr, -1);
        }
        int mask = this.BLOCK_ROTATION_BITMASK[typeId];
        int internalId = state.getInternalId();
        int maskedId = internalId & mask;
        int newMaskedId = arr[maskedId >> BlockTypesCache.BIT_OFFSET];
        if (newMaskedId != -1) {
            return BlockState.getFromInternalId(newMaskedId | internalId & ~mask);
        }
        newMaskedId = BlockTransformExtent.transformState(state, transform);
        arr[maskedId >> BlockTypesCache.BIT_OFFSET] = newMaskedId & mask;
        return BlockState.getFromInternalId(newMaskedId);
    }

    public final BaseBlock transform(BlockStateHolder<BaseBlock> block) {
        BlockState transformed = this.transform(block.toImmutableState());
        if (block.hasNbtData()) {
            return BlockTransformExtent.transformBaseBlockNBT(transformed, block.getNbtData(), this.transform);
        }
        return transformed.toBaseBlock();
    }

    protected final BlockStateHolder transformInverse(BlockStateHolder block) {
        BlockState transformed = this.transformInverse(block.toImmutableState());
        if (block.hasNbtData()) {
            return BlockTransformExtent.transformBaseBlockNBT(transformed, block.getNbtData(), this.transformInverse);
        }
        return transformed;
    }

    public final BlockState transform(BlockState block) {
        return this.transform(block, this.BLOCK_TRANSFORM, this.transform);
    }

    private BlockState transformInverse(BlockState block) {
        return this.transform(block, this.BLOCK_TRANSFORM_INVERSE, this.transformInverse);
    }
}

