/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.visitor;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.internal.exception.FaweException;
import com.fastasyncworldedit.core.queue.implementation.ParallelQueueExtent;
import com.fastasyncworldedit.core.queue.implementation.SingleThreadQueueExtent;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.RunContext;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.util.Iterator;

@Deprecated
public class RegionVisitor
implements Operation {
    public final Iterable<? extends BlockVector3> iterable;
    private final SingleThreadQueueExtent singleQueue;
    private final Region region;
    private final RegionFunction function;
    private int affected = 0;

    @Deprecated
    public RegionVisitor(Region region, RegionFunction function) {
        this(region, function, null);
    }

    public RegionVisitor(Iterable<BlockVector3> iterable, RegionFunction function, Extent extent) {
        ExtentTraverser<ParallelQueueExtent> queueTraverser;
        this.region = iterable instanceof Region ? (Region)iterable : null;
        this.iterable = iterable;
        this.function = function;
        this.singleQueue = extent != null ? ((queueTraverser = new ExtentTraverser<Extent>(extent).find(ParallelQueueExtent.class)) != null ? (SingleThreadQueueExtent)queueTraverser.get().getExtent() : null) : null;
    }

    public int getAffected() {
        return this.affected;
    }

    @Override
    public Operation resume(RunContext run) throws WorldEditException {
        if (this.singleQueue != null && Settings.settings().QUEUE.PRELOAD_CHUNK_COUNT > 1) {
            Iterator<? extends BlockVector3> trailIter = this.iterable.iterator();
            Iterator<? extends BlockVector3> leadIter = this.iterable.iterator();
            int lastTrailChunkX = Integer.MIN_VALUE;
            int lastTrailChunkZ = Integer.MIN_VALUE;
            int lastLeadChunkX = Integer.MIN_VALUE;
            int lastLeadChunkZ = Integer.MIN_VALUE;
            int loadingTarget = Settings.settings().QUEUE.PRELOAD_CHUNK_COUNT;
            while (trailIter.hasNext()) {
                block16: {
                    BlockVector3 pt = trailIter.next();
                    this.apply(pt);
                    int cx = pt.getBlockX() >> 4;
                    int cz = pt.getBlockZ() >> 4;
                    if (cx != lastTrailChunkX || cz != lastTrailChunkZ) {
                        int amount;
                        lastTrailChunkX = cx;
                        lastTrailChunkZ = cz;
                        if (lastLeadChunkX == Integer.MIN_VALUE) {
                            lastLeadChunkX = cx;
                            lastLeadChunkZ = cz;
                            amount = loadingTarget;
                        } else {
                            amount = 1;
                        }
                        try {
                            int count = 0;
                            while (count < amount) {
                                BlockVector3 v = leadIter.next();
                                int vcx = v.getBlockX() >> 4;
                                int vcz = v.getBlockZ() >> 4;
                                if (vcx != lastLeadChunkX || vcz != lastLeadChunkZ) {
                                    lastLeadChunkX = vcx;
                                    lastLeadChunkZ = vcz;
                                    this.singleQueue.addChunkLoad(vcx, vcz);
                                    ++count;
                                }
                                for (int i = 0; i < 16; ++i) {
                                    if (leadIter.hasNext()) {
                                        leadIter.next();
                                        continue;
                                    }
                                    break block16;
                                }
                            }
                        }
                        catch (FaweException e) {
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                for (int i = 0; i < 16; ++i) {
                    if (!trailIter.hasNext()) {
                        return null;
                    }
                    this.apply(trailIter.next());
                }
            }
        } else {
            for (BlockVector3 pt : this.region) {
                this.apply(pt);
            }
        }
        return null;
    }

    private void apply(BlockVector3 pt) throws WorldEditException {
        if (this.function.apply(pt)) {
            ++this.affected;
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public Iterable<Component> getStatusMessages() {
        return ImmutableList.of((Object)Caption.of("worldedit.operation.affected.block", TextComponent.of((int)this.getAffected())));
    }
}

