/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.history.change;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public class BlockChange
implements Change {
    private final BlockVector3 position;
    private final BaseBlock previous;
    private final BaseBlock current;

    public <BP extends BlockStateHolder<BP>, BC extends BlockStateHolder<BC>> BlockChange(BlockVector3 position, BP previous, BC current) {
        Preconditions.checkNotNull((Object)position);
        Preconditions.checkNotNull(previous);
        Preconditions.checkNotNull(current);
        this.position = position;
        this.previous = previous.toBaseBlock();
        this.current = current.toBaseBlock();
    }

    public BlockVector3 getPosition() {
        return this.position;
    }

    public BaseBlock getPrevious() {
        return this.previous;
    }

    public BaseBlock getCurrent() {
        return this.current;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        ((Extent)Preconditions.checkNotNull((Object)context.getExtent())).setBlock(this.position, this.previous);
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        ((Extent)Preconditions.checkNotNull((Object)context.getExtent())).setBlock(this.position, this.current);
    }
}

