/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.expression;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.antlr.ExpressionLexer;
import com.sk89q.worldedit.antlr.ExpressionParser;
import com.sk89q.worldedit.internal.expression.CompiledExpression;
import com.sk89q.worldedit.internal.expression.EvaluationException;
import com.sk89q.worldedit.internal.expression.ExecutionData;
import com.sk89q.worldedit.internal.expression.ExpressionEnvironment;
import com.sk89q.worldedit.internal.expression.ExpressionException;
import com.sk89q.worldedit.internal.expression.ExpressionValidator;
import com.sk89q.worldedit.internal.expression.Functions;
import com.sk89q.worldedit.internal.expression.LexerErrorListener;
import com.sk89q.worldedit.internal.expression.LocalSlot;
import com.sk89q.worldedit.internal.expression.ParserErrorListener;
import com.sk89q.worldedit.internal.expression.ParserException;
import com.sk89q.worldedit.internal.expression.SlotTable;
import com.sk89q.worldedit.internal.expression.invoke.ExpressionCompiler;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class Expression
implements Cloneable {
    private final SlotTable slots = new SlotTable();
    private final List<String> providedSlots;
    private final ExpressionParser.AllStatementsContext root;
    private final Functions functions = Functions.create();
    private final CompiledExpression compiledExpression;
    private final String initialExpression;

    public static Expression compile(String expression, String ... variableNames) throws ExpressionException {
        return new Expression(expression, variableNames);
    }

    private Expression(String expression, String ... variableNames) throws ExpressionException {
        this.initialExpression = expression;
        this.slots.putSlot("e", new LocalSlot.Constant(Math.E));
        this.slots.putSlot("pi", new LocalSlot.Constant(Math.PI));
        this.slots.putSlot("true", new LocalSlot.Constant(1.0));
        this.slots.putSlot("false", new LocalSlot.Constant(0.0));
        for (String variableName : variableNames) {
            this.slots.initVariable(variableName).orElseThrow(() -> new ExpressionException(-1, "Tried to overwrite identifier '" + variableName + "'"));
        }
        this.providedSlots = ImmutableList.copyOf((Object[])variableNames);
        CodePointCharStream cs = CharStreams.fromString((String)expression, (String)"<input>");
        ExpressionLexer lexer = new ExpressionLexer((CharStream)cs);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new LexerErrorListener());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExpressionParser parser = new ExpressionParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ParserErrorListener());
        try {
            this.root = parser.allStatements();
            Objects.requireNonNull(this.root, "Unable to parse root, but no exceptions?");
        }
        catch (ParseCancellationException e) {
            throw new ParserException(parser.getState(), (Throwable)e);
        }
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)new ExpressionValidator(this.slots.keySet(), this.functions), (ParseTree)this.root);
        this.compiledExpression = new ExpressionCompiler().compileExpression(this.root, this.functions);
    }

    private Expression(String expression, Set<String> variableNames) throws ExpressionException {
        this.initialExpression = expression;
        this.slots.putSlot("e", new LocalSlot.Constant(Math.E));
        this.slots.putSlot("pi", new LocalSlot.Constant(Math.PI));
        this.slots.putSlot("true", new LocalSlot.Constant(1.0));
        this.slots.putSlot("false", new LocalSlot.Constant(0.0));
        for (String variableName : variableNames) {
            this.slots.initVariable(variableName).orElseThrow(() -> new ExpressionException(-1, "Tried to overwrite identifier '" + variableName + "'"));
        }
        this.providedSlots = ImmutableList.copyOf(variableNames);
        CodePointCharStream cs = CharStreams.fromString((String)expression, (String)"<input>");
        ExpressionLexer lexer = new ExpressionLexer((CharStream)cs);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new LexerErrorListener());
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExpressionParser parser = new ExpressionParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ParserErrorListener());
        try {
            this.root = parser.allStatements();
            Objects.requireNonNull(this.root, "Unable to parse root, but no exceptions?");
        }
        catch (ParseCancellationException e) {
            throw new ParserException(parser.getState(), (Throwable)e);
        }
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)new ExpressionValidator(this.slots.keySet(), this.functions), (ParseTree)this.root);
        this.compiledExpression = new ExpressionCompiler().compileExpression(this.root, this.functions);
    }

    public double evaluate(double ... values) throws EvaluationException {
        return this.evaluate(values, WorldEdit.getInstance().getConfiguration().calculationTimeout);
    }

    public double evaluate(double[] values, int timeout) throws EvaluationException {
        for (int i = 0; i < values.length; ++i) {
            String slotName = this.providedSlots.get(i);
            LocalSlot.Variable slot = this.slots.getVariable(slotName).orElseThrow(() -> new EvaluationException(-1, "Tried to assign to non-variable " + slotName + "."));
            slot.setValue(values[i]);
        }
        Instant deadline = Instant.now().plusMillis(timeout);
        Double result = this.compiledExpression.execute(new ExecutionData(this.slots, this.functions, deadline));
        if (result == null) {
            throw new EvaluationException(-1, "Expression must result in a value");
        }
        return result;
    }

    public void optimize() {
    }

    public String toString() {
        return this.root.toString();
    }

    public SlotTable getSlots() {
        return this.slots;
    }

    public ExpressionEnvironment getEnvironment() {
        return this.functions.getEnvironment();
    }

    public void setEnvironment(ExpressionEnvironment environment) {
        this.functions.setEnvironment(environment);
    }

    public Expression clone() {
        return new Expression(this.initialExpression, new HashSet<String>(this.providedSlots));
    }
}

