/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math;

import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BitMath;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3Imp;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Comparator;

public abstract class BlockVector3 {
    public static final BlockVector3 ZERO = BlockVector3.at(0, 0, 0);
    public static final BlockVector3 UNIT_X = BlockVector3.at(1, 0, 0);
    public static final BlockVector3 UNIT_Y = BlockVector3.at(0, 1, 0);
    public static final BlockVector3 UNIT_Z = BlockVector3.at(0, 0, 1);
    public static final BlockVector3 UNIT_MINUS_X = BlockVector3.at(-1, 0, 0);
    public static final BlockVector3 UNIT_MINUS_Y = BlockVector3.at(0, -1, 0);
    public static final BlockVector3 UNIT_MINUS_Z = BlockVector3.at(0, 0, -1);
    public static final BlockVector3 ONE = BlockVector3.at(1, 1, 1);
    private static final int WORLD_XZ_MINMAX = 30000000;
    private static final int WORLD_Y_MIN = -2048;
    private static final int WORLD_Y_MAX = 2047;
    private static final long BITS_26 = BitMath.mask(26);
    private static final long BITS_12 = BitMath.mask(12);

    public static BlockVector3 at(double x, double y, double z) {
        return BlockVector3.at((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    public static BlockVector3 at(int x, int y, int z) {
        return new BlockVector3Imp(x, y, z);
    }

    private static boolean isHorizontallyInBounds(int h) {
        return -30000000 <= h && h <= 30000000;
    }

    public static boolean isLongPackable(BlockVector3 location) {
        return BlockVector3.isHorizontallyInBounds(location.getX()) && BlockVector3.isHorizontallyInBounds(location.getZ()) && -2048 <= location.getY() && location.getY() <= 2047;
    }

    public static void checkLongPackable(BlockVector3 location) {
        Preconditions.checkArgument((boolean)BlockVector3.isLongPackable(location), (String)"Location exceeds long packing limits: %s", (Object)location);
    }

    public static BlockVector3 fromLongPackedForm(long packed) {
        return BlockVector3.at(BitMath.unpackX(packed), BitMath.unpackY(packed), BitMath.unpackZ(packed));
    }

    public static Comparator<BlockVector3> sortByCoordsYzx() {
        return YzxOrderComparator.YZX_ORDER;
    }

    public MutableBlockVector3 setComponents(double x, double y, double z) {
        return new MutableBlockVector3((int)x, (int)y, (int)z);
    }

    public MutableBlockVector3 setComponents(int x, int y, int z) {
        return new MutableBlockVector3(x, y, z);
    }

    public long toLongPackedForm() {
        BlockVector3.checkLongPackable(this);
        return (long)this.getX() & BITS_26 | ((long)this.getZ() & BITS_26) << 26 | ((long)this.getY() & BITS_12) << 52;
    }

    public MutableBlockVector3 mutX(double x) {
        return new MutableBlockVector3((int)x, this.getY(), this.getZ());
    }

    public MutableBlockVector3 mutY(double y) {
        return new MutableBlockVector3(this.getX(), (int)y, this.getZ());
    }

    public MutableBlockVector3 mutZ(double z) {
        return new MutableBlockVector3(this.getX(), this.getY(), (int)z);
    }

    public MutableBlockVector3 mutX(int x) {
        return new MutableBlockVector3(x, this.getY(), this.getZ());
    }

    public MutableBlockVector3 mutY(int y) {
        return new MutableBlockVector3(this.getX(), y, this.getZ());
    }

    public MutableBlockVector3 mutZ(int z) {
        return new MutableBlockVector3(this.getX(), this.getY(), z);
    }

    public BlockVector3 toImmutable() {
        return BlockVector3.at(this.getX(), this.getY(), this.getZ());
    }

    public abstract int getX();

    public int getBlockX() {
        return this.getX();
    }

    public BlockVector3 withX(int x) {
        return BlockVector3.at(x, this.getY(), this.getZ());
    }

    public abstract int getY();

    public int getBlockY() {
        return this.getY();
    }

    public BlockVector3 withY(int y) {
        return BlockVector3.at(this.getX(), y, this.getZ());
    }

    public abstract int getZ();

    public int getBlockZ() {
        return this.getZ();
    }

    public BlockVector3 withZ(int z) {
        return BlockVector3.at(this.getX(), this.getY(), z);
    }

    public BlockVector3 add(BlockVector3 other) {
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    public BlockVector3 add(int x, int y, int z) {
        return BlockVector3.at(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public BlockVector3 add(BlockVector3 ... others) {
        int newX = this.getX();
        int newY = this.getY();
        int newZ = this.getZ();
        for (BlockVector3 other : others) {
            newX += other.getX();
            newY += other.getY();
            newZ += other.getZ();
        }
        return BlockVector3.at(newX, newY, newZ);
    }

    public BlockVector3 subtract(BlockVector3 other) {
        return this.subtract(other.getX(), other.getY(), other.getZ());
    }

    public BlockVector3 subtract(int x, int y, int z) {
        return BlockVector3.at(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    public BlockVector3 subtract(BlockVector3 ... others) {
        int newX = this.getX();
        int newY = this.getY();
        int newZ = this.getZ();
        for (BlockVector3 other : others) {
            newX -= other.getX();
            newY -= other.getY();
            newZ -= other.getZ();
        }
        return BlockVector3.at(newX, newY, newZ);
    }

    public BlockVector3 multiply(BlockVector3 other) {
        return this.multiply(other.getX(), other.getY(), other.getZ());
    }

    public BlockVector3 multiply(int x, int y, int z) {
        return BlockVector3.at(this.getX() * x, this.getY() * y, this.getZ() * z);
    }

    public BlockVector3 multiply(BlockVector3 ... others) {
        int newX = this.getX();
        int newY = this.getY();
        int newZ = this.getZ();
        for (BlockVector3 other : others) {
            newX *= other.getX();
            newY *= other.getY();
            newZ *= other.getZ();
        }
        return BlockVector3.at(newX, newY, newZ);
    }

    public BlockVector3 multiply(int n) {
        return this.multiply(n, n, n);
    }

    public BlockVector3 divide(BlockVector3 other) {
        return this.divide(other.getX(), other.getY(), other.getZ());
    }

    public BlockVector3 divide(int x, int y, int z) {
        return BlockVector3.at(this.getX() / x, this.getY() / y, this.getZ() / z);
    }

    public BlockVector3 divide(int n) {
        return this.divide(n, n, n);
    }

    public BlockVector3 shr(int x, int y, int z) {
        return BlockVector3.at(this.getX() >> x, this.getY() >> y, this.getZ() >> z);
    }

    public BlockVector3 shr(int n) {
        return this.shr(n, n, n);
    }

    public BlockVector3 shl(int x, int y, int z) {
        return BlockVector3.at(this.getX() << x, this.getY() << y, this.getZ() << z);
    }

    public BlockVector3 shl(int n) {
        return this.shl(n, n, n);
    }

    public double length() {
        return Math.sqrt(this.lengthSq());
    }

    public int lengthSq() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public double distance(BlockVector3 other) {
        return Math.sqrt(this.distanceSq(other));
    }

    public int distanceSq(BlockVector3 other) {
        int dx = other.getX() - this.getX();
        int dy = other.getY() - this.getY();
        int dz = other.getZ() - this.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public BlockVector3 normalize() {
        double len = this.length();
        double x = (double)this.getX() / len;
        double y = (double)this.getY() / len;
        double z = (double)this.getZ() / len;
        return BlockVector3.at(x, y, z);
    }

    public double dot(BlockVector3 other) {
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ();
    }

    public BlockVector3 cross(BlockVector3 other) {
        return new BlockVector3Imp(this.getY() * other.getZ() - this.getZ() * other.getY(), this.getZ() * other.getX() - this.getX() * other.getZ(), this.getX() * other.getY() - this.getY() * other.getX());
    }

    public boolean containedWithin(BlockVector3 min, BlockVector3 max) {
        return this.getX() >= min.getX() && this.getX() <= max.getX() && this.getY() >= min.getY() && this.getY() <= max.getY() && this.getZ() >= min.getZ() && this.getZ() <= max.getZ();
    }

    public BlockVector3 clampY(int min, int max) {
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"minimum cannot be greater than maximum");
        if (this.getY() < min) {
            return BlockVector3.at(this.getX(), min, this.getZ());
        }
        if (this.getY() > max) {
            return BlockVector3.at(this.getX(), max, this.getZ());
        }
        return this;
    }

    public BlockVector3 floor() {
        return this;
    }

    public BlockVector3 ceil() {
        return this;
    }

    public BlockVector3 round() {
        return this;
    }

    public BlockVector3 abs() {
        return BlockVector3.at(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()));
    }

    public BlockVector3 transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = (double)this.getX() - aboutX;
        double z = (double)this.getZ() - aboutZ;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x2 = x * cos - z * sin;
        double z2 = x * sin + z * cos;
        return BlockVector3.at(x2 + aboutX + translateX, (double)this.getY(), z2 + aboutZ + translateZ);
    }

    public double toPitch() {
        double x = this.getX();
        double z = this.getZ();
        if (x == 0.0 && z == 0.0) {
            return this.getY() > 0 ? -90.0 : 90.0;
        }
        double x2 = x * x;
        double z2 = z * z;
        double xz = Math.sqrt(x2 + z2);
        return Math.toDegrees(Math.atan((double)(-this.getY()) / xz));
    }

    public double toYaw() {
        double x = this.getX();
        double z = this.getZ();
        double t = Math.atan2(-x, z);
        double tau = Math.PI * 2;
        return Math.toDegrees((t + tau) % tau);
    }

    public BlockVector3 getMinimum(BlockVector3 v2) {
        return new BlockVector3Imp(Math.min(this.getX(), v2.getX()), Math.min(this.getY(), v2.getY()), Math.min(this.getZ(), v2.getZ()));
    }

    public BlockVector3 getMaximum(BlockVector3 v2) {
        return new BlockVector3Imp(Math.max(this.getX(), v2.getX()), Math.max(this.getY(), v2.getY()), Math.max(this.getZ(), v2.getZ()));
    }

    public boolean setOrdinal(Extent orDefault, int ordinal) {
        return orDefault.setBlock(this, BlockState.getFromOrdinal(ordinal));
    }

    public boolean setBlock(Extent orDefault, BlockState state) {
        return orDefault.setBlock(this, state);
    }

    public boolean setFullBlock(Extent orDefault, BaseBlock block) {
        return orDefault.setBlock(this, block);
    }

    public int getOrdinal(Extent orDefault) {
        return this.getBlock(orDefault).getOrdinal();
    }

    public char getOrdinalChar(Extent orDefault) {
        return (char)this.getOrdinal(orDefault);
    }

    public BlockState getBlock(Extent orDefault) {
        return orDefault.getBlock(this);
    }

    public BaseBlock getFullBlock(Extent orDefault) {
        return orDefault.getFullBlock(this);
    }

    public boolean setBiome(Extent orDefault, BiomeType type) {
        return orDefault.setBiome(this, type);
    }

    public BiomeType getBiome(Extent orDefault) {
        return orDefault.getBiome(this);
    }

    public CompoundTag getNbtData(Extent orDefault) {
        return orDefault.getFullBlock(this.getX(), this.getY(), this.getZ()).getNbtData();
    }

    public BlockState getOrdinalBelow(Extent orDefault) {
        return orDefault.getBlock(this.getX(), this.getY() - 1, this.getZ());
    }

    public BlockState getStateAbove(Extent orDefault) {
        return orDefault.getBlock(this.getX(), this.getY() + 1, this.getZ());
    }

    public BlockState getStateRelativeY(Extent orDefault, int y) {
        return orDefault.getBlock(this.getX(), this.getY() + y, this.getZ());
    }

    public BlockVector2 toBlockVector2() {
        return BlockVector2.at(this.getX(), this.getZ());
    }

    public Vector3 toVector3() {
        return Vector3.at(this.getX(), this.getY(), this.getZ());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlockVector3)) {
            return false;
        }
        BlockVector3 other = (BlockVector3)obj;
        return other.getX() == this.getX() && other.getY() == this.getY() && other.getZ() == this.getZ();
    }

    public final boolean equals(BlockVector3 other) {
        if (other == null) {
            return false;
        }
        return other.getX() == this.getX() && other.getY() == this.getY() && other.getZ() == this.getZ();
    }

    public int hashCode() {
        return this.getX() ^ this.getZ() << 12 ^ this.getY() << 24;
    }

    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ")";
    }

    public String toParserString() {
        return this.getX() + "," + this.getY() + "," + this.getZ();
    }

    public BlockVector3 plus(BlockVector3 other) {
        return this.add(other);
    }

    private static final class YzxOrderComparator {
        private static final Comparator<BlockVector3> YZX_ORDER = Comparator.comparingInt(BlockVector3::getY).thenComparingInt(BlockVector3::getZ).thenComparingInt(BlockVector3::getX);

        private YzxOrderComparator() {
        }
    }
}

