/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extent.filter.block.ChunkFilterBlock;
import com.fastasyncworldedit.core.queue.Filter;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.geom.Polygons;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.iterator.FlatRegion3DIterator;
import com.sk89q.worldedit.regions.iterator.FlatRegionIterator;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.world.World;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.List;

public class CylinderRegion
extends AbstractRegion
implements FlatRegion {
    private BlockVector2 center;
    private Vector2 radius;
    private Vector2 radiusInverse;
    private int minY;
    private int maxY;
    private boolean hasY = false;
    private static final BigDecimal PI = BigDecimal.valueOf(Math.PI);

    public CylinderRegion() {
        this((World)null);
    }

    public CylinderRegion(World world) {
        this(world, BlockVector3.ZERO, Vector2.ZERO, 0, 0);
        this.hasY = false;
    }

    public CylinderRegion(World world, BlockVector3 center, Vector2 radius, int minY, int maxY) {
        super(world);
        this.setCenter(center.toBlockVector2());
        this.setRadius(radius);
        this.minY = minY;
        this.maxY = maxY;
        this.hasY = true;
    }

    public CylinderRegion(BlockVector3 center, Vector2 radius, int minY, int maxY) {
        super(null);
        this.setCenter(center.toBlockVector2());
        this.setRadius(radius);
        this.minY = minY;
        this.maxY = maxY;
        this.hasY = true;
    }

    public CylinderRegion(CylinderRegion region) {
        this(region.world, region.getCenter().toBlockPoint(), region.getRadius(), region.minY, region.maxY);
        this.hasY = region.hasY;
    }

    @Override
    public Vector3 getCenter() {
        return this.center.toVector3((this.maxY + this.minY) / 2);
    }

    public void setCenter(BlockVector2 center) {
        this.center = center;
    }

    public Vector2 getRadius() {
        return this.radius.subtract(0.5, 0.5);
    }

    public void setRadius(Vector2 radius) {
        this.radius = radius.add(0.5, 0.5);
        this.radiusInverse = Vector2.ONE.divide(radius);
    }

    public void extendRadius(Vector2 minRadius) {
        this.setRadius(minRadius.getMaximum(this.getRadius()));
    }

    public void setMinimumY(int y) {
        this.hasY = true;
        this.minY = y;
    }

    public void setMaximumY(int y) {
        this.hasY = true;
        this.maxY = y;
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return this.center.toVector2().subtract(this.getRadius()).toVector3(this.minY).toBlockPoint();
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return this.center.toVector2().add(this.getRadius()).toVector3(this.maxY).toBlockPoint();
    }

    @Override
    public int getMaximumY() {
        return this.maxY;
    }

    @Override
    public int getMinimumY() {
        return this.minY;
    }

    @Override
    public long getVolume() {
        return BigDecimal.valueOf(this.radius.getX()).multiply(BigDecimal.valueOf(this.radius.getZ())).multiply(PI).multiply(BigDecimal.valueOf(this.getHeight())).setScale(0, RoundingMode.FLOOR).longValue();
    }

    @Override
    public int getWidth() {
        return (int)(2.0 * this.radius.getX());
    }

    @Override
    public int getHeight() {
        return this.maxY - this.minY + 1;
    }

    @Override
    public int getLength() {
        return (int)(2.0 * this.radius.getZ());
    }

    private BlockVector2 calculateDiff2D(BlockVector3 ... changes) throws RegionOperationException {
        BlockVector2 diff = BlockVector2.ZERO;
        for (BlockVector3 change : changes) {
            diff = diff.add(change.toBlockVector2());
        }
        if ((diff.getBlockX() & 1) + (diff.getBlockZ() & 1) != 0) {
            throw new RegionOperationException((Component)Caption.of("worldedit.selection.cylinder.error.even-horizontal", new Object[0]));
        }
        return diff.divide(2).floor();
    }

    private BlockVector2 calculateChanges2D(BlockVector3 ... changes) {
        BlockVector2 total = BlockVector2.ZERO;
        for (BlockVector3 change : changes) {
            total = total.add(change.toBlockVector2().abs());
        }
        return total.divide(2).floor();
    }

    @Override
    public void expand(BlockVector3 ... changes) throws RegionOperationException {
        this.center = this.center.add(this.calculateDiff2D(changes));
        this.radius = this.radius.add(this.calculateChanges2D(changes).toVector2());
        this.radiusInverse = Vector2.ONE.divide(this.radius);
        for (BlockVector3 change : changes) {
            int changeY = change.getBlockY();
            if (changeY > 0) {
                this.maxY += changeY;
                continue;
            }
            this.minY += changeY;
        }
    }

    @Override
    public void contract(BlockVector3 ... changes) throws RegionOperationException {
        this.center = this.center.subtract(this.calculateDiff2D(changes));
        Vector2 newRadius = this.radius.subtract(this.calculateChanges2D(changes).toVector2());
        this.radius = Vector2.at(1.5, 1.5).getMaximum(newRadius);
        this.radiusInverse = Vector2.ONE.divide(this.radius);
        for (BlockVector3 change : changes) {
            int height = this.maxY - this.minY;
            int changeY = change.getBlockY();
            if (changeY > 0) {
                this.minY += Math.min(height, changeY);
                continue;
            }
            this.maxY += Math.max(-height, changeY);
        }
    }

    @Override
    public void shift(BlockVector3 change) throws RegionOperationException {
        this.center = this.center.add(change.toBlockVector2());
        int changeY = change.getBlockY();
        this.maxY += changeY;
        this.minY += changeY;
    }

    @Override
    public boolean contains(int x, int y, int z) {
        if (y < this.minY || y > this.maxY) {
            return false;
        }
        return this.contains(x, z);
    }

    @Override
    public boolean contains(int x, int z) {
        double dz;
        double dx = (double)Math.abs(x - this.center.getBlockX()) * this.radiusInverse.getX();
        return dx * dx + (dz = (double)Math.abs(z - this.center.getBlockZ()) * this.radiusInverse.getZ()) * dz <= 1.0;
    }

    @Override
    public boolean contains(BlockVector3 position) {
        return this.contains(position.getX(), position.getY(), position.getZ());
    }

    public boolean setY(int y) {
        if (!this.hasY) {
            this.minY = y;
            this.maxY = y;
            this.hasY = true;
            return true;
        }
        if (y < this.minY) {
            this.minY = y;
            return true;
        }
        if (y > this.maxY) {
            this.maxY = y;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<BlockVector3> iterator() {
        return new FlatRegion3DIterator(this);
    }

    @Override
    public Iterable<BlockVector2> asFlatRegion() {
        return () -> new FlatRegionIterator(this);
    }

    @Override
    public String toString() {
        return this.center + " - " + this.radius + "(" + this.minY + ", " + this.maxY + ")";
    }

    @Override
    public CylinderRegion clone() {
        return (CylinderRegion)super.clone();
    }

    @Override
    public List<BlockVector2> polygonize(int maxPoints) {
        return Polygons.polygonizeCylinder(this.center, this.radius, maxPoints);
    }

    public static CylinderRegion createRadius(Extent extent, BlockVector3 center, double radius) {
        Preconditions.checkNotNull((Object)extent);
        Preconditions.checkNotNull((Object)center);
        Vector2 radiusVec = Vector2.at(radius, radius);
        int minY = extent.getMinimumPoint().getBlockY();
        int maxY = extent.getMaximumPoint().getBlockY();
        return new CylinderRegion(center, radiusVec, minY, maxY);
    }

    @Override
    public void filter(IChunk chunk, Filter filter, ChunkFilterBlock block, IChunkGet get, IChunkSet set, boolean full) {
        int bcx = chunk.getX() >> 4;
        int bcz = chunk.getZ() >> 4;
        int tcx = bcx + 15;
        int tcz = bcz + 15;
        if (this.contains(bcx, bcz) && this.contains(tcx, tcz)) {
            this.filter(chunk, filter, block, get, set, this.minY, this.maxY, full);
            return;
        }
        super.filter(chunk, filter, block, get, set, full);
    }
}

