/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry.state;

import com.fastasyncworldedit.core.limit.PropertyRemap;
import com.fastasyncworldedit.core.registry.state.PropertyKey;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public interface Property<T> {
    public String getName();

    public List<T> getValues();

    @Nullable
    public T getValueFor(String var1) throws IllegalArgumentException;

    default public int getIndex(T value) {
        return this.getValues().indexOf(value);
    }

    default public int getIndexFor(CharSequence value) throws IllegalArgumentException {
        return this.getIndex(this.getValueFor(value.toString()));
    }

    default public PropertyKey getKey() {
        return PropertyKey.getOrCreate(this.getName());
    }

    default public PropertyRemap<T> getRemap(Object from, Object to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        return new PropertyRemap<Object>(this, from, to);
    }
}

