/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.translation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.renderer.TranslatableComponentRenderer;
import com.sk89q.worldedit.util.io.ResourceLoader;
import com.sk89q.worldedit.util.io.file.ArchiveUnpacker;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class TranslationManager {
    private static final Gson gson = new GsonBuilder().create();
    private static final Type STRING_MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private final Map<Locale, Map<String, String>> translationMap = new ConcurrentHashMap<Locale, Map<String, String>>();
    private final TranslatableComponentRenderer<Locale> friendlyComponentRenderer = TranslatableComponentRenderer.from((locale, key) -> {
        String translation = this.getTranslationMap((Locale)locale).get(key);
        if (translation == null) {
            return null;
        }
        return new MessageFormat(translation, (Locale)locale);
    });
    private Locale defaultLocale = Locale.ENGLISH;
    private final ResourceLoader resourceLoader;
    private final Set<Locale> checkedLocales = new HashSet<Locale>();

    public static String makeTranslationKey(String type, String id) {
        String[] parts = id.split(":", 2);
        return type + "." + parts[0] + "." + parts[1].replace('/', '.');
    }

    public TranslationManager(ResourceLoader resourceLoader) {
        Preconditions.checkNotNull((Object)resourceLoader);
        this.resourceLoader = resourceLoader;
    }

    public TranslationManager(ArchiveUnpacker archiveUnpacker, ResourceLoader resourceLoader) {
        this(resourceLoader);
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    private Map<String, String> filterTranslations(Map<String, String> translations) {
        return translations.entrySet().stream().filter(e -> !((String)e.getValue()).isEmpty()).map(e -> Maps.immutableEntry((Object)((String)e.getKey()), (Object)((String)e.getValue()).replace("'", "''"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, String> parseTranslationFile(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            Map<String, String> map = this.filterTranslations((Map)gson.fromJson((Reader)reader, STRING_MAP_TYPE));
            return map;
        }
    }

    private Optional<Map<String, String>> loadTranslationFile(String filename) {
        InputStream stream;
        Map<Object, Object> baseTranslations;
        block17: {
            baseTranslations = new ConcurrentHashMap();
            try {
                URL resource = this.resourceLoader.getRootResource("lang/" + filename);
                if (resource == null) break block17;
                stream = resource.openStream();
                try {
                    baseTranslations = this.parseTranslationFile(stream);
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException resource) {
                // empty catch block
            }
        }
        Path localFile = this.resourceLoader.getLocalResource("lang/" + filename);
        if (Files.exists(localFile, new LinkOption[0])) {
            try {
                stream = Files.newInputStream(localFile, new OpenOption[0]);
                try {
                    baseTranslations.putAll(this.parseTranslationFile(stream));
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return baseTranslations.size() == 0 ? Optional.empty() : Optional.of(baseTranslations);
    }

    private boolean tryLoadTranslations(Locale locale) {
        if (this.checkedLocales.contains(locale)) {
            return false;
        }
        this.checkedLocales.add(locale);
        ConcurrentHashMap<String, String> baseTranslations = new ConcurrentHashMap<String, String>();
        if (!locale.equals(this.defaultLocale)) {
            baseTranslations.putAll(this.getTranslationMap(this.defaultLocale));
        }
        Optional<Object> langData = Optional.empty();
        if (!locale.getCountry().isEmpty()) {
            langData = this.loadTranslationFile(locale.getLanguage() + "-" + locale.getCountry() + "/strings.json");
        }
        if (!langData.isPresent()) {
            langData = this.loadTranslationFile(locale.getLanguage() + "/strings.json");
        }
        if (langData.isPresent()) {
            baseTranslations.putAll((Map)langData.get());
            this.translationMap.put(locale, baseTranslations);
            return true;
        }
        if (locale.equals(this.defaultLocale)) {
            this.translationMap.put(Locale.ENGLISH, this.loadTranslationFile("strings.json").orElseThrow(() -> new RuntimeException("Failed to load WorldEdit strings!")));
            return true;
        }
        return false;
    }

    public Map<String, String> getTranslationMap(Locale locale) {
        Map<String, String> translations = this.translationMap.get(locale);
        if (translations == null) {
            if (this.tryLoadTranslations(locale)) {
                return this.getTranslationMap(locale);
            }
            if (!locale.equals(this.defaultLocale)) {
                translations = this.getTranslationMap(this.defaultLocale);
            }
        }
        return translations;
    }

    public Component convertText(Component component, Locale locale) {
        return this.friendlyComponentRenderer.render(component, (Object)locale);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }
}

