/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.fastasyncworldedit.core.queue.ITileInput;
import com.fastasyncworldedit.core.registry.state.PropertyKey;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.extent.OutputExtent;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.internal.util.DeprecationUtil;
import com.sk89q.worldedit.internal.util.NonAbstractForCompatibility;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.registry.BlockMaterial;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public interface BlockStateHolder<B extends BlockStateHolder<B>>
extends TileEntityBlock,
Pattern {
    public BlockType getBlockType();

    @Deprecated
    public B withPropertyId(int var1);

    @Deprecated
    public int getInternalId();

    @Deprecated
    public int getOrdinal();

    @Deprecated
    public char getOrdinalChar();

    public BlockMaterial getMaterial();

    @Deprecated
    public int getInternalBlockTypeId();

    @Deprecated
    public int getInternalPropertiesId();

    public <V> B with(Property<V> var1, V var2);

    public <V> V getState(Property<V> var1);

    public <V> B with(PropertyKey var1, V var2);

    public <V> V getState(PropertyKey var1);

    public Map<Property<?>, Object> getStates();

    public boolean equalsFuzzy(BlockStateHolder<?> var1);

    public BlockState toImmutableState();

    public BaseBlock toBaseBlock();

    @Deprecated
    default public BaseBlock toBaseBlock(CompoundTag compoundTag) {
        return this.toBaseBlock(compoundTag == null ? null : LazyReference.from(compoundTag::asBinaryTag));
    }

    @NonAbstractForCompatibility(delegateName="toBaseBlock", delegateParams={CompoundTag.class})
    default public BaseBlock toBaseBlock(LazyReference<CompoundBinaryTag> compoundTag) {
        DeprecationUtil.checkDelegatingOverride(this.getClass());
        return this.toBaseBlock(compoundTag == null ? null : new CompoundTag(compoundTag.getValue()));
    }

    default public BaseBlock toBaseBlock(CompoundBinaryTag compoundTag) {
        return this.toBaseBlock(compoundTag == null ? null : LazyReference.computed(compoundTag));
    }

    @Override
    default public BaseBlock applyBlock(BlockVector3 position) {
        return this.toBaseBlock();
    }

    public void applyTileEntity(OutputExtent var1, int var2, int var3, int var4);

    default public BaseBlock toBaseBlock(ITileInput input, int x, int y, int z) {
        throw new UnsupportedOperationException("State is immutable");
    }

    default public String getAsString() {
        if (this.getStates().isEmpty()) {
            return this.getBlockType().getId();
        }
        String properties = this.getStates().entrySet().stream().map(entry -> ((Property)entry.getKey()).getName() + "=" + entry.getValue().toString().toLowerCase(Locale.ROOT)).collect(Collectors.joining(","));
        return this.getBlockType().getId() + "[" + properties + "]";
    }
}

