/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.chunk;

import com.fastasyncworldedit.core.util.NbtUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.chunk.PackedIntArrayReader;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class AnvilChunk18
implements Chunk {
    private final CompoundBinaryTag rootTag;
    private final Int2ObjectOpenHashMap<BlockState[]> blocks;
    private final int sectionCount;
    private final Supplier<CompoundBinaryTag> entityTagSupplier;
    private Int2ObjectOpenHashMap<BiomeType[]> biomes = null;
    private List<BaseEntity> entities;
    private Map<BlockVector3, CompoundBinaryTag> tileEntities;

    @Deprecated
    public AnvilChunk18(CompoundTag tag) throws DataException {
        this(tag.asBinaryTag(), () -> null);
    }

    @Deprecated
    public AnvilChunk18(CompoundTag tag, Supplier<CompoundTag> entitiesTag) throws DataException {
        this(tag.asBinaryTag(), () -> {
            CompoundTag compoundTag = (CompoundTag)entitiesTag.get();
            return compoundTag == null ? null : compoundTag.asBinaryTag();
        });
    }

    public AnvilChunk18(CompoundBinaryTag tag, Supplier<CompoundBinaryTag> entityTag) throws DataException {
        this.rootTag = tag;
        this.entityTagSupplier = entityTag;
        ListBinaryTag sections = this.rootTag.getList("sections");
        this.sectionCount = sections.size();
        this.blocks = new Int2ObjectOpenHashMap(sections.size());
        for (BinaryTag rawSectionTag : sections) {
            CompoundBinaryTag blockStatesTag;
            ListBinaryTag paletteEntries;
            int paletteSize;
            if (!(rawSectionTag instanceof CompoundBinaryTag)) continue;
            CompoundBinaryTag sectionTag = (CompoundBinaryTag)rawSectionTag;
            int y = NbtUtils.getInt(sectionTag, "Y");
            BinaryTag rawBlockStatesTag = sectionTag.get("block_states");
            if (!(rawBlockStatesTag instanceof CompoundBinaryTag) || (paletteSize = (paletteEntries = (blockStatesTag = (CompoundBinaryTag)rawBlockStatesTag).getList("palette")).size()) == 0) continue;
            BlockState[] palette = new BlockState[paletteSize];
            for (int paletteEntryId = 0; paletteEntryId < paletteSize; ++paletteEntryId) {
                CompoundBinaryTag paletteEntry = (CompoundBinaryTag)paletteEntries.get(paletteEntryId);
                BlockType type = BlockTypes.get(paletteEntry.getString("Name"));
                if (type == null) {
                    throw new InvalidFormatException("Invalid block type: " + paletteEntry.getString("Name"));
                }
                BlockState blockState = type.getDefaultState();
                BinaryTag propertiesTag = paletteEntry.get("Properties");
                if (propertiesTag instanceof CompoundBinaryTag) {
                    CompoundBinaryTag properties = (CompoundBinaryTag)propertiesTag;
                    for (Property<?> property : blockState.getStates().keySet()) {
                        String value = properties.getString(property.getName());
                        if (value.isEmpty()) continue;
                        try {
                            blockState = this.getBlockStateWith(blockState, property, value);
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidFormatException("Invalid block state for " + blockState.getBlockType().getId() + ", " + property.getName() + ": " + value);
                        }
                    }
                }
                palette[paletteEntryId] = blockState;
            }
            if (paletteSize == 1) {
                this.blocks.put(y, (Object)palette);
                continue;
            }
            long[] blockStatesSerialized = blockStatesTag.getLongArray("data");
            BlockState[] chunkSectionBlocks = new BlockState[4096];
            this.blocks.put(y, (Object)chunkSectionBlocks);
            this.readBlockStates(palette, blockStatesSerialized, chunkSectionBlocks);
        }
    }

    protected void readBlockStates(BlockState[] palette, long[] blockStatesSerialized, BlockState[] chunkSectionBlocks) throws InvalidFormatException {
        PackedIntArrayReader reader = new PackedIntArrayReader(blockStatesSerialized);
        for (int blockPos = 0; blockPos < chunkSectionBlocks.length; ++blockPos) {
            int index = reader.get(blockPos);
            if (index >= palette.length) {
                throw new InvalidFormatException("Invalid block state table entry: " + index);
            }
            chunkSectionBlocks[blockPos] = palette[index];
        }
    }

    private <T> BlockState getBlockStateWith(BlockState source, Property<T> property, String value) {
        return source.with(property, (Object)property.getValueFor(value));
    }

    private void populateTileEntities() throws DataException {
        this.tileEntities = new HashMap<BlockVector3, CompoundBinaryTag>();
        BinaryTag binaryTag = this.rootTag.get("block_entities");
        if (!(binaryTag instanceof ListBinaryTag)) {
            return;
        }
        ListBinaryTag tags = (ListBinaryTag)binaryTag;
        for (BinaryTag tag : tags) {
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new InvalidFormatException("CompoundTag expected in block_entities");
            }
            CompoundBinaryTag t = (CompoundBinaryTag)tag;
            int x = t.getInt("x");
            int y = t.getInt("y");
            int z = t.getInt("z");
            BlockVector3 vec = BlockVector3.at(x, y, z);
            this.tileEntities.put(vec, t);
        }
    }

    @Nullable
    private CompoundBinaryTag getBlockTileEntity(BlockVector3 position) throws DataException {
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        return this.tileEntities.get(position);
    }

    @Override
    public BaseBlock getBlock(BlockVector3 position) throws DataException {
        int x = position.getX() & 0xF;
        int y = position.getY();
        int z = position.getZ() & 0xF;
        int section = y >> 4;
        int yIndex = y & 0xF;
        BlockState[] sectionBlocks = (BlockState[])this.blocks.get(section);
        if (sectionBlocks == null) {
            return BlockTypes.AIR.getDefaultState().toBaseBlock();
        }
        BlockState state = sectionBlocks[sectionBlocks.length == 1 ? 0 : yIndex << 8 | z << 4 | x];
        CompoundBinaryTag tileEntity = this.getBlockTileEntity(position);
        if (tileEntity != null) {
            return state.toBaseBlock(tileEntity);
        }
        return state.toBaseBlock();
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) throws DataException {
        if (this.biomes == null) {
            this.populateBiomes();
        }
        int x = (position.getX() & 0xF) >> 2;
        int y = (position.getY() & 0xF) >> 2;
        int z = (position.getZ() & 0xF) >> 2;
        int section = position.getY() >> 4;
        BiomeType[] sectionBiomes = (BiomeType[])this.biomes.get(section);
        if (sectionBiomes.length == 1) {
            return sectionBiomes[0];
        }
        return ((BiomeType[])this.biomes.get(section))[y << 4 | z << 2 | x];
    }

    private void populateBiomes() throws DataException {
        this.biomes = new Int2ObjectOpenHashMap(this.sectionCount);
        ListBinaryTag sections = this.rootTag.getList("sections");
        for (BinaryTag rawSectionTag : sections) {
            CompoundBinaryTag biomeTypesTag;
            ListBinaryTag paletteEntries;
            int paletteSize;
            if (!(rawSectionTag instanceof CompoundBinaryTag)) continue;
            CompoundBinaryTag sectionTag = (CompoundBinaryTag)rawSectionTag;
            int y = NbtUtils.getInt(sectionTag, "Y");
            BinaryTag rawBlockStatesTag = sectionTag.get("biomes");
            if (!(rawBlockStatesTag instanceof CompoundBinaryTag) || (paletteSize = (paletteEntries = (biomeTypesTag = (CompoundBinaryTag)rawBlockStatesTag).getList("palette")).size()) == 0) continue;
            BiomeType[] palette = new BiomeType[paletteSize];
            for (int paletteEntryId = 0; paletteEntryId < paletteSize; ++paletteEntryId) {
                String paletteEntry = paletteEntries.getString(paletteEntryId);
                BiomeType type = BiomeType.REGISTRY.get(paletteEntry);
                if (type == null) {
                    throw new InvalidFormatException("Invalid biome type: " + paletteEntry);
                }
                palette[paletteEntryId] = type;
            }
            if (paletteSize == 1) {
                this.biomes.put(y, (Object)palette);
                continue;
            }
            long[] biomesSerialized = biomeTypesTag.getLongArray("data");
            if (biomesSerialized.length == 0) {
                throw new InvalidFormatException("Biome data not present.");
            }
            BiomeType[] chunkSectionBiomes = new BiomeType[64];
            this.biomes.put(y, (Object)chunkSectionBiomes);
            this.readBiomes(palette, biomesSerialized, chunkSectionBiomes);
        }
    }

    protected void readBiomes(BiomeType[] palette, long[] biomesSerialized, BiomeType[] chunkSectionBiomes) throws InvalidFormatException {
        PackedIntArrayReader reader = new PackedIntArrayReader(biomesSerialized, 64);
        for (int biomePos = 0; biomePos < chunkSectionBiomes.length; ++biomePos) {
            int index = reader.get(biomePos);
            if (index >= palette.length) {
                throw new InvalidFormatException("Invalid biome table entry: " + index);
            }
            chunkSectionBiomes[biomePos] = palette[index];
        }
    }

    @Override
    public List<BaseEntity> getEntities() throws DataException {
        if (this.entities == null) {
            this.populateEntities();
        }
        return this.entities;
    }

    private void populateEntities() throws DataException {
        CompoundBinaryTag entityTag;
        this.entities = new ArrayList<BaseEntity>();
        if (this.entityTagSupplier == null || (entityTag = this.entityTagSupplier.get()) == null) {
            return;
        }
        ListBinaryTag tags = (ListBinaryTag)NbtUtils.getChildTag(entityTag, "Entities", BinaryTagTypes.LIST);
        for (BinaryTag tag : tags) {
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new InvalidFormatException("CompoundTag expected in Entities");
            }
            CompoundBinaryTag t = (CompoundBinaryTag)tag;
            this.entities.add(new BaseEntity(EntityTypes.get(t.getString("id")), LazyReference.computed(t)));
        }
    }
}

