/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.dataformat.avro.AvroFactory;
import com.fasterxml.jackson.dataformat.avro.AvroGenerator;
import com.fasterxml.jackson.dataformat.avro.AvroParser;

public class AvroFactoryBuilder
extends TSFBuilder<AvroFactory, AvroFactoryBuilder> {
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;
    protected boolean _useApacheLibDecoder;

    protected AvroFactoryBuilder() {
        this(false);
    }

    protected AvroFactoryBuilder(boolean useApacheDecoder) {
        this._formatParserFeatures = AvroFactory.DEFAULT_AVRO_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = AvroFactory.DEFAULT_AVRO_GENERATOR_FEATURE_FLAGS;
        this._useApacheLibDecoder = useApacheDecoder;
        this._streamWriteFeatures &= ~JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT.getMask();
    }

    public AvroFactoryBuilder(AvroFactory base) {
        super((JsonFactory)base);
        this._formatParserFeatures = base._avroParserFeatures;
        this._formatGeneratorFeatures = base._avroGeneratorFeatures;
    }

    public AvroFactory build() {
        return new AvroFactory(this);
    }

    public int formatParserFeaturesMask() {
        return this._formatParserFeatures;
    }

    public int formatGeneratorFeaturesMask() {
        return this._formatGeneratorFeatures;
    }

    public boolean useApacheLibDecoder() {
        return this._useApacheLibDecoder;
    }

    public AvroFactoryBuilder enable(AvroParser.Feature f) {
        this._formatParserFeatures |= f.getMask();
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder enable(AvroParser.Feature first, AvroParser.Feature ... other) {
        this._formatParserFeatures |= first.getMask();
        for (AvroParser.Feature f : other) {
            this._formatParserFeatures |= f.getMask();
        }
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder disable(AvroParser.Feature f) {
        this._formatParserFeatures &= ~f.getMask();
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder disable(AvroParser.Feature first, AvroParser.Feature ... other) {
        this._formatParserFeatures &= ~first.getMask();
        for (AvroParser.Feature f : other) {
            this._formatParserFeatures &= ~f.getMask();
        }
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder configure(AvroParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public AvroFactoryBuilder enable(AvroGenerator.Feature f) {
        this._formatGeneratorFeatures |= f.getMask();
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder enable(AvroGenerator.Feature first, AvroGenerator.Feature ... other) {
        this._formatGeneratorFeatures |= first.getMask();
        for (AvroGenerator.Feature f : other) {
            this._formatGeneratorFeatures |= f.getMask();
        }
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder disable(AvroGenerator.Feature f) {
        this._formatGeneratorFeatures &= ~f.getMask();
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder disable(AvroGenerator.Feature first, AvroGenerator.Feature ... other) {
        this._formatGeneratorFeatures &= ~first.getMask();
        for (AvroGenerator.Feature f : other) {
            this._formatGeneratorFeatures &= ~f.getMask();
        }
        return (AvroFactoryBuilder)this._this();
    }

    public AvroFactoryBuilder configure(AvroGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }
}

