/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.FormatSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class CsvSchema
implements FormatSchema,
Iterable<Column> {
    protected static final Column[] NO_COLUMNS = new Column[0];
    public static final char DEFAULT_COLUMN_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final int DEFAULT_ESCAPE_CHAR = -1;
    public static final char[] DEFAULT_LINEFEED = "\n".toCharArray();
    public static final boolean DEFAULT_USE_HEADER = false;
    public static final boolean DEFAULT_SKIP_FIRST_DATA_ROW = false;
    protected final Column[] _columns;
    protected final Map<String, Column> _columnsByName;
    protected final boolean _useHeader;
    protected final boolean _skipFirstDataRow;
    protected final char _columnSeparator;
    protected final int _quoteChar;
    protected final int _escapeChar;
    protected final char[] _lineSeparator;

    public CsvSchema(Column[] columns, boolean useHeader, boolean skipFirstDataRow, char columnSeparator, int quoteChar, int escapeChar, char[] lineSeparator) {
        if (columns == null) {
            columns = NO_COLUMNS;
        }
        this._columns = columns;
        this._useHeader = useHeader;
        this._skipFirstDataRow = skipFirstDataRow;
        this._columnSeparator = columnSeparator;
        this._quoteChar = quoteChar;
        this._escapeChar = escapeChar;
        this._lineSeparator = lineSeparator;
        if (this._columns.length == 0) {
            this._columnsByName = Collections.emptyMap();
        } else {
            this._columnsByName = new HashMap<String, Column>(4 + this._columns.length);
            for (Column c : this._columns) {
                this._columnsByName.put(c.getName(), c);
            }
        }
    }

    protected CsvSchema(Column[] columns, boolean useHeader, boolean skipFirstDataRow, char columnSeparator, int quoteChar, int escapeChar, char[] lineSeparator, Map<String, Column> columnsByName) {
        this._columns = columns;
        this._useHeader = useHeader;
        this._skipFirstDataRow = skipFirstDataRow;
        this._columnSeparator = columnSeparator;
        this._quoteChar = quoteChar;
        this._escapeChar = escapeChar;
        this._lineSeparator = lineSeparator;
        this._columnsByName = columnsByName;
    }

    protected CsvSchema(CsvSchema base, Column[] columns) {
        this._columns = columns;
        this._useHeader = base._useHeader;
        this._skipFirstDataRow = base._skipFirstDataRow;
        this._columnSeparator = base._columnSeparator;
        this._quoteChar = base._quoteChar;
        this._escapeChar = base._escapeChar;
        this._lineSeparator = base._lineSeparator;
        this._columnsByName = base._columnsByName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CsvSchema emptySchema() {
        return CsvSchema.builder().build();
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public CsvSchema withUseHeader(boolean state) {
        return this._useHeader == state ? this : new CsvSchema(this._columns, state, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withHeader() {
        return this.withUseHeader(true);
    }

    public CsvSchema withoutHeader() {
        return this.withUseHeader(false);
    }

    public CsvSchema withSkipFirstDataRow(boolean state) {
        return this._skipFirstDataRow == state ? this : new CsvSchema(this._columns, this._useHeader, state, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withColumnSeparator(char sep) {
        return this._columnSeparator == sep ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, sep, this._quoteChar, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withQuoteChar(char c) {
        return this._quoteChar == c ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, c, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withoutQuoteChar() {
        return this._quoteChar == -1 ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, -1, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withEscapeChar(char c) {
        return this._escapeChar == c ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, c, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withoutEscapeChar() {
        return this._escapeChar == -1 ? this : new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, -1, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema withLineSeparator(String sep) {
        return new CsvSchema(this._columns, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, this._escapeChar, sep.toCharArray(), this._columnsByName);
    }

    public CsvSchema withoutColumns() {
        return new CsvSchema(NO_COLUMNS, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator, this._columnsByName);
    }

    public CsvSchema sortedBy(String ... columnNames) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String colName : columnNames) {
            Column col = this._columnsByName.get(colName);
            if (col == null) continue;
            map.put(col.getName(), col);
        }
        for (Column col : this._columns) {
            map.put(col.getName(), col);
        }
        return new CsvSchema(this, map.values().toArray(new Column[map.size()]));
    }

    public CsvSchema sortedBy(Comparator<String> cmp) {
        TreeMap<String, Column> map = new TreeMap<String, Column>(cmp);
        for (Column col : this._columns) {
            map.put(col.getName(), col);
        }
        return new CsvSchema(this, map.values().toArray(new Column[map.size()]));
    }

    public String getSchemaType() {
        return "CSV";
    }

    public boolean useHeader() {
        return this._useHeader;
    }

    public boolean skipFirstDataRow() {
        return this._skipFirstDataRow;
    }

    public char getColumnSeparator() {
        return this._columnSeparator;
    }

    public int getQuoteChar() {
        return this._quoteChar;
    }

    public int getEscapeChar() {
        return this._escapeChar;
    }

    public char[] getLineSeparator() {
        return this._lineSeparator;
    }

    public boolean usesQuoteChar() {
        return this._quoteChar >= 0;
    }

    public boolean usesEscapeChar() {
        return this._escapeChar >= 0;
    }

    @Override
    public Iterator<Column> iterator() {
        return Arrays.asList(this._columns).iterator();
    }

    public int size() {
        return this._columns.length;
    }

    public Column column(int index) {
        return this._columns[index];
    }

    public Column column(String name) {
        return this._columnsByName.get(name);
    }

    public String getColumnDesc() {
        StringBuilder sb = new StringBuilder(100);
        for (Column col : this._columns) {
            if (sb.length() == 0) {
                sb.append('[');
            } else {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(col.getName());
            sb.append('\"');
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(150);
        sb.append("[CsvSchema: ").append("columns=");
        boolean first = true;
        for (Column col : this._columns) {
            if (first) {
                first = false;
                sb.append('[');
            } else {
                sb.append(',');
            }
            sb.append('\"');
            sb.append(col.getName());
            sb.append("\"/");
            sb.append((Object)col.getType());
        }
        sb.append(']');
        sb.append(']');
        return sb.toString();
    }

    public static class Builder {
        protected final ArrayList<Column> _columns = new ArrayList();
        protected boolean _useHeader = false;
        protected boolean _skipFirstDataRow = false;
        protected char _columnSeparator = (char)44;
        protected int _quoteChar = 34;
        protected int _escapeChar = -1;
        protected char[] _lineSeparator = DEFAULT_LINEFEED;

        public Builder() {
        }

        public Builder(CsvSchema src) {
            for (Column col : src._columns) {
                this._columns.add(col);
            }
            this._useHeader = src._useHeader;
            this._columnSeparator = src._columnSeparator;
            this._quoteChar = src._quoteChar;
            this._escapeChar = src._escapeChar;
            this._lineSeparator = src._lineSeparator;
            this._skipFirstDataRow = src._skipFirstDataRow;
        }

        public Builder addColumn(String name) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name));
        }

        public Builder addColumn(String name, ColumnType type) {
            int index = this._columns.size();
            return this.addColumn(new Column(index, name, type));
        }

        public Builder addColumn(Column c) {
            this._columns.add(c);
            return this;
        }

        public void replaceColumn(int index, Column c) {
            this._checkIndex(index);
            this._columns.set(index, c);
        }

        public void renameColumn(int index, String newName) {
            this._checkIndex(index);
            this._columns.set(index, this._columns.get(index).withName(newName));
        }

        public void setColumnType(int index, ColumnType type) {
            this._checkIndex(index);
            this._columns.set(index, this._columns.get(index).withType(type));
        }

        public Builder clearColumns() {
            this._columns.clear();
            return this;
        }

        public int size() {
            return this._columns.size();
        }

        public Iterator<Column> getColumns() {
            return this._columns.iterator();
        }

        public Builder setUseHeader(boolean b) {
            this._useHeader = b;
            return this;
        }

        public Builder setSkipFirstDataRow(boolean b) {
            this._skipFirstDataRow = b;
            return this;
        }

        public Builder setColumnSeparator(char c) {
            this._columnSeparator = c;
            return this;
        }

        public Builder setQuoteChar(char c) {
            this._quoteChar = c;
            return this;
        }

        public Builder disableQuoteChar() {
            this._quoteChar = -1;
            return this;
        }

        public Builder setEscapeChar(char c) {
            this._escapeChar = c;
            return this;
        }

        public Builder disableEscapeChar() {
            this._escapeChar = -1;
            return this;
        }

        public Builder setLineSeparator(String lf) {
            this._lineSeparator = lf.toCharArray();
            return this;
        }

        public Builder setLineSeparator(char lf) {
            this._lineSeparator = new char[]{lf};
            return this;
        }

        public CsvSchema build() {
            Column[] cols = this._columns.toArray(new Column[this._columns.size()]);
            return new CsvSchema(cols, this._useHeader, this._skipFirstDataRow, this._columnSeparator, this._quoteChar, this._escapeChar, this._lineSeparator);
        }

        protected void _checkIndex(int index) {
            if (index < 0 || index >= this._columns.size()) {
                throw new IllegalArgumentException("Illegal index " + index + "; only got " + this._columns.size() + " columns");
            }
        }
    }

    public static class Column {
        private final String _name;
        private final int _index;
        private final ColumnType _type;

        public Column(int index, String name) {
            this(index, name, ColumnType.STRING);
        }

        public Column(int index, String name, ColumnType type) {
            this._index = index;
            this._name = name;
            this._type = type;
        }

        public Column withName(String newName) {
            return new Column(this._index, newName, this._type);
        }

        public Column withType(ColumnType newType) {
            return new Column(this._index, this._name, newType);
        }

        public int getIndex() {
            return this._index;
        }

        public String getName() {
            return this._name;
        }

        public ColumnType getType() {
            return this._type;
        }
    }

    public static enum ColumnType {
        STRING,
        STRING_OR_LITERAL,
        NUMBER,
        NUMBER_OR_STRING;

    }
}

