/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.dataformat.csv.impl.CsvWriter;
import java.io.IOException;

public abstract class BufferedValue {
    protected BufferedValue() {
    }

    public abstract void write(CsvWriter var1) throws IOException;

    public static BufferedValue buffered(String v) {
        return new TextValue(v);
    }

    public static BufferedValue buffered(int v) {
        return new IntValue(v);
    }

    public static BufferedValue buffered(long v) {
        return new LongValue(v);
    }

    public static BufferedValue buffered(double v) {
        return new DoubleValue(v);
    }

    public static BufferedValue buffered(boolean v) {
        return new BooleanValue(v);
    }

    protected static final class BooleanValue
    extends BufferedValue {
        private final boolean _value;

        public BooleanValue(boolean v) {
            this._value = v;
        }

        @Override
        public void write(CsvWriter w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class DoubleValue
    extends BufferedValue {
        private final double _value;

        public DoubleValue(double v) {
            this._value = v;
        }

        @Override
        public void write(CsvWriter w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class LongValue
    extends BufferedValue {
        private final long _value;

        public LongValue(long v) {
            this._value = v;
        }

        @Override
        public void write(CsvWriter w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class IntValue
    extends BufferedValue {
        private final int _value;

        public IntValue(int v) {
            this._value = v;
        }

        @Override
        public void write(CsvWriter w) throws IOException {
            w.appendValue(this._value);
        }
    }

    protected static final class TextValue
    extends BufferedValue {
        private final String _value;

        public TextValue(String v) {
            this._value = v;
        }

        @Override
        public void write(CsvWriter w) throws IOException {
            w.appendValue(this._value);
        }
    }
}

