/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv.impl;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonReadContext;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.impl.NumberInput;
import com.fasterxml.jackson.dataformat.csv.impl.TextBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CsvReader {
    private static final int INT_SPACE = 32;
    private static final int INT_CR = 13;
    private static final int INT_LF = 10;
    protected final CsvParser _owner;
    protected final IOContext _ioContext;
    protected Reader _inputSource;
    protected boolean _bufferRecyclable;
    protected boolean _autoCloseInput;
    protected boolean _trimSpaces;
    protected int _maxSpecialChar;
    protected int _separatorChar;
    protected int _quoteChar;
    protected int _escapeChar;
    protected final TextBuffer _textBuffer;
    protected char[] _inputBuffer;
    protected int _inputPtr = 0;
    protected int _inputEnd = 0;
    protected int _pendingLF = 0;
    protected boolean _closed;
    protected long _currInputProcessed = 0L;
    protected int _currInputRow = 1;
    protected int _currInputRowStart = 0;
    protected long _tokenInputTotal = 0L;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol = 0;
    protected static final int NR_UNKNOWN = 0;
    protected static final int NR_INT = 1;
    protected static final int NR_LONG = 2;
    protected static final int NR_BIGINT = 4;
    protected static final int NR_DOUBLE = 8;
    protected static final int NR_BIGDECIMAL = 16;
    static final BigDecimal BD_MIN_LONG = new BigDecimal(Long.MIN_VALUE);
    static final BigDecimal BD_MAX_LONG = new BigDecimal(Long.MAX_VALUE);
    static final BigDecimal BD_MIN_INT = new BigDecimal(Long.MIN_VALUE);
    static final BigDecimal BD_MAX_INT = new BigDecimal(Long.MAX_VALUE);
    static final long MIN_INT_L = Integer.MIN_VALUE;
    static final long MAX_INT_L = Integer.MAX_VALUE;
    static final double MIN_LONG_D = -9.223372036854776E18;
    static final double MAX_LONG_D = 9.223372036854776E18;
    static final double MIN_INT_D = -2.147483648E9;
    static final double MAX_INT_D = 2.147483647E9;
    protected static final int INT_0 = 48;
    protected static final int INT_1 = 49;
    protected static final int INT_2 = 50;
    protected static final int INT_3 = 51;
    protected static final int INT_4 = 52;
    protected static final int INT_5 = 53;
    protected static final int INT_6 = 54;
    protected static final int INT_7 = 55;
    protected static final int INT_8 = 56;
    protected static final int INT_9 = 57;
    protected static final int INT_MINUS = 45;
    protected static final int INT_PLUS = 43;
    protected static final int INT_DECIMAL_POINT = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected static final char CHAR_NULL = '\u0000';
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;
    protected JsonToken _currToken = null;

    public CsvReader(CsvParser owner, IOContext ctxt, Reader r, CsvSchema schema, TextBuffer textBuffer, boolean autoCloseInput, boolean trimSpaces) {
        this._owner = owner;
        this._ioContext = ctxt;
        this._inputSource = r;
        this._textBuffer = textBuffer;
        this._autoCloseInput = autoCloseInput;
        this._trimSpaces = trimSpaces;
        this._inputBuffer = ctxt.allocTokenBuffer();
        this._bufferRecyclable = true;
        this._inputSource = r;
        this._tokenInputRow = -1;
        this._tokenInputCol = -1;
        this.setSchema(schema);
    }

    public void setSchema(CsvSchema schema) {
        this._separatorChar = schema.getColumnSeparator();
        this._quoteChar = schema.getQuoteChar();
        this._escapeChar = schema.getEscapeChar();
        int max = Math.max(this._separatorChar, this._quoteChar);
        max = Math.max(max, this._escapeChar);
        max = Math.max(max, 13);
        this._maxSpecialChar = max = Math.max(max, 10);
    }

    public Object getInputSource() {
        return this._inputSource;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void close() throws IOException {
        this._pendingLF = 1;
        if (!this._closed) {
            this._closed = true;
            try {
                this._closeInput();
            }
            finally {
                this.releaseBuffers();
            }
        }
    }

    public int releaseBuffered(Writer out) throws IOException {
        int count = this._inputEnd - this._inputPtr;
        if (count < 1) {
            return 0;
        }
        int origPtr = this._inputPtr;
        out.write(this._inputBuffer, origPtr, count);
        return count;
    }

    public JsonReadContext childArrayContext(JsonReadContext context) {
        int col = this._inputPtr - this._currInputRowStart + 1;
        return context.createChildArrayContext(this._currInputRow, col);
    }

    public JsonReadContext childObjectContext(JsonReadContext context) {
        int col = this._inputPtr - this._currInputRowStart + 1;
        return context.createChildObjectContext(this._currInputRow, col);
    }

    public JsonLocation getTokenLocation() {
        return new JsonLocation((Object)this._inputSource, this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    public JsonLocation getCurrentLocation() {
        int ptr = this._inputPtr;
        if (this._pendingLF > 1) {
            --ptr;
        }
        int col = ptr - this._currInputRowStart + 1;
        return new JsonLocation((Object)this._inputSource, this._currInputProcessed + (long)ptr - 1L, this._currInputRow, col);
    }

    protected final long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    protected final int getTokenLineNr() {
        return this._tokenInputRow;
    }

    protected final int getTokenColumnNr() {
        int col = this._tokenInputCol;
        return col < 0 ? col : col + 1;
    }

    protected void releaseBuffers() throws IOException {
        this._textBuffer.releaseBuffers();
        char[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._ioContext.releaseTokenBuffer(buf);
        }
    }

    protected void _closeInput() throws IOException {
        this._pendingLF = 1;
        if (this._inputSource != null) {
            if (this._autoCloseInput || this._ioContext.isResourceManaged()) {
                this._inputSource.close();
            }
            this._inputSource = null;
        }
    }

    protected final boolean loadMore() throws IOException {
        this._currInputProcessed += (long)this._inputEnd;
        this._currInputRowStart -= this._inputEnd;
        if (this._inputSource != null) {
            int count;
            this._inputEnd = count = this._inputSource.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (count > 0) {
                this._inputPtr = 0;
                return true;
            }
            this._closeInput();
            if (count == 0) {
                throw new IOException("InputStream.read() returned 0 characters when trying to read " + this._inputBuffer.length + " bytes");
            }
        }
        return false;
    }

    public String getText() {
        return this._textBuffer.contentsAsString();
    }

    public boolean hasMoreInput() throws IOException {
        if (this._inputPtr < this._inputEnd) {
            return true;
        }
        return this.loadMore();
    }

    public boolean startNewLine() throws IOException {
        if (this._pendingLF != 0) {
            if (this._inputSource == null) {
                return false;
            }
            this._handleLF();
        }
        return this._inputPtr < this._inputEnd || this.loadMore();
    }

    public boolean skipLine() throws IOException {
        if (this._pendingLF != 0) {
            if (this._inputSource == null) {
                return false;
            }
            this._handleLF();
        }
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            int c;
            if ((c = this._inputBuffer[this._inputPtr++]) != 13 && c != 10) continue;
            this._pendingLF = c;
            this._handleLF();
            return true;
        }
        return false;
    }

    public String nextString() throws IOException {
        this._numTypesValid = 0;
        if (this._pendingLF > 0) {
            if (this._inputSource != null) {
                this._handleLF();
            }
            return null;
        }
        this._tokenInputTotal = this._currInputProcessed + (long)this._inputPtr - 1L;
        this._tokenInputRow = this._currInputRow;
        this._tokenInputCol = this._inputPtr - this._currInputRowStart - 1;
        int i = this._trimSpaces ? this._skipLeadingSpace() : this._nextChar();
        if (i < 0) {
            return "";
        }
        if (i == 13 || i == 10) {
            this._pendingLF = i;
            return "";
        }
        if (i == this._quoteChar) {
            return this._nextQuotedString();
        }
        if (i == this._separatorChar) {
            this._textBuffer.resetWithString("");
            return "";
        }
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        outBuf[0] = (char)i;
        int outPtr = 1;
        int ptr = this._inputPtr;
        if (ptr >= this._inputEnd) {
            if (!this.loadMore()) {
                return this._textBuffer.finishAndReturn(outPtr, this._trimSpaces);
            }
            ptr = this._inputPtr;
        }
        int max = Math.min(this._inputEnd - ptr, outBuf.length - outPtr);
        int end = ptr + max;
        char[] inputBuffer = this._inputBuffer;
        while (ptr < end) {
            int c;
            if ((c = inputBuffer[ptr++]) <= this._maxSpecialChar) {
                if (c == this._separatorChar) {
                    this._inputPtr = ptr;
                    return this._textBuffer.finishAndReturn(outPtr, this._trimSpaces);
                }
                if (c == 13 || c == 10) {
                    this._pendingLF = c;
                    this._inputPtr = ptr;
                    return this._textBuffer.finishAndReturn(outPtr, this._trimSpaces);
                }
                if (c == this._escapeChar) {
                    --ptr;
                    break;
                }
            }
            outBuf[outPtr++] = c;
        }
        this._inputPtr = ptr;
        return this._nextUnquotedString(outBuf, outPtr);
    }

    public JsonToken nextStringOrLiteral() throws IOException {
        this._numTypesValid = 0;
        String value = this.nextString();
        if (value == null) {
            return null;
        }
        return JsonToken.VALUE_STRING;
    }

    public JsonToken nextNumber() throws IOException {
        this._numTypesValid = 0;
        String value = this.nextString();
        if (value == null) {
            return null;
        }
        return JsonToken.VALUE_STRING;
    }

    public JsonToken nextNumberOrString() throws IOException {
        this._numTypesValid = 0;
        String value = this.nextString();
        if (value == null) {
            return null;
        }
        return JsonToken.VALUE_STRING;
    }

    protected String _nextUnquotedString(char[] outBuf, int outPtr) throws IOException {
        char[] inputBuffer = this._inputBuffer;
        block0: while (true) {
            int ptr;
            if ((ptr = this._inputPtr) >= this._inputEnd) {
                if (!this.loadMore()) {
                    this._inputPtr = ptr;
                    break;
                }
                ptr = this._inputPtr;
            }
            if (outPtr >= outBuf.length) {
                outBuf = this._textBuffer.finishCurrentSegment();
                outPtr = 0;
            }
            int max = Math.min(this._inputEnd, ptr + (outBuf.length - outPtr));
            while (ptr < max) {
                int c;
                if ((c = inputBuffer[ptr++]) <= this._maxSpecialChar) {
                    if (c == this._separatorChar) {
                        this._inputPtr = ptr;
                        break block0;
                    }
                    if (c == 13 || c == 10) {
                        this._inputPtr = ptr;
                        this._pendingLF = c;
                        break block0;
                    }
                    if (c == this._escapeChar) {
                        this._inputPtr = ptr;
                        outBuf[outPtr++] = this._unescape();
                        continue block0;
                    }
                }
                outBuf[outPtr++] = (char)c;
            }
            this._inputPtr = ptr;
        }
        return this._textBuffer.finishAndReturn(outPtr, this._trimSpaces);
    }

    protected String _nextQuotedString() throws IOException {
        int ch;
        char[] outBuf = this._textBuffer.emptyAndGetCurrentSegment();
        int outPtr = 0;
        char[] inputBuffer = this._inputBuffer;
        boolean checkLF = false;
        block0: while (true) {
            int ptr;
            block12: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    if (!this.loadMore()) {
                        this._owner._reportCsvError("Missing closing quote for value");
                    }
                    ptr = this._inputPtr;
                    if (checkLF && inputBuffer[ptr] == '\n') {
                        --this._currInputRow;
                    }
                }
                if (checkLF) {
                    // empty if block
                }
                if (outPtr >= outBuf.length) {
                    outBuf = this._textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                int max = Math.min(this._inputEnd, ptr + (outBuf.length - outPtr));
                do {
                    char c;
                    block13: {
                        block14: {
                            block15: {
                                if ((c = inputBuffer[ptr++]) > this._maxSpecialChar) break block13;
                                if (c == this._quoteChar) break block12;
                                if (c != '\r') break block14;
                                if (ptr < max) break block15;
                                checkLF = true;
                                ++this._currInputRow;
                                this._currInputRowStart = ptr;
                                break block13;
                            }
                            if (inputBuffer[ptr] == '\n') break block13;
                            ++this._currInputRow;
                            this._currInputRowStart = ptr;
                            break block13;
                        }
                        if (c == '\n') {
                            ++this._currInputRow;
                            this._currInputRowStart = ptr;
                        } else if (c == this._escapeChar) {
                            this._inputPtr = ptr;
                            c = this._unescape();
                            outBuf[outPtr++] = c;
                            continue block0;
                        }
                    }
                    outBuf[outPtr++] = c;
                } while (ptr < max);
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            if (this._inputPtr >= this._inputEnd && !this.loadMore() || this._inputBuffer[this._inputPtr] != this._quoteChar) break;
            outBuf[outPtr++] = (char)this._quoteChar;
            ++this._inputPtr;
        }
        String result = this._textBuffer.finishAndReturn(outPtr, false);
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && (ch = this._inputBuffer[this._inputPtr++]) != this._separatorChar) {
            if (ch <= 32) {
                if (ch != 13 && ch != 10) continue;
                this._pendingLF = ch;
                break;
            }
            this._owner._reportUnexpectedCsvChar(ch, "Expected separator (" + CsvReader._getCharDesc(this._quoteChar) + ") or end-of-line");
        }
        return result;
    }

    protected final void _handleLF() throws IOException {
        if (this._pendingLF == 13 && (this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == '\n') {
            ++this._inputPtr;
        }
        this._pendingLF = 0;
        ++this._currInputRow;
        this._currInputRowStart = this._inputPtr;
    }

    protected char _unescape() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._reportError("Unexpected EOF in escaped character");
        }
        char c = this._inputBuffer[this._inputPtr++];
        switch (c) {
            case '0': {
                return '\u0000';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
        }
        return c;
    }

    protected int _nextChar() throws IOException {
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return -1;
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected int _skipLeadingSpace() throws IOException {
        while (this._inputPtr < this._inputEnd || this.loadMore()) {
            char ch;
            if ((ch = this._inputBuffer[this._inputPtr++]) > ' ') {
                return ch;
            }
            switch (ch) {
                case '\n': 
                case '\r': {
                    return ch;
                }
            }
        }
        return -1;
    }

    public Number getNumberValue() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._numberBigInt;
            }
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._numberBigDecimal;
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._numberDouble;
    }

    public JsonParser.NumberType getNumberType() throws IOException {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return JsonParser.NumberType.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return JsonParser.NumberType.LONG;
            }
            return JsonParser.NumberType.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return JsonParser.NumberType.BIG_DECIMAL;
        }
        return JsonParser.NumberType.DOUBLE;
    }

    public int getIntValue() throws IOException {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(1);
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    public long getLongValue() throws IOException {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    public BigInteger getBigIntegerValue() throws IOException {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._numberBigInt;
    }

    public float getFloatValue() throws IOException {
        double value = this.getDoubleValue();
        return (float)value;
    }

    public double getDoubleValue() throws IOException {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._numberDouble;
    }

    public BigDecimal getDecimalValue() throws IOException {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._numberBigDecimal;
    }

    protected void _parseNumericValue(int expType) throws IOException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            char[] buf = this._textBuffer.getTextBuffer();
            int offset = this._textBuffer.getTextOffset();
            int len = this._intLength;
            if (this._numberNegative) {
                ++offset;
            }
            if (len <= 9) {
                int i = NumberInput.parseInt(buf, offset, len);
                this._numberInt = this._numberNegative ? -i : i;
                this._numTypesValid = 1;
                return;
            }
            if (len <= 18) {
                long l = NumberInput.parseLong(buf, offset, len);
                if (this._numberNegative) {
                    l = -l;
                }
                if (len == 10) {
                    if (this._numberNegative) {
                        if (l >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l;
                this._numTypesValid = 2;
                return;
            }
            this._parseSlowIntValue(expType, buf, offset, len);
            return;
        }
        if (this._currToken == JsonToken.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloatValue(expType);
            return;
        }
        this._reportError("Current token (" + this._currToken + ") not numeric, can not use numeric value accessors");
    }

    private final void _parseSlowFloatValue(int expType) throws IOException {
        try {
            if (expType == 16) {
                this._numberBigDecimal = this._textBuffer.contentsAsDecimal();
                this._numTypesValid = 16;
            } else {
                this._numberDouble = this._textBuffer.contentsAsDouble();
                this._numTypesValid = 8;
            }
        }
        catch (NumberFormatException nex) {
            throw this.constructError("Malformed numeric value '" + this._textBuffer.contentsAsString() + "'", nex);
        }
    }

    private final void _parseSlowIntValue(int expType, char[] buf, int offset, int len) throws IOException {
        String numStr = this._textBuffer.contentsAsString();
        try {
            if (NumberInput.inLongRange(buf, offset, len, this._numberNegative)) {
                this._numberLong = Long.parseLong(numStr);
                this._numTypesValid = 2;
            } else {
                this._numberBigInt = new BigInteger(numStr);
                this._numTypesValid = 4;
            }
        }
        catch (NumberFormatException nex) {
            throw this.constructError("Malformed numeric value '" + numStr + "'", nex);
        }
    }

    protected void convertNumberToInt() throws IOException {
        if ((this._numTypesValid & 2) != 0) {
            int result = (int)this._numberLong;
            if ((long)result != this._numberLong) {
                this._reportError("Numeric value (" + this.getText() + ") out of range of int");
            }
            this._numberInt = result;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberInt = this._numberBigInt.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -2.147483648E9 || this._numberDouble > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_INT.compareTo(this._numberBigDecimal) > 0 || BD_MAX_INT.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = this._numberBigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() throws IOException {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberLong = this._numberBigInt.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            if (this._numberDouble < -9.223372036854776E18 || this._numberDouble > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)this._numberDouble;
        } else if ((this._numTypesValid & 0x10) != 0) {
            if (BD_MIN_LONG.compareTo(this._numberBigDecimal) > 0 || BD_MAX_LONG.compareTo(this._numberBigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = this._numberBigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._numberBigDecimal.toBigInteger();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = BigDecimal.valueOf(this._numberDouble).toBigInteger();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() throws IOException {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberBigDecimal.doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberBigInt.doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToBigDecimal() throws IOException {
        if ((this._numTypesValid & 8) != 0) {
            this._numberBigDecimal = new BigDecimal(this.getText());
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._numberBigInt);
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected void reportUnexpectedNumberChar(int ch, String comment) throws JsonParseException {
        String msg = "Unexpected character (" + CsvReader._getCharDesc(ch) + ") in numeric value";
        if (comment != null) {
            msg = msg + ": " + comment;
        }
        this._reportError(msg);
    }

    protected void reportInvalidNumber(String msg) throws JsonParseException {
        this._reportError("Invalid numeric value: " + msg);
    }

    protected void reportOverflowInt() throws IOException {
        this._reportError("Numeric value (" + this.getText() + ") out of range of int (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")");
    }

    protected void reportOverflowLong() throws IOException {
        this._reportError("Numeric value (" + this.getText() + ") out of range of long (" + Long.MIN_VALUE + " - " + Long.MAX_VALUE + ")");
    }

    protected final JsonParseException constructError(String msg, Throwable t) {
        return new JsonParseException(msg, this.getCurrentLocation(), t);
    }

    protected static final String _getCharDesc(int ch) {
        char c = (char)ch;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + ch + ")";
        }
        if (ch > 255) {
            return "'" + c + "' (code " + ch + " / 0x" + Integer.toHexString(ch) + ")";
        }
        return "'" + c + "' (code " + ch + ")";
    }

    private void _throwInternal() {
        throw new IllegalStateException("Internal error: code path should never get executed");
    }

    protected final void _reportError(String msg) throws JsonParseException {
        throw new JsonParseException(msg, this.getCurrentLocation());
    }
}

