/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.xml.ModuleVersion;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.codehaus.stax2.io.Stax2ByteArraySource;

public class XmlFactory
extends JsonFactory {
    public static final String FORMAT_NAME_XML = "XML";
    static final int DEFAULT_XML_PARSER_FEATURE_FLAGS = FromXmlParser.Feature.collectDefaults();
    static final int DEFAULT_XML_GENERATOR_FEATURE_FLAGS = ToXmlGenerator.Feature.collectDefaults();
    protected int _xmlParserFeatures = DEFAULT_XML_PARSER_FEATURE_FLAGS;
    protected int _xmlGeneratorFeatures = DEFAULT_XML_GENERATOR_FEATURE_FLAGS;
    protected XMLInputFactory _xmlInputFactory;
    protected XMLOutputFactory _xmlOutputFactory;
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    private static final byte BYTE_x = 120;
    private static final byte BYTE_m = 109;
    private static final byte BYTE_l = 108;
    private static final byte BYTE_D = 68;
    private static final byte BYTE_LT = 60;
    private static final byte BYTE_QMARK = 63;
    private static final byte BYTE_EXCL = 33;
    private static final byte BYTE_HYPHEN = 45;

    public XmlFactory() {
        this(null);
    }

    public XmlFactory(ObjectCodec oc) {
        this(oc, null, null);
    }

    public XmlFactory(XMLInputFactory xmlIn, XMLOutputFactory xmlOut) {
        this(null, xmlIn, xmlOut);
    }

    public XmlFactory(ObjectCodec oc, XMLInputFactory xmlIn, XMLOutputFactory xmlOut) {
        super(oc);
        if (xmlIn == null) {
            xmlIn = XMLInputFactory.newInstance();
        }
        if (xmlOut == null) {
            xmlOut = XMLOutputFactory.newInstance();
        }
        xmlOut.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        xmlIn.setProperty("javax.xml.stream.isCoalescing", true);
        this._xmlInputFactory = xmlIn;
        this._xmlOutputFactory = xmlOut;
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public final XmlFactory configure(FromXmlParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public XmlFactory enable(FromXmlParser.Feature f) {
        this._xmlParserFeatures |= f.getMask();
        return this;
    }

    public XmlFactory disable(FromXmlParser.Feature f) {
        this._xmlParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(FromXmlParser.Feature f) {
        return (this._xmlParserFeatures & f.getMask()) != 0;
    }

    public final XmlFactory configure(ToXmlGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public XmlFactory enable(ToXmlGenerator.Feature f) {
        this._xmlGeneratorFeatures |= f.getMask();
        return this;
    }

    public XmlFactory disable(ToXmlGenerator.Feature f) {
        this._xmlGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(ToXmlGenerator.Feature f) {
        return (this._xmlGeneratorFeatures & f.getMask()) != 0;
    }

    public void setXMLInputFactory(XMLInputFactory f) {
        this._xmlInputFactory = f;
    }

    public void setXMLOutputFactory(XMLOutputFactory f) {
        this._xmlOutputFactory = f;
    }

    public String getFormatName() {
        return FORMAT_NAME_XML;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return XmlFactory.hasXMLFormat(acc);
    }

    public ToXmlGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return new ToXmlGenerator(this._createContext(out, false), this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createGenerator(Writer out) throws IOException {
        return new ToXmlGenerator(this._createContext(out, false), this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        return new ToXmlGenerator(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return new ToXmlGenerator(this._createContext(out, false), this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createJsonGenerator(Writer out) throws IOException {
        return new ToXmlGenerator(this._createContext(out, false), this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createJsonGenerator(File f, JsonEncoding enc) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        return new ToXmlGenerator(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    protected FromXmlParser _createParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(in, ctxt);
    }

    protected FromXmlParser _createParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(r, ctxt);
    }

    protected FromXmlParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return this._createJsonParser(data, offset, len, ctxt);
    }

    protected FromXmlParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory.createXMLStreamReader(in);
            sr = this._initializeXmlReader(sr);
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(e));
        }
        return new FromXmlParser(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, sr);
    }

    protected FromXmlParser _createJsonParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory.createXMLStreamReader(r);
            sr = this._initializeXmlReader(sr);
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(e));
        }
        return new FromXmlParser(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, sr);
    }

    protected FromXmlParser _createJsonParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory.createXMLStreamReader((Source)new Stax2ByteArraySource(data, offset, len));
            sr = this._initializeXmlReader(sr);
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(e));
        }
        return new FromXmlParser(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, sr);
    }

    protected XMLStreamWriter _createXmlWriter(OutputStream out) throws IOException {
        try {
            return this._initializeXmlWriter(this._xmlOutputFactory.createXMLStreamWriter(out, "UTF-8"));
        }
        catch (XMLStreamException e) {
            return (XMLStreamWriter)StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected XMLStreamWriter _createXmlWriter(Writer w) throws IOException {
        try {
            return this._initializeXmlWriter(this._xmlOutputFactory.createXMLStreamWriter(w));
        }
        catch (XMLStreamException e) {
            return (XMLStreamWriter)StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected final XMLStreamWriter _initializeXmlWriter(XMLStreamWriter sw) throws IOException, XMLStreamException {
        sw.setDefaultNamespace("");
        return sw;
    }

    protected final XMLStreamReader _initializeXmlReader(XMLStreamReader sr) throws IOException, XMLStreamException {
        while (sr.next() != 1) {
        }
        return sr;
    }

    public static MatchStrength hasXMLFormat(InputAccessor acc) throws IOException {
        boolean maybeXmlDecl;
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b = acc.nextByte();
        if (b == -17) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = acc.nextByte();
        }
        boolean bl = maybeXmlDecl = b == 60;
        if (!maybeXmlDecl) {
            int ch = XmlFactory.skipSpace(acc, b);
            if (ch < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = (byte)ch;
            if (b != 60) {
                return MatchStrength.NO_MATCH;
            }
        }
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        b = acc.nextByte();
        if (b == 63) {
            b = acc.nextByte();
            if (b == 120) {
                if (maybeXmlDecl && acc.hasMoreBytes() && acc.nextByte() == 109 && acc.hasMoreBytes() && acc.nextByte() == 108) {
                    return MatchStrength.FULL_MATCH;
                }
                return MatchStrength.SOLID_MATCH;
            }
            if (XmlFactory.validXmlNameStartChar(acc, b)) {
                return MatchStrength.SOLID_MATCH;
            }
        } else if (b == 33) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = acc.nextByte();
            if (b == 45) {
                if (!acc.hasMoreBytes()) {
                    return MatchStrength.INCONCLUSIVE;
                }
                if (acc.nextByte() == 45) {
                    return MatchStrength.SOLID_MATCH;
                }
            } else if (b == 68) {
                return XmlFactory.tryMatch(acc, "OCTYPE", MatchStrength.SOLID_MATCH);
            }
        } else if (XmlFactory.validXmlNameStartChar(acc, b)) {
            return MatchStrength.SOLID_MATCH;
        }
        return MatchStrength.NO_MATCH;
    }

    private static final boolean validXmlNameStartChar(InputAccessor acc, byte b) throws IOException {
        int ch = b & 0xFF;
        return ch >= 65;
    }

    private static final MatchStrength tryMatch(InputAccessor acc, String matchStr, MatchStrength fullMatchStrength) throws IOException {
        int len = matchStr.length();
        for (int i = 0; i < len; ++i) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() == matchStr.charAt(i)) continue;
            return MatchStrength.NO_MATCH;
        }
        return fullMatchStrength;
    }

    private static final int skipSpace(InputAccessor acc, byte b) throws IOException {
        int ch;
        while ((ch = b & 0xFF) == 32 || ch == 13 || ch == 10 || ch == 9) {
            if (!acc.hasMoreBytes()) {
                return -1;
            }
            b = acc.nextByte();
            int n = b & 0xFF;
        }
        return ch;
    }
}

