/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.xml.util.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class XmlBeanDeserializerModifier
extends BeanDeserializerModifier {
    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int changed = 0;
        int len = propDefs.size();
        for (int i = 0; i < len; ++i) {
            BeanPropertyDefinition prop = propDefs.get(i);
            AnnotatedMember acc = prop.getAccessor();
            if (acc == null) continue;
            QName wrapperName = AnnotationUtil.findWrapperName(intr, acc);
            if (wrapperName != null) {
                String localName = wrapperName.getLocalPart();
                if (localName == null || localName.length() < 0 || localName.equals(prop.getName())) continue;
                if (changed == 0) {
                    propDefs = new ArrayList<BeanPropertyDefinition>(propDefs);
                }
                ++changed;
                propDefs.set(i, prop.withName(localName));
                continue;
            }
            Boolean b = AnnotationUtil.findIsTextAnnotation(intr, acc);
            if (b == null || !b.booleanValue()) continue;
            propDefs.set(i, prop.withName(""));
        }
        return propDefs;
    }
}

