/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.util;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.ri.Stax2ReaderAdapter;

public class XmlTokenStream {
    public static final int XML_START_ELEMENT = 1;
    public static final int XML_END_ELEMENT = 2;
    public static final int XML_ATTRIBUTE_NAME = 3;
    public static final int XML_ATTRIBUTE_VALUE = 4;
    public static final int XML_TEXT = 5;
    public static final int XML_END = 6;
    protected final XMLStreamReader2 _xmlReader;
    protected final Object _sourceReference;
    protected int _currentState;
    protected int _attributeCount;
    protected int _nextAttributeIndex = 0;
    protected String _localName;
    protected String _namespaceURI;
    protected String _textValue;

    public XmlTokenStream(XMLStreamReader xmlReader, Object sourceRef) {
        this._sourceReference = sourceRef;
        if (xmlReader.getEventType() != 1) {
            throw new IllegalArgumentException("Invalid XMLStreamReader passed: should be pointing to START_ELEMENT (1), instead got " + xmlReader.getEventType());
        }
        this._xmlReader = Stax2ReaderAdapter.wrapIfNecessary((XMLStreamReader)xmlReader);
        this._currentState = 1;
        this._localName = this._xmlReader.getLocalName();
        this._namespaceURI = this._xmlReader.getNamespaceURI();
        this._attributeCount = this._xmlReader.getAttributeCount();
    }

    public XMLStreamReader2 getXmlReader() {
        return this._xmlReader;
    }

    public int next() throws IOException {
        try {
            return this._next();
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
            return -1;
        }
    }

    public void skipEndElement() throws IOException {
        try {
            int type = this._next();
            if (type != 2) {
                throw new IOException("Expected END_ELEMENT, got event of type " + type);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public int getCurrentToken() {
        return this._currentState;
    }

    public String getText() {
        return this._textValue;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public boolean hasAttributes() {
        return this._currentState == 1 && this._attributeCount > 0;
    }

    public void closeCompletely() throws IOException {
        try {
            this._xmlReader.closeCompletely();
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public void close() throws IOException {
        try {
            this._xmlReader.close();
        }
        catch (XMLStreamException e) {
            StaxUtil.throwXmlAsIOException(e);
        }
    }

    public JsonLocation getCurrentLocation() {
        return this._extractLocation(this._xmlReader.getLocationInfo().getCurrentLocation());
    }

    public JsonLocation getTokenLocation() {
        return this._extractLocation(this._xmlReader.getLocationInfo().getStartLocation());
    }

    private final int _next() throws XMLStreamException {
        switch (this._currentState) {
            case 4: {
                ++this._nextAttributeIndex;
            }
            case 1: {
                if (this._nextAttributeIndex < this._attributeCount) {
                    this._localName = this._xmlReader.getAttributeLocalName(this._nextAttributeIndex);
                    this._namespaceURI = this._xmlReader.getAttributeNamespace(this._nextAttributeIndex);
                    this._textValue = this._xmlReader.getAttributeValue(this._nextAttributeIndex);
                    this._currentState = 3;
                    return 3;
                }
                String text = this._collectUntilTag();
                if (this._xmlReader.getEventType() == 1) {
                    return this._initStartElement();
                }
                if (text != null) {
                    this._textValue = text;
                    this._currentState = 5;
                    return 5;
                }
                this._currentState = 2;
                return 2;
            }
            case 3: {
                this._currentState = 4;
                return 4;
            }
            case 5: {
                this._currentState = 2;
                return 2;
            }
        }
        switch (this._skipUntilTag()) {
            case 8: {
                this._currentState = 6;
                return 6;
            }
            case 2: {
                this._currentState = 2;
                return 2;
            }
        }
        return this._initStartElement();
    }

    private final String _collectUntilTag() throws XMLStreamException {
        String text = null;
        block4: while (true) {
            switch (this._xmlReader.next()) {
                case 1: 
                case 2: 
                case 8: {
                    return text;
                }
                case 4: 
                case 12: {
                    if (text == null) {
                        text = this._xmlReader.getText();
                        continue block4;
                    }
                    text = text + this._xmlReader.getText();
                    continue block4;
                }
            }
        }
    }

    private final int _skipUntilTag() throws XMLStreamException {
        while (true) {
            int type = this._xmlReader.next();
            switch (type) {
                case 1: 
                case 2: 
                case 8: {
                    return type;
                }
            }
        }
    }

    private final int _initStartElement() throws XMLStreamException {
        this._nextAttributeIndex = 0;
        this._attributeCount = this._xmlReader.getAttributeCount();
        this._localName = this._xmlReader.getLocalName();
        this._namespaceURI = this._xmlReader.getNamespaceURI();
        this._currentState = 1;
        return 1;
    }

    private JsonLocation _extractLocation(XMLStreamLocation2 location) {
        if (location == null) {
            return new JsonLocation(this._sourceReference, -1L, -1, -1);
        }
        return new JsonLocation(this._sourceReference, (long)location.getCharacterOffset(), location.getLineNumber(), location.getColumnNumber());
    }
}

