/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WrapperHandlingDeserializer
extends DelegatingDeserializer {
    private static final long serialVersionUID = 1L;
    protected final Set<String> _namesToWrap;

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate) {
        this(delegate, null);
    }

    public WrapperHandlingDeserializer(BeanDeserializerBase delegate, Set<String> namesToWrap) {
        super((JsonDeserializer)delegate);
        this._namesToWrap = namesToWrap;
    }

    protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
        return new WrapperHandlingDeserializer(this._verifyDeserType(newDelegatee), this._namesToWrap);
    }

    protected JsonDeserializer<?> _createContextual(DeserializationContext ctxt, BeanProperty property, JsonDeserializer<?> newDelegatee0) {
        BeanDeserializerBase newDelegatee = this._verifyDeserType(newDelegatee0);
        Iterator it = newDelegatee.properties();
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        HashSet<String> unwrappedNames = null;
        while (it.hasNext()) {
            PropertyName wrapperName;
            SettableBeanProperty prop = (SettableBeanProperty)it.next();
            JavaType type = prop.getType();
            if (!TypeUtil.isIndexedType(type)) continue;
            AnnotatedMember acc = prop.getMember();
            PropertyName propertyName = wrapperName = acc == null ? null : intr.findWrapperName((Annotated)acc);
            if (wrapperName != null && wrapperName != PropertyName.NO_NAME) continue;
            if (unwrappedNames == null) {
                unwrappedNames = new HashSet<String>();
            }
            unwrappedNames.add(prop.getName());
        }
        if (unwrappedNames == null) {
            return newDelegatee;
        }
        return new WrapperHandlingDeserializer(newDelegatee, unwrappedNames);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        this._configureParser(jp);
        return this._delegatee.deserialize(jp, ctxt);
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt, Object intoValue) throws IOException, JsonProcessingException {
        this._configureParser(jp);
        return this._delegatee.deserialize(jp, ctxt, intoValue);
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        this._configureParser(jp);
        return this._delegatee.deserializeWithType(jp, ctxt, typeDeserializer);
    }

    protected void _configureParser(JsonParser jp) throws IOException, JsonProcessingException {
        ((FromXmlParser)jp).addVirtualWrapping(this._namesToWrap);
    }

    protected BeanDeserializerBase _verifyDeserType(JsonDeserializer<?> deser) {
        if (!(deser instanceof BeanDeserializerBase)) {
            throw new IllegalArgumentException("Can not change delegate to be of type " + deser.getClass().getName());
        }
        return (BeanDeserializerBase)deser;
    }
}

