/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.dataformat.xml.deser.XmlReadContext;
import com.fasterxml.jackson.dataformat.xml.deser.XmlTokenStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;

public class FromXmlParser
extends ParserMinimalBase {
    public static final String DEFAULT_UNNAMED_TEXT_PROPERTY = "";
    protected String _cfgNameForTextElement = "";
    protected int _xmlFeatures;
    protected ObjectCodec _objectCodec;
    protected boolean _closed;
    protected final IOContext _ioContext;
    protected XmlReadContext _parsingContext;
    protected final XmlTokenStream _xmlTokens;
    protected boolean _mayBeLeaf;
    protected JsonToken _nextToken;
    protected String _currText;
    protected Set<String> _namesToWrap;
    protected ByteArrayBuilder _byteArrayBuilder = null;
    protected byte[] _binaryValue;

    public FromXmlParser(IOContext ctxt, int genericParserFeatures, int xmlFeatures, ObjectCodec codec, XMLStreamReader xmlReader) {
        super(genericParserFeatures);
        this._xmlFeatures = xmlFeatures;
        this._ioContext = ctxt;
        this._objectCodec = codec;
        this._parsingContext = XmlReadContext.createRootContext(-1, -1);
        this._nextToken = JsonToken.START_OBJECT;
        this._xmlTokens = new XmlTokenStream(xmlReader, ctxt.getSourceReference());
    }

    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    public void setCodec(ObjectCodec c) {
        this._objectCodec = c;
    }

    public void setXMLTextElementName(String name) {
        this._cfgNameForTextElement = name;
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public FromXmlParser enable(Feature f) {
        this._xmlFeatures |= f.getMask();
        return this;
    }

    public FromXmlParser disable(Feature f) {
        this._xmlFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._xmlFeatures & f.getMask()) != 0;
    }

    public FromXmlParser configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public XMLStreamReader getStaxReader() {
        return this._xmlTokens.getXmlReader();
    }

    public void addVirtualWrapping(Set<String> namesToWrap) {
        String name = this._xmlTokens.getLocalName();
        if (name != null && namesToWrap.contains(name)) {
            this._xmlTokens.repeatStartElement();
        }
        this._namesToWrap = namesToWrap;
        this._parsingContext.setNamesToWrap(namesToWrap);
    }

    public String getCurrentName() throws IOException, JsonParseException {
        String name;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            XmlReadContext parent = this._parsingContext.getParent();
            name = parent.getCurrentName();
        } else {
            name = this._parsingContext.getCurrentName();
        }
        if (name == null) {
            throw new IllegalStateException("Missing name, in state: " + this._currToken);
        }
        return name;
    }

    public void overrideCurrentName(String name) {
        XmlReadContext ctxt = this._parsingContext;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            ctxt = ctxt.getParent();
        }
        ctxt.setCurrentName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            try {
                if (this._ioContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE)) {
                    this._xmlTokens.closeCompletely();
                } else {
                    this._xmlTokens.close();
                }
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public XmlReadContext getParsingContext() {
        return this._parsingContext;
    }

    public JsonLocation getTokenLocation() {
        return this._xmlTokens.getTokenLocation();
    }

    public JsonLocation getCurrentLocation() {
        return this._xmlTokens.getCurrentLocation();
    }

    public boolean isExpectedStartArrayToken() {
        JsonToken t = this._currToken;
        if (t == JsonToken.START_OBJECT) {
            this._currToken = JsonToken.START_ARRAY;
            this._parsingContext.convertToArray();
            this._nextToken = null;
            this._xmlTokens.skipAttributes();
            return true;
        }
        return t == JsonToken.START_ARRAY;
    }

    public JsonToken nextToken() throws IOException, JsonParseException {
        this._binaryValue = null;
        if (this._nextToken != null) {
            JsonToken t;
            this._currToken = t = this._nextToken;
            this._nextToken = null;
            switch (t) {
                case START_OBJECT: {
                    this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    break;
                }
                case START_ARRAY: {
                    this._parsingContext = this._parsingContext.createChildArrayContext(-1, -1);
                    break;
                }
                case END_OBJECT: 
                case END_ARRAY: {
                    this._parsingContext = this._parsingContext.getParent();
                    this._namesToWrap = this._parsingContext.getNamesToWrap();
                    break;
                }
                case FIELD_NAME: {
                    this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                    break;
                }
            }
            return t;
        }
        int token = this._xmlTokens.next();
        while (token == 1) {
            if (this._mayBeLeaf) {
                this._nextToken = JsonToken.FIELD_NAME;
                this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                this._currToken = JsonToken.START_OBJECT;
                return this._currToken;
            }
            if (this._parsingContext.inArray()) {
                token = this._xmlTokens.next();
                this._mayBeLeaf = true;
                continue;
            }
            String name = this._xmlTokens.getLocalName();
            this._parsingContext.setCurrentName(name);
            if (this._namesToWrap != null && this._namesToWrap.contains(name)) {
                this._xmlTokens.repeatStartElement();
            }
            this._mayBeLeaf = true;
            this._currToken = JsonToken.FIELD_NAME;
            return this._currToken;
        }
        switch (token) {
            case 2: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._currToken = JsonToken.VALUE_NULL;
                    return this._currToken;
                }
                this._currToken = this._parsingContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
                this._parsingContext = this._parsingContext.getParent();
                this._namesToWrap = this._parsingContext.getNamesToWrap();
                return this._currToken;
            }
            case 3: {
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._nextToken = JsonToken.FIELD_NAME;
                    this._currText = this._xmlTokens.getText();
                    this._parsingContext = this._parsingContext.createChildObjectContext(-1, -1);
                    this._currToken = JsonToken.START_OBJECT;
                    return this._currToken;
                }
                this._parsingContext.setCurrentName(this._xmlTokens.getLocalName());
                this._currToken = JsonToken.FIELD_NAME;
                return this._currToken;
            }
            case 4: {
                this._currText = this._xmlTokens.getText();
                this._currToken = JsonToken.VALUE_STRING;
                return this._currToken;
            }
            case 5: {
                this._currText = this._xmlTokens.getText();
                if (this._mayBeLeaf) {
                    this._mayBeLeaf = false;
                    this._xmlTokens.skipEndElement();
                    if (this._parsingContext.inArray() && this._isEmpty(this._currText)) {
                        this._currToken = JsonToken.END_ARRAY;
                        this._parsingContext = this._parsingContext.getParent();
                        this._namesToWrap = this._parsingContext.getNamesToWrap();
                        return this._currToken;
                    }
                    this._currToken = JsonToken.VALUE_STRING;
                    return this._currToken;
                }
                this._parsingContext.setCurrentName(this._cfgNameForTextElement);
                this._nextToken = JsonToken.VALUE_STRING;
                this._currToken = JsonToken.FIELD_NAME;
                return this._currToken;
            }
            case 6: {
                this._currToken = null;
                return null;
            }
        }
        this._throwInternal();
        return null;
    }

    public String getText() throws IOException, JsonParseException {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this.getCurrentName();
            }
            case VALUE_STRING: {
                return this._currText;
            }
        }
        return this._currToken.asString();
    }

    public final String getValueAsString() throws IOException, JsonParseException {
        return this.getValueAsString(null);
    }

    public String getValueAsString(String defValue) throws IOException, JsonParseException {
        JsonToken t = this._currToken;
        if (t == null) {
            return null;
        }
        switch (t) {
            case FIELD_NAME: {
                return this.getCurrentName();
            }
            case VALUE_STRING: {
                return this._currText;
            }
            case START_OBJECT: {
                String str = this._xmlTokens.convertToString();
                if (str != null) {
                    this._parsingContext = this._parsingContext.getParent();
                    this._namesToWrap = this._parsingContext.getNamesToWrap();
                    this._currToken = JsonToken.VALUE_STRING;
                    this._nextToken = null;
                    this._xmlTokens.skipEndElement();
                    this._currText = str;
                    return this._currText;
                }
                return null;
            }
        }
        if (this._currToken.isScalarValue()) {
            return this._currToken.asString();
        }
        return defValue;
    }

    public char[] getTextCharacters() throws IOException, JsonParseException {
        String text = this.getText();
        return text == null ? null : text.toCharArray();
    }

    public int getTextLength() throws IOException, JsonParseException {
        String text = this.getText();
        return text == null ? 0 : text.length();
    }

    public int getTextOffset() throws IOException, JsonParseException {
        return 0;
    }

    public boolean hasTextCharacters() {
        return false;
    }

    public Object getEmbeddedObject() throws IOException, JsonParseException {
        return null;
    }

    public byte[] getBinaryValue(Base64Variant b64variant) throws IOException, JsonParseException {
        if (this._currToken != JsonToken.VALUE_STRING && (this._currToken != JsonToken.VALUE_EMBEDDED_OBJECT || this._binaryValue == null)) {
            this._reportError("Current token (" + this._currToken + ") not VALUE_STRING or VALUE_EMBEDDED_OBJECT, can not access as binary");
        }
        if (this._binaryValue == null) {
            try {
                this._binaryValue = this._decodeBase64(b64variant);
            }
            catch (IllegalArgumentException iae) {
                throw this._constructError("Failed to decode VALUE_STRING as base64 (" + b64variant + "): " + iae.getMessage());
            }
        }
        return this._binaryValue;
    }

    protected byte[] _decodeBase64(Base64Variant b64variant) throws IOException, JsonParseException {
        ByteArrayBuilder builder = this._getByteArrayBuilder();
        String str = this.getText();
        int ptr = 0;
        int len = str.length();
        block0: while (ptr < len) {
            char ch;
            do {
                ch = str.charAt(ptr++);
                if (ptr >= len) break block0;
            } while (ch <= ' ');
            int bits = b64variant.decodeBase64Char(ch);
            if (bits < 0) {
                this._reportInvalidBase64(b64variant, ch, 0, null);
            }
            int decodedData = bits;
            if (ptr >= len) {
                this._reportBase64EOF();
            }
            if ((bits = b64variant.decodeBase64Char(ch = str.charAt(ptr++))) < 0) {
                this._reportInvalidBase64(b64variant, ch, 1, null);
            }
            decodedData = decodedData << 6 | bits;
            if (ptr >= len) {
                this._reportBase64EOF();
            }
            if ((bits = b64variant.decodeBase64Char(ch = str.charAt(ptr++))) < 0) {
                if (bits != -2) {
                    this._reportInvalidBase64(b64variant, ch, 2, null);
                }
                if (ptr >= len) {
                    this._reportBase64EOF();
                }
                if (!b64variant.usesPaddingChar(ch = str.charAt(ptr++))) {
                    this._reportInvalidBase64(b64variant, ch, 3, "expected padding character '" + b64variant.getPaddingChar() + "'");
                }
                builder.append(decodedData >>= 4);
                continue;
            }
            decodedData = decodedData << 6 | bits;
            if (ptr >= len) {
                this._reportBase64EOF();
            }
            if ((bits = b64variant.decodeBase64Char(ch = str.charAt(ptr++))) < 0) {
                if (bits != -2) {
                    this._reportInvalidBase64(b64variant, ch, 3, null);
                }
                builder.appendTwoBytes(decodedData >>= 2);
                continue;
            }
            decodedData = decodedData << 6 | bits;
            builder.appendThreeBytes(decodedData);
        }
        return builder.toByteArray();
    }

    protected void _reportInvalidBase64(Base64Variant b64variant, char ch, int bindex, String msg) throws JsonParseException {
        String base = ch <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(ch) + ") as character #" + (bindex + 1) + " of 4-char base64 unit: can only used between units" : (b64variant.usesPaddingChar(ch) ? "Unexpected padding character ('" + b64variant.getPaddingChar() + "') as character #" + (bindex + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(ch) || Character.isISOControl(ch) ? "Illegal character (code 0x" + Integer.toHexString(ch) + ") in base64 content" : "Illegal character '" + ch + "' (code 0x" + Integer.toHexString(ch) + ") in base64 content"));
        if (msg != null) {
            base = base + ": " + msg;
        }
        throw new JsonParseException(base, JsonLocation.NA);
    }

    protected void _reportBase64EOF() throws JsonParseException {
        throw new JsonParseException("Unexpected end-of-String when base64 content", JsonLocation.NA);
    }

    public BigInteger getBigIntegerValue() throws IOException, JsonParseException {
        return null;
    }

    public BigDecimal getDecimalValue() throws IOException, JsonParseException {
        return null;
    }

    public double getDoubleValue() throws IOException, JsonParseException {
        return 0.0;
    }

    public float getFloatValue() throws IOException, JsonParseException {
        return 0.0f;
    }

    public int getIntValue() throws IOException, JsonParseException {
        return 0;
    }

    public long getLongValue() throws IOException, JsonParseException {
        return 0L;
    }

    public JsonParser.NumberType getNumberType() throws IOException, JsonParseException {
        return null;
    }

    public Number getNumberValue() throws IOException, JsonParseException {
        return null;
    }

    protected void _handleEOF() throws JsonParseException {
        if (!this._parsingContext.inRoot()) {
            this._reportInvalidEOF(": expected close marker for " + this._parsingContext.getTypeDesc() + " (from " + this._parsingContext.getStartLocation(this._ioContext.getSourceReference()) + ")");
        }
    }

    protected void _releaseBuffers() throws IOException {
    }

    protected ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected boolean _isEmpty(String str) {
        int len;
        int n = len = str == null ? 0 : str.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (str.charAt(i) <= ' ') continue;
                return false;
            }
        }
        return true;
    }

    public static enum Feature {
        DUMMY_PLACEHOLDER(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

