/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public class XmlSerializerProvider
extends DefaultSerializerProvider {
    private static final long serialVersionUID = 8525947864862035821L;
    protected static final QName ROOT_NAME_FOR_NULL = new QName("null");
    protected final XmlRootNameLookup _rootNameLookup;

    public XmlSerializerProvider(XmlRootNameLookup rootNames) {
        this._rootNameLookup = rootNames;
    }

    public XmlSerializerProvider(XmlSerializerProvider src, SerializationConfig config, SerializerFactory f) {
        super((SerializerProvider)src, config, f);
        this._rootNameLookup = src._rootNameLookup;
    }

    public DefaultSerializerProvider createInstance(SerializationConfig config, SerializerFactory jsf) {
        return new XmlSerializerProvider(this, config, jsf);
    }

    public void serializeValue(JsonGenerator jgen, Object value) throws IOException, JsonProcessingException {
        QName rootName = value == null ? ROOT_NAME_FOR_NULL : this._rootNameLookup.findRootName(value.getClass(), (MapperConfig<?>)this._config);
        this._initWithRootName(jgen, rootName);
        super.serializeValue(jgen, value);
    }

    public void serializeValue(JsonGenerator jgen, Object value, JavaType rootType) throws IOException, JsonProcessingException {
        QName rootName = this._rootNameLookup.findRootName(rootType, (MapperConfig<?>)this._config);
        this._initWithRootName(jgen, rootName);
        super.serializeValue(jgen, value, rootType);
    }

    public void serializeValue(JsonGenerator jgen, Object value, JavaType rootType, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
        QName rootName = this._rootNameLookup.findRootName(rootType, (MapperConfig<?>)this._config);
        this._initWithRootName(jgen, rootName);
        super.serializeValue(jgen, value, rootType, ser);
    }

    protected void _initWithRootName(JsonGenerator jgen, QName rootName) throws IOException, JsonProcessingException {
        ToXmlGenerator xgen = (ToXmlGenerator)jgen;
        if (!xgen.setNextNameIfMissing(rootName) && xgen.getOutputContext().inRoot()) {
            xgen.setNextName(rootName);
        }
        xgen.initGenerator();
        String ns = rootName.getNamespaceURI();
        if (ns != null && ns.length() > 0) {
            try {
                xgen.getStaxWriter().setDefaultNamespace(ns);
            }
            catch (XMLStreamException e) {
                StaxUtil.throwXmlAsIOException(e);
            }
        }
    }
}

