/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.XmlTypeResolverBuilder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;

public class JacksonXmlAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements XmlAnnotationIntrospector {
    public static final boolean DEFAULT_USE_WRAPPER = true;
    protected final boolean _cfgDefaultUseWrapper;

    public JacksonXmlAnnotationIntrospector() {
        this(true);
    }

    public JacksonXmlAnnotationIntrospector(boolean defaultUseWrapper) {
        this._cfgDefaultUseWrapper = defaultUseWrapper;
    }

    public PropertyName findWrapperName(Annotated ann) {
        JacksonXmlElementWrapper w = (JacksonXmlElementWrapper)ann.getAnnotation(JacksonXmlElementWrapper.class);
        if (w != null) {
            if (!w.useWrapping()) {
                return PropertyName.NO_NAME;
            }
            String localName = w.localName();
            if (localName == null || localName.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return PropertyName.construct((String)w.localName(), (String)w.namespace());
        }
        if (this._cfgDefaultUseWrapper) {
            return PropertyName.USE_DEFAULT;
        }
        return null;
    }

    public PropertyName findRootName(AnnotatedClass ac) {
        JacksonXmlRootElement root = (JacksonXmlRootElement)ac.getAnnotation(JacksonXmlRootElement.class);
        if (root != null) {
            String local = root.localName();
            String ns = root.namespace();
            if (local.length() == 0 && ns.length() == 0) {
                return PropertyName.USE_DEFAULT;
            }
            return new PropertyName(local, ns);
        }
        return super.findRootName(ac);
    }

    public String findNamespace(Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)ann.getAnnotation(JacksonXmlProperty.class);
        if (prop != null) {
            return prop.namespace();
        }
        return null;
    }

    public Boolean isOutputAsAttribute(Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)ann.getAnnotation(JacksonXmlProperty.class);
        if (prop != null) {
            return prop.isAttribute() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public Boolean isOutputAsText(Annotated ann) {
        JacksonXmlText prop = (JacksonXmlText)ann.getAnnotation(JacksonXmlText.class);
        if (prop != null) {
            return prop.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public PropertyName findNameForSerialization(Annotated a) {
        PropertyName name = this._findXmlName(a);
        return name == null ? super.findNameForSerialization(a) : name;
    }

    @Deprecated
    public String findSerializationName(AnnotatedField af) {
        PropertyName name = this._findXmlName((Annotated)af);
        if (name != null) {
            return name.getSimpleName();
        }
        return super.findSerializationName(af);
    }

    @Deprecated
    public String findSerializationName(AnnotatedMethod am) {
        PropertyName name = this._findXmlName((Annotated)am);
        if (name != null) {
            return name.getSimpleName();
        }
        return super.findSerializationName(am);
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        PropertyName name = this._findXmlName(a);
        return name == null ? super.findNameForDeserialization(a) : name;
    }

    @Deprecated
    public String findDeserializationName(AnnotatedField af) {
        PropertyName name = this._findXmlName((Annotated)af);
        if (name != null) {
            return name.getSimpleName();
        }
        return super.findDeserializationName(af);
    }

    @Deprecated
    public String findDeserializationName(AnnotatedMethod am) {
        PropertyName name = this._findXmlName((Annotated)am);
        if (name != null) {
            return name.getSimpleName();
        }
        return super.findDeserializationName(am);
    }

    @Deprecated
    public String findDeserializationName(AnnotatedParameter ap) {
        String local;
        PropertyName name = this._findXmlName((Annotated)ap);
        if (name != null && (local = name.getSimpleName()) != null && local.length() > 0) {
            return local;
        }
        return super.findDeserializationName(ap);
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new XmlTypeResolverBuilder();
    }

    protected PropertyName _findXmlName(Annotated a) {
        JacksonXmlProperty pann = (JacksonXmlProperty)a.getAnnotation(JacksonXmlProperty.class);
        if (pann != null) {
            return PropertyName.construct((String)pann.localName(), (String)pann.namespace());
        }
        return null;
    }
}

