/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.deser;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.xml.deser.WrapperHandlingDeserializer;
import com.fasterxml.jackson.dataformat.xml.util.AnnotationUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeanDeserializerModifier
extends BeanDeserializerModifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String _cfgNameForTextValue = "";

    public XmlBeanDeserializerModifier(String nameForTextValue) {
        this._cfgNameForTextValue = nameForTextValue;
    }

    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int changed = 0;
        int len = propDefs.size();
        for (int i = 0; i < len; ++i) {
            String localName;
            BeanPropertyDefinition prop = propDefs.get(i);
            AnnotatedMember acc = prop.getAccessor();
            if (acc == null) continue;
            Boolean b = AnnotationUtil.findIsTextAnnotation(intr, acc);
            if (b != null && b.booleanValue()) {
                BeanPropertyDefinition newProp = prop.withName(this._cfgNameForTextValue);
                if (newProp == prop) continue;
                propDefs.set(i, newProp);
                continue;
            }
            PropertyName wrapperName = intr.findWrapperName((Annotated)acc);
            if (wrapperName == null || wrapperName == PropertyName.NO_NAME || (localName = wrapperName.getSimpleName()) == null || localName.length() <= 0 || localName.equals(prop.getName())) continue;
            if (changed == 0) {
                propDefs = new ArrayList<BeanPropertyDefinition>(propDefs);
            }
            ++changed;
            propDefs.set(i, prop.withName(localName));
        }
        return propDefs;
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        if (!(deserializer instanceof BeanDeserializerBase)) {
            return deserializer;
        }
        return new WrapperHandlingDeserializer((BeanDeserializerBase)deserializer);
    }
}

