/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeanPropertyWriter
extends BeanPropertyWriter {
    protected final QName _wrapperName;
    protected final QName _wrappedName;

    public XmlBeanPropertyWriter(BeanPropertyWriter wrapped, PropertyName wrapperName, PropertyName wrappedName) {
        this(wrapped, wrapperName, wrappedName, null);
    }

    public XmlBeanPropertyWriter(BeanPropertyWriter wrapped, PropertyName wrapperName, PropertyName wrappedName, JsonSerializer<Object> serializer) {
        super(wrapped);
        this._wrapperName = this._qname(wrapperName);
        this._wrappedName = this._qname(wrappedName);
        if (serializer != null) {
            this.assignSerializer(serializer);
        }
    }

    private QName _qname(PropertyName n) {
        String ns = n.getNamespace();
        if (ns == null) {
            ns = "";
        }
        return new QName(ns, n.getSimpleName());
    }

    public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value = this.get(bean);
        if (value == null) {
            if (this._nullSerializer != null) {
                jgen.writeFieldName((SerializableString)this._name);
                this._nullSerializer.serialize(null, jgen, prov);
            }
            return;
        }
        JsonSerializer ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean) {
            this._handleSelfReference(bean, ser);
        }
        ToXmlGenerator xmlGen = (ToXmlGenerator)jgen;
        xmlGen.startWrappedValue(this._wrapperName, this._wrappedName);
        jgen.writeFieldName((SerializableString)this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value, jgen, prov);
        } else {
            ser.serializeWithType(value, jgen, prov, this._typeSerializer);
        }
        xmlGen.finishWrappedValue(this._wrapperName, this._wrappedName);
    }
}

