/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.XmlInfo;
import java.io.IOException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeanSerializer
extends BeanSerializer {
    public static final String KEY_XML_INFO = new String("xmlInfo");
    protected final int _attributeCount;
    protected final int _textPropertyIndex;
    protected final QName[] _xmlNames;

    public XmlBeanSerializer(BeanSerializerBase src) {
        super(src);
        int attrCount = 0;
        for (BeanPropertyWriter bpw : this._props) {
            if (!XmlBeanSerializer._isAttribute(bpw)) continue;
            attrCount = XmlBeanSerializer._orderAttributesFirst(this._props, this._filteredProps);
            break;
        }
        this._attributeCount = attrCount;
        this._xmlNames = new QName[this._props.length];
        int textIndex = -1;
        int len = this._props.length;
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw;
            bpw = this._props[i];
            XmlInfo info = (XmlInfo)bpw.getInternalSetting((Object)KEY_XML_INFO);
            String ns = null;
            if (info != null) {
                ns = info.getNamespace();
                if (textIndex < 0 && info.isText()) {
                    textIndex = i;
                }
            }
            this._xmlNames[i] = new QName(ns == null ? "" : ns, bpw.getName());
        }
        this._textPropertyIndex = textIndex;
    }

    protected XmlBeanSerializer(XmlBeanSerializer src, ObjectIdWriter objectIdWriter) {
        super((BeanSerializerBase)src, objectIdWriter);
        this._attributeCount = src._attributeCount;
        this._textPropertyIndex = src._textPropertyIndex;
        this._xmlNames = src._xmlNames;
    }

    public JsonSerializer<Object> unwrappingSerializer(NameTransformer unwrapper) {
        throw new UnsupportedOperationException("Unwrapping serialization not yet supported for XML");
    }

    public BeanSerializer withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new XmlBeanSerializer(this, objectIdWriter);
    }

    protected void serializeFields(Object bean, JsonGenerator jgen0, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i;
        ToXmlGenerator xgen = (ToXmlGenerator)jgen0;
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getSerializationView() != null ? this._filteredProps : this._props;
        int attrCount = this._attributeCount;
        if (attrCount > 0) {
            xgen.setNextIsAttribute(true);
        }
        int textIndex = this._textPropertyIndex;
        QName[] xmlNames = this._xmlNames;
        try {
            int len = props.length;
            for (i = 0; i < len; ++i) {
                if (i == attrCount) {
                    xgen.setNextIsAttribute(false);
                }
                if (i == textIndex) {
                    xgen.setNextIsUnwrapped(true);
                }
                xgen.setNextName(xmlNames[i]);
                BeanPropertyWriter prop = props[i];
                if (prop == null) continue;
                prop.serializeAsField(bean, (JsonGenerator)xgen, provider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(bean, (JsonGenerator)xgen, provider);
            }
        }
        catch (Exception e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(provider, e, bean, name);
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = new JsonMappingException("Infinite recursion (StackOverflowError)");
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            mapE.prependPath(new JsonMappingException.Reference(bean, name));
            throw mapE;
        }
    }

    protected void serializeFieldsFiltered(Object bean, JsonGenerator jgen0, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i;
        ToXmlGenerator xgen = (ToXmlGenerator)jgen0;
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getSerializationView() != null ? this._filteredProps : this._props;
        BeanPropertyFilter filter = this.findFilter(provider);
        if (filter == null) {
            this.serializeFields(bean, jgen0, provider);
            return;
        }
        int attrCount = this._attributeCount;
        if (attrCount > 0) {
            xgen.setNextIsAttribute(true);
        }
        int textIndex = this._textPropertyIndex;
        QName[] xmlNames = this._xmlNames;
        try {
            int len = props.length;
            for (i = 0; i < len; ++i) {
                if (i == attrCount) {
                    xgen.setNextIsAttribute(false);
                }
                if (i == textIndex) {
                    xgen.setNextIsUnwrapped(true);
                }
                xgen.setNextName(xmlNames[i]);
                BeanPropertyWriter prop = props[i];
                if (prop == null) continue;
                filter.serializeAsField(bean, (JsonGenerator)xgen, provider, prop);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(bean, (JsonGenerator)xgen, provider);
            }
        }
        catch (Exception e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(provider, e, bean, name);
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = new JsonMappingException("Infinite recursion (StackOverflowError)", (Throwable)e);
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            mapE.prependPath(new JsonMappingException.Reference(bean, name));
            throw mapE;
        }
    }

    public void serializeWithType(Object bean, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        if (typeSer.getTypeInclusion() == JsonTypeInfo.As.PROPERTY) {
            ToXmlGenerator xgen = (ToXmlGenerator)jgen;
            xgen.setNextIsAttribute(true);
            super.serializeWithType(bean, jgen, provider, typeSer);
            if (this._attributeCount == 0) {
                xgen.setNextIsAttribute(false);
            }
        } else {
            super.serializeWithType(bean, jgen, provider, typeSer);
        }
    }

    protected static boolean _isAttribute(BeanPropertyWriter bpw) {
        XmlInfo info = (XmlInfo)bpw.getInternalSetting((Object)KEY_XML_INFO);
        return info != null && info.isAttribute();
    }

    protected static int _orderAttributesFirst(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        int attrCount = 0;
        int len = properties.length;
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = properties[i];
            if (!XmlBeanSerializer._isAttribute(bpw)) continue;
            if (attrCount < i) {
                properties[i] = properties[attrCount];
                properties[attrCount] = bpw;
                if (filteredProperties != null) {
                    BeanPropertyWriter fbpw = filteredProperties[i];
                    filteredProperties[i] = filteredProperties[attrCount];
                    filteredProperties[attrCount] = fbpw;
                }
            }
            ++attrCount;
        }
        return attrCount;
    }
}

