/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.xml.XmlPrettyPrinter;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamWriter2;

public class DefaultXmlPrettyPrinter
implements XmlPrettyPrinter,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Indenter _arrayIndenter = new FixedSpaceIndenter();
    protected Indenter _objectIndenter = new Lf2SpacesIndenter();
    protected boolean _spacesInObjectEntries = true;
    protected int _nesting = 0;

    public void indentArraysWith(Indenter i) {
        this._arrayIndenter = i == null ? new NopIndenter() : i;
    }

    public void indentObjectsWith(Indenter i) {
        this._objectIndenter = i == null ? new NopIndenter() : i;
    }

    public void spacesInObjectEntries(boolean b) {
        this._spacesInObjectEntries = b;
    }

    public void writeRootValueSeparator(JsonGenerator jgen) throws IOException, JsonGenerationException {
        jgen.writeRaw('\n');
    }

    public void beforeArrayValues(JsonGenerator jgen) throws IOException, JsonGenerationException {
    }

    public void writeStartArray(JsonGenerator jgen) throws IOException, JsonGenerationException {
    }

    public void writeArrayValueSeparator(JsonGenerator jgen) throws IOException, JsonGenerationException {
    }

    public void writeEndArray(JsonGenerator jgen, int nrOfValues) throws IOException, JsonGenerationException {
    }

    public void beforeObjectEntries(JsonGenerator jgen) throws IOException, JsonGenerationException {
    }

    public void writeStartObject(JsonGenerator jgen) throws IOException, JsonGenerationException {
        if (!this._objectIndenter.isInline()) {
            if (this._nesting > 0) {
                this._objectIndenter.writeIndentation(jgen, this._nesting);
            }
            ++this._nesting;
        }
        ((ToXmlGenerator)jgen)._handleStartObject();
    }

    public void writeObjectEntrySeparator(JsonGenerator jgen) throws IOException, JsonGenerationException {
    }

    public void writeObjectFieldValueSeparator(JsonGenerator jgen) throws IOException, JsonGenerationException {
    }

    public void writeEndObject(JsonGenerator jgen, int nrOfEntries) throws IOException, JsonGenerationException {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (nrOfEntries > 0) {
            this._objectIndenter.writeIndentation(jgen, this._nesting);
        }
        ((ToXmlGenerator)jgen)._handleEndObject();
    }

    public void writeStartElement(XMLStreamWriter2 sw, String nsURI, String localName) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            if (this._nesting > 0) {
                this._objectIndenter.writeIndentation(sw, this._nesting);
            }
            ++this._nesting;
        }
        sw.writeStartElement(nsURI, localName);
    }

    public void writeEndElement(XMLStreamWriter2 sw, int nrOfEntries) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (nrOfEntries > 0) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, String text) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeCharacters(text);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, char[] buffer, int offset, int len) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeCharacters(buffer, offset, len);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, boolean value) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeBoolean(value);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, int value) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeInt(value);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, long value) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeLong(value);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, double value) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeDouble(value);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, float value) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeFloat(value);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, BigInteger value) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeInteger(value);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, BigDecimal value) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeDecimal(value);
        sw.writeEndElement();
    }

    public void writeLeafElement(XMLStreamWriter2 sw, String nsURI, String localName, byte[] data, int offset, int len) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeStartElement(nsURI, localName);
        sw.writeBinary(data, offset, len);
        sw.writeEndElement();
    }

    public void writeLeafNullElement(XMLStreamWriter2 sw, String nsURI, String localName) throws XMLStreamException {
        if (!this._objectIndenter.isInline()) {
            this._objectIndenter.writeIndentation(sw, this._nesting);
        }
        sw.writeEmptyElement(nsURI, localName);
    }

    protected static class Lf2SpacesIndenter
    implements Indenter {
        static final String SYSTEM_LINE_SEPARATOR;
        static final int SPACE_COUNT = 64;
        static final char[] SPACES;

        public boolean isInline() {
            return false;
        }

        public void writeIndentation(XMLStreamWriter2 sw, int level) throws XMLStreamException {
            sw.writeRaw(SYSTEM_LINE_SEPARATOR);
            level += level;
            while (level > 64) {
                sw.writeRaw(SPACES, 0, 64);
                level -= SPACES.length;
            }
            sw.writeRaw(SPACES, 0, level);
        }

        public void writeIndentation(JsonGenerator jg, int level) throws IOException, JsonGenerationException {
            jg.writeRaw(SYSTEM_LINE_SEPARATOR);
            level += level;
            while (level > 64) {
                jg.writeRaw(SPACES, 0, 64);
                level -= SPACES.length;
            }
            jg.writeRaw(SPACES, 0, level);
        }

        static {
            String lf = null;
            try {
                lf = System.getProperty("line.separator");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SYSTEM_LINE_SEPARATOR = lf == null ? "\n" : lf;
            SPACES = new char[64];
            Arrays.fill(SPACES, ' ');
        }
    }

    protected static class FixedSpaceIndenter
    implements Indenter {
        public void writeIndentation(XMLStreamWriter2 sw, int level) throws XMLStreamException {
            sw.writeRaw(" ");
        }

        public void writeIndentation(JsonGenerator jg, int level) throws IOException, JsonGenerationException {
            jg.writeRaw(' ');
        }

        public boolean isInline() {
            return true;
        }
    }

    protected static class NopIndenter
    implements Indenter {
        public void writeIndentation(JsonGenerator jg, int level) {
        }

        public boolean isInline() {
            return true;
        }

        public void writeIndentation(XMLStreamWriter2 sw, int level) {
        }
    }

    public static interface Indenter {
        public void writeIndentation(JsonGenerator var1, int var2) throws IOException, JsonGenerationException;

        public void writeIndentation(XMLStreamWriter2 var1, int var2) throws XMLStreamException;

        public boolean isInline();
    }
}

