/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.XmlInfo;
import java.io.IOException;
import javax.xml.namespace.QName;

public class XmlBeanSerializer
extends BeanSerializer {
    public static final String KEY_XML_INFO = new String("xmlInfo");
    protected final int _attributeCount;
    protected final int _textPropertyIndex;
    protected final QName[] _xmlNames;

    public XmlBeanSerializer(BeanSerializerBase beanSerializerBase) {
        super(beanSerializerBase);
        int n = 0;
        for (BeanPropertyWriter beanPropertyWriter : this._props) {
            if (!XmlBeanSerializer._isAttribute(beanPropertyWriter)) continue;
            n = XmlBeanSerializer._orderAttributesFirst(this._props, this._filteredProps);
            break;
        }
        this._attributeCount = n;
        this._xmlNames = new QName[this._props.length];
        int n2 = -1;
        int n3 = this._props.length;
        for (int i = 0; i < n3; ++i) {
            BeanPropertyWriter beanPropertyWriter;
            beanPropertyWriter = this._props[i];
            XmlInfo xmlInfo = (XmlInfo)beanPropertyWriter.getInternalSetting((Object)KEY_XML_INFO);
            String string = null;
            if (xmlInfo != null) {
                string = xmlInfo.getNamespace();
                if (n2 < 0 && xmlInfo.isText()) {
                    n2 = i;
                }
            }
            this._xmlNames[i] = new QName(string == null ? "" : string, beanPropertyWriter.getName());
        }
        this._textPropertyIndex = n2;
    }

    protected XmlBeanSerializer(XmlBeanSerializer xmlBeanSerializer, ObjectIdWriter objectIdWriter) {
        super((BeanSerializerBase)xmlBeanSerializer, objectIdWriter);
        this._attributeCount = xmlBeanSerializer._attributeCount;
        this._textPropertyIndex = xmlBeanSerializer._textPropertyIndex;
        this._xmlNames = xmlBeanSerializer._xmlNames;
    }

    public JsonSerializer<Object> unwrappingSerializer(NameTransformer nameTransformer) {
        throw new UnsupportedOperationException("Unwrapping serialization not yet supported for XML");
    }

    public BeanSerializer withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new XmlBeanSerializer(this, objectIdWriter);
    }

    protected void serializeFields(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        ToXmlGenerator toXmlGenerator = (ToXmlGenerator)jsonGenerator;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getSerializationView() != null ? this._filteredProps : this._props;
        int n2 = this._attributeCount;
        if (n2 > 0) {
            toXmlGenerator.setNextIsAttribute(true);
        }
        int n3 = this._textPropertyIndex;
        QName[] qNameArray = this._xmlNames;
        try {
            int n4 = beanPropertyWriterArray.length;
            for (n = 0; n < n4; ++n) {
                if (n == n2) {
                    toXmlGenerator.setNextIsAttribute(false);
                }
                if (n == n3) {
                    toXmlGenerator.setNextIsUnwrapped(true);
                }
                toXmlGenerator.setNextName(qNameArray[n]);
                BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[n];
                if (beanPropertyWriter == null) continue;
                beanPropertyWriter.serializeAsField(object, (JsonGenerator)toXmlGenerator, serializerProvider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, (JsonGenerator)toXmlGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)");
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected void serializeFieldsFiltered(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        ToXmlGenerator toXmlGenerator = (ToXmlGenerator)jsonGenerator;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getSerializationView() != null ? this._filteredProps : this._props;
        BeanPropertyFilter beanPropertyFilter = this.findFilter(serializerProvider);
        if (beanPropertyFilter == null) {
            this.serializeFields(object, jsonGenerator, serializerProvider);
            return;
        }
        int n2 = this._attributeCount;
        if (n2 > 0) {
            toXmlGenerator.setNextIsAttribute(true);
        }
        int n3 = this._textPropertyIndex;
        QName[] qNameArray = this._xmlNames;
        try {
            int n4 = beanPropertyWriterArray.length;
            for (n = 0; n < n4; ++n) {
                if (n == n2) {
                    toXmlGenerator.setNextIsAttribute(false);
                }
                if (n == n3) {
                    toXmlGenerator.setNextIsUnwrapped(true);
                }
                toXmlGenerator.setNextName(qNameArray[n]);
                BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[n];
                if (beanPropertyWriter == null) continue;
                beanPropertyFilter.serializeAsField(object, (JsonGenerator)toXmlGenerator, serializerProvider, beanPropertyWriter);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, (JsonGenerator)toXmlGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException("Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        if (typeSerializer.getTypeInclusion() == JsonTypeInfo.As.PROPERTY) {
            ToXmlGenerator toXmlGenerator = (ToXmlGenerator)jsonGenerator;
            toXmlGenerator.setNextIsAttribute(true);
            super.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
            if (this._attributeCount == 0) {
                toXmlGenerator.setNextIsAttribute(false);
            }
        } else {
            super.serializeWithType(object, jsonGenerator, serializerProvider, typeSerializer);
        }
    }

    protected static boolean _isAttribute(BeanPropertyWriter beanPropertyWriter) {
        XmlInfo xmlInfo = (XmlInfo)beanPropertyWriter.getInternalSetting((Object)KEY_XML_INFO);
        return xmlInfo != null && xmlInfo.isAttribute();
    }

    protected static int _orderAttributesFirst(BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        int n = 0;
        int n2 = beanPropertyWriterArray.length;
        for (int i = 0; i < n2; ++i) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i];
            if (!XmlBeanSerializer._isAttribute(beanPropertyWriter)) continue;
            if (n < i) {
                beanPropertyWriterArray[i] = beanPropertyWriterArray[n];
                beanPropertyWriterArray[n] = beanPropertyWriter;
                if (beanPropertyWriterArray2 != null) {
                    BeanPropertyWriter beanPropertyWriter2 = beanPropertyWriterArray2[i];
                    beanPropertyWriterArray2[i] = beanPropertyWriterArray2[n];
                    beanPropertyWriterArray2[n] = beanPropertyWriter2;
                }
            }
            ++n;
        }
        return n;
    }
}

