/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.xml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.xml.PackageVersion;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.util.StaxUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import org.codehaus.stax2.io.Stax2ByteArraySource;

public class XmlFactory
extends JsonFactory {
    private static final long serialVersionUID = -2793875812715996133L;
    public static final String FORMAT_NAME_XML = "XML";
    static final int DEFAULT_XML_PARSER_FEATURE_FLAGS = FromXmlParser.Feature.collectDefaults();
    static final int DEFAULT_XML_GENERATOR_FEATURE_FLAGS = ToXmlGenerator.Feature.collectDefaults();
    protected int _xmlParserFeatures;
    protected int _xmlGeneratorFeatures;
    protected transient XMLInputFactory _xmlInputFactory;
    protected transient XMLOutputFactory _xmlOutputFactory;
    protected String _cfgNameForTextElement;
    protected transient String _jdkXmlInFactory;
    protected transient String _jdkXmlOutFactory;
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    private static final byte BYTE_x = 120;
    private static final byte BYTE_m = 109;
    private static final byte BYTE_l = 108;
    private static final byte BYTE_D = 68;
    private static final byte BYTE_LT = 60;
    private static final byte BYTE_QMARK = 63;
    private static final byte BYTE_EXCL = 33;
    private static final byte BYTE_HYPHEN = 45;

    public XmlFactory() {
        this(null);
    }

    public XmlFactory(ObjectCodec oc) {
        this(oc, null, null);
    }

    public XmlFactory(XMLInputFactory xmlIn, XMLOutputFactory xmlOut) {
        this(null, xmlIn, xmlOut);
    }

    public XmlFactory(ObjectCodec oc, XMLInputFactory xmlIn, XMLOutputFactory xmlOut) {
        this(oc, DEFAULT_XML_PARSER_FEATURE_FLAGS, DEFAULT_XML_GENERATOR_FEATURE_FLAGS, xmlIn, xmlOut, null);
    }

    protected XmlFactory(ObjectCodec oc, int xpFeatures, int xgFeatures, XMLInputFactory xmlIn, XMLOutputFactory xmlOut, String nameForTextElem) {
        super(oc);
        this._xmlParserFeatures = xpFeatures;
        this._xmlGeneratorFeatures = xgFeatures;
        this._cfgNameForTextElement = nameForTextElem;
        if (xmlIn == null) {
            xmlIn = XMLInputFactory.newInstance();
        }
        if (xmlOut == null) {
            xmlOut = XMLOutputFactory.newInstance();
        }
        this._initFactories(xmlIn, xmlOut);
        this._xmlInputFactory = xmlIn;
        this._xmlOutputFactory = xmlOut;
    }

    protected XmlFactory(XmlFactory src, ObjectCodec oc) {
        super((JsonFactory)src, oc);
        this._xmlParserFeatures = src._xmlParserFeatures;
        this._xmlGeneratorFeatures = src._xmlGeneratorFeatures;
        this._cfgNameForTextElement = src._cfgNameForTextElement;
        this._xmlInputFactory = src._xmlInputFactory;
        this._xmlOutputFactory = src._xmlOutputFactory;
    }

    protected void _initFactories(XMLInputFactory xmlIn, XMLOutputFactory xmlOut) {
        xmlOut.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        xmlIn.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
    }

    public XmlFactory copy() {
        this._checkInvalidCopy(XmlFactory.class);
        return new XmlFactory(this, null);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected Object readResolve() {
        if (this._jdkXmlInFactory == null) {
            throw new IllegalStateException("No XMLInputFactory class name read during JDK deserialization");
        }
        if (this._jdkXmlOutFactory == null) {
            throw new IllegalStateException("No XMLOutputFactory class name read during JDK deserialization");
        }
        try {
            XMLInputFactory inf = (XMLInputFactory)Class.forName(this._jdkXmlInFactory).newInstance();
            XMLOutputFactory outf = (XMLOutputFactory)Class.forName(this._jdkXmlOutFactory).newInstance();
            return new XmlFactory(this._objectCodec, this._xmlParserFeatures, this._xmlGeneratorFeatures, inf, outf, this._cfgNameForTextElement);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._jdkXmlInFactory = in.readUTF();
        this._jdkXmlOutFactory = in.readUTF();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this._xmlInputFactory.getClass().getName());
        out.writeUTF(this._xmlOutputFactory.getClass().getName());
    }

    public void setXMLTextElementName(String name) {
        this._cfgNameForTextElement = name;
    }

    public String getXMLTextElementName() {
        return this._cfgNameForTextElement;
    }

    public final XmlFactory configure(FromXmlParser.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public XmlFactory enable(FromXmlParser.Feature f) {
        this._xmlParserFeatures |= f.getMask();
        return this;
    }

    public XmlFactory disable(FromXmlParser.Feature f) {
        this._xmlParserFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(FromXmlParser.Feature f) {
        return (this._xmlParserFeatures & f.getMask()) != 0;
    }

    public final XmlFactory configure(ToXmlGenerator.Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public XmlFactory enable(ToXmlGenerator.Feature f) {
        this._xmlGeneratorFeatures |= f.getMask();
        return this;
    }

    public XmlFactory disable(ToXmlGenerator.Feature f) {
        this._xmlGeneratorFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(ToXmlGenerator.Feature f) {
        return (this._xmlGeneratorFeatures & f.getMask()) != 0;
    }

    public void setXMLInputFactory(XMLInputFactory f) {
        this._xmlInputFactory = f;
    }

    public void setXMLOutputFactory(XMLOutputFactory f) {
        this._xmlOutputFactory = f;
    }

    public String getFormatName() {
        return FORMAT_NAME_XML;
    }

    public MatchStrength hasFormat(InputAccessor acc) throws IOException {
        return XmlFactory.hasXMLFormat(acc);
    }

    public boolean requiresCustomCodec() {
        return false;
    }

    public ToXmlGenerator createGenerator(OutputStream out) throws IOException {
        return this.createGenerator(out, JsonEncoding.UTF8);
    }

    public ToXmlGenerator createGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return new ToXmlGenerator(this._createContext(out, false), this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createGenerator(Writer out) throws IOException {
        return new ToXmlGenerator(this._createContext(out, false), this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    public ToXmlGenerator createGenerator(File f, JsonEncoding enc) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        return new ToXmlGenerator(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, this._createXmlWriter(out));
    }

    @Deprecated
    public ToXmlGenerator createJsonGenerator(OutputStream out, JsonEncoding enc) throws IOException {
        return this.createGenerator(out, enc);
    }

    @Deprecated
    public ToXmlGenerator createJsonGenerator(Writer out) throws IOException {
        return this.createGenerator(out);
    }

    @Deprecated
    public ToXmlGenerator createJsonGenerator(File f, JsonEncoding enc) throws IOException {
        return this.createGenerator(f, enc);
    }

    protected FromXmlParser _createParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory.createXMLStreamReader(in);
            sr = this._initializeXmlReader(sr);
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(e));
        }
        FromXmlParser xp = new FromXmlParser(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, sr);
        if (this._cfgNameForTextElement != null) {
            xp.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return xp;
    }

    protected FromXmlParser _createParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory.createXMLStreamReader(r);
            sr = this._initializeXmlReader(sr);
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(e));
        }
        FromXmlParser xp = new FromXmlParser(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, sr);
        if (this._cfgNameForTextElement != null) {
            xp.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return xp;
    }

    protected FromXmlParser _createParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        XMLStreamReader sr;
        try {
            sr = this._xmlInputFactory.createXMLStreamReader((Source)new Stax2ByteArraySource(data, offset, len));
            sr = this._initializeXmlReader(sr);
        }
        catch (XMLStreamException e) {
            return (FromXmlParser)((Object)StaxUtil.throwXmlAsIOException(e));
        }
        FromXmlParser xp = new FromXmlParser(ctxt, this._generatorFeatures, this._xmlGeneratorFeatures, this._objectCodec, sr);
        if (this._cfgNameForTextElement != null) {
            xp.setXMLTextElementName(this._cfgNameForTextElement);
        }
        return xp;
    }

    @Deprecated
    protected FromXmlParser _createJsonParser(InputStream in, IOContext ctxt) throws IOException, JsonParseException {
        return this._createParser(in, ctxt);
    }

    @Deprecated
    protected FromXmlParser _createJsonParser(Reader r, IOContext ctxt) throws IOException, JsonParseException {
        return this._createParser(r, ctxt);
    }

    @Deprecated
    protected FromXmlParser _createJsonParser(byte[] data, int offset, int len, IOContext ctxt) throws IOException, JsonParseException {
        return this._createParser(data, offset, len, ctxt);
    }

    protected XMLStreamWriter _createXmlWriter(OutputStream out) throws IOException {
        try {
            return this._initializeXmlWriter(this._xmlOutputFactory.createXMLStreamWriter(out, "UTF-8"));
        }
        catch (XMLStreamException e) {
            return (XMLStreamWriter)StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected XMLStreamWriter _createXmlWriter(Writer w) throws IOException {
        try {
            return this._initializeXmlWriter(this._xmlOutputFactory.createXMLStreamWriter(w));
        }
        catch (XMLStreamException e) {
            return (XMLStreamWriter)StaxUtil.throwXmlAsIOException(e);
        }
    }

    protected final XMLStreamWriter _initializeXmlWriter(XMLStreamWriter sw) throws IOException, XMLStreamException {
        sw.setDefaultNamespace("");
        return sw;
    }

    protected final XMLStreamReader _initializeXmlReader(XMLStreamReader sr) throws IOException, XMLStreamException {
        while (sr.next() != 1) {
        }
        return sr;
    }

    public static MatchStrength hasXMLFormat(InputAccessor acc) throws IOException {
        boolean maybeXmlDecl;
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte b = acc.nextByte();
        if (b == -17) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = acc.nextByte();
        }
        boolean bl = maybeXmlDecl = b == 60;
        if (!maybeXmlDecl) {
            int ch = XmlFactory.skipSpace(acc, b);
            if (ch < 0) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = (byte)ch;
            if (b != 60) {
                return MatchStrength.NO_MATCH;
            }
        }
        if (!acc.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        b = acc.nextByte();
        if (b == 63) {
            b = acc.nextByte();
            if (b == 120) {
                if (maybeXmlDecl && acc.hasMoreBytes() && acc.nextByte() == 109 && acc.hasMoreBytes() && acc.nextByte() == 108) {
                    return MatchStrength.FULL_MATCH;
                }
                return MatchStrength.SOLID_MATCH;
            }
            if (XmlFactory.validXmlNameStartChar(acc, b)) {
                return MatchStrength.SOLID_MATCH;
            }
        } else if (b == 33) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            b = acc.nextByte();
            if (b == 45) {
                if (!acc.hasMoreBytes()) {
                    return MatchStrength.INCONCLUSIVE;
                }
                if (acc.nextByte() == 45) {
                    return MatchStrength.SOLID_MATCH;
                }
            } else if (b == 68) {
                return XmlFactory.tryMatch(acc, "OCTYPE", MatchStrength.SOLID_MATCH);
            }
        } else if (XmlFactory.validXmlNameStartChar(acc, b)) {
            return MatchStrength.SOLID_MATCH;
        }
        return MatchStrength.NO_MATCH;
    }

    private static final boolean validXmlNameStartChar(InputAccessor acc, byte b) throws IOException {
        int ch = b & 0xFF;
        return ch >= 65;
    }

    private static final MatchStrength tryMatch(InputAccessor acc, String matchStr, MatchStrength fullMatchStrength) throws IOException {
        int len = matchStr.length();
        for (int i = 0; i < len; ++i) {
            if (!acc.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (acc.nextByte() == matchStr.charAt(i)) continue;
            return MatchStrength.NO_MATCH;
        }
        return fullMatchStrength;
    }

    private static final int skipSpace(InputAccessor acc, byte b) throws IOException {
        int ch;
        while ((ch = b & 0xFF) == 32 || ch == 13 || ch == 10 || ch == 9) {
            if (!acc.hasMoreBytes()) {
                return -1;
            }
            b = acc.nextByte();
            int n = b & 0xFF;
        }
        return ch;
    }
}

