/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate6;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.datatype.hibernate6.Hibernate6AnnotationIntrospector;
import com.fasterxml.jackson.datatype.hibernate6.Hibernate6SerializerModifier;
import com.fasterxml.jackson.datatype.hibernate6.Hibernate6Serializers;
import com.fasterxml.jackson.datatype.hibernate6.PackageVersion;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.Mapping;

public class Hibernate6Module
extends Module {
    protected static final int DEFAULT_FEATURES = Feature.collectDefaults();
    protected int _moduleFeatures = DEFAULT_FEATURES;
    protected final Mapping _mapping;
    protected final SessionFactory _sessionFactory;

    public Hibernate6Module() {
        this(null, null);
    }

    public Hibernate6Module(Mapping mapping) {
        this(mapping, null);
    }

    public Hibernate6Module(SessionFactory sessionFactory) {
        this(null, sessionFactory);
    }

    public Hibernate6Module(Mapping mapping, SessionFactory sessionFactory) {
        this._sessionFactory = sessionFactory;
        this._mapping = mapping;
    }

    public String getModuleName() {
        return "jackson-datatype-hibernate";
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        AnnotationIntrospector ai = this.annotationIntrospector();
        if (ai != null) {
            context.appendAnnotationIntrospector(ai);
        }
        context.addSerializers((Serializers)new Hibernate6Serializers(this._mapping, this._moduleFeatures));
        context.addBeanSerializerModifier((BeanSerializerModifier)new Hibernate6SerializerModifier(this._moduleFeatures, this._sessionFactory));
    }

    protected AnnotationIntrospector annotationIntrospector() {
        Hibernate6AnnotationIntrospector ai = new Hibernate6AnnotationIntrospector();
        ai.setUseTransient(this.isEnabled(Feature.USE_TRANSIENT_ANNOTATION));
        return ai;
    }

    public Hibernate6Module enable(Feature f) {
        this._moduleFeatures |= f.getMask();
        return this;
    }

    public Hibernate6Module disable(Feature f) {
        this._moduleFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._moduleFeatures & f.getMask()) != 0;
    }

    public Hibernate6Module configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public static enum Feature {
        FORCE_LAZY_LOADING(false),
        USE_TRANSIENT_ANNOTATION(true),
        SERIALIZE_IDENTIFIER_FOR_LAZY_NOT_LOADED_OBJECTS(false),
        REQUIRE_EXPLICIT_LAZY_LOADING_MARKER(false),
        REPLACE_PERSISTENT_COLLECTIONS(false),
        WRITE_MISSING_ENTITIES_AS_NULL(false),
        WRAP_IDENTIFIER_IN_OBJECT(true);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

