/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.hibernate6;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.datatype.hibernate6.Hibernate6Module;
import com.fasterxml.jackson.datatype.hibernate6.Hibernate6ProxySerializer;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.proxy.HibernateProxy;

public class Hibernate6Serializers
extends Serializers.Base {
    protected final boolean _forceLoading;
    protected final boolean _serializeIdentifiers;
    protected final boolean _nullMissingEntities;
    protected final boolean _wrappedIdentifier;
    protected final Mapping _mapping;

    public Hibernate6Serializers(int features) {
        this(null, features);
    }

    public Hibernate6Serializers(Mapping mapping, int features) {
        this._forceLoading = Hibernate6Module.Feature.FORCE_LAZY_LOADING.enabledIn(features);
        this._serializeIdentifiers = Hibernate6Module.Feature.SERIALIZE_IDENTIFIER_FOR_LAZY_NOT_LOADED_OBJECTS.enabledIn(features);
        this._nullMissingEntities = Hibernate6Module.Feature.WRITE_MISSING_ENTITIES_AS_NULL.enabledIn(features);
        this._wrappedIdentifier = Hibernate6Module.Feature.WRAP_IDENTIFIER_IN_OBJECT.enabledIn(features);
        this._mapping = mapping;
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class raw = type.getRawClass();
        if (HibernateProxy.class.isAssignableFrom(raw)) {
            return new Hibernate6ProxySerializer(this._forceLoading, this._serializeIdentifiers, this._nullMissingEntities, this._wrappedIdentifier, this._mapping);
        }
        return null;
    }
}

