/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310;

import java.math.BigDecimal;

public final class DecimalUtils {
    private static final char[] ZEROES = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0'};
    private static final BigDecimal ONE_BILLION = new BigDecimal(1000000000L);

    private DecimalUtils() {
        throw new RuntimeException("DecimalUtils cannot be instantiated.");
    }

    public static String toDecimal(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder(Integer.toString(n));
        if (stringBuilder.length() < 9) {
            stringBuilder.insert(0, ZEROES, 0, 9 - stringBuilder.length());
        }
        return l + "." + stringBuilder;
    }

    public static int extractNanosecondDecimal(BigDecimal bigDecimal, long l) {
        return bigDecimal.subtract(new BigDecimal(l)).multiply(ONE_BILLION).intValue();
    }
}

