/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Duration;

public class DurationDeserializer
extends JSR310DeserializerBase<Duration> {
    private static final long serialVersionUID = 1L;
    public static final DurationDeserializer INSTANCE = new DurationDeserializer();

    private DurationDeserializer() {
        super(Duration.class);
    }

    public Duration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_NUMBER_FLOAT: {
                BigDecimal bigDecimal = jsonParser.getDecimalValue();
                long l = bigDecimal.longValue();
                int n = DecimalUtils.extractNanosecondDecimal(bigDecimal, l);
                return Duration.ofSeconds(l, n);
            }
            case VALUE_NUMBER_INT: {
                if (deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    return Duration.ofSeconds(jsonParser.getLongValue());
                }
                return Duration.ofMillis(jsonParser.getLongValue());
            }
            case VALUE_STRING: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return Duration.parse(string);
            }
        }
        throw deserializationContext.mappingException("Expected type float, integer, or string.");
    }
}

