/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class InstantDeserializer<T extends Temporal>
extends JSR310DeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, Instant::parse, fromIntegerArguments -> Instant.ofEpochMilli(fromIntegerArguments.value), fromDecimalArguments -> Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), null);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, OffsetDateTime::parse, fromIntegerArguments -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(fromIntegerArguments.value), fromIntegerArguments.zoneId), fromDecimalArguments -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), fromDecimalArguments.zoneId), (offsetDateTime, zoneId) -> offsetDateTime.withOffsetSameInstant(zoneId.getRules().getOffset(offsetDateTime.toLocalDateTime())));
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, ZonedDateTime::parse, fromIntegerArguments -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(fromIntegerArguments.value), fromIntegerArguments.zoneId), fromDecimalArguments -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(fromDecimalArguments.integer, fromDecimalArguments.fraction), fromDecimalArguments.zoneId), ZonedDateTime::withZoneSameInstant);
    private final Function<FromIntegerArguments, T> fromMilliseconds;
    private final Function<FromDecimalArguments, T> fromNanoseconds;
    private final Function<CharSequence, T> parse;
    private final BiFunction<T, ZoneId, T> adjust;

    private InstantDeserializer(Class<T> clazz, Function<CharSequence, T> function, Function<FromIntegerArguments, T> function2, Function<FromDecimalArguments, T> function3, BiFunction<T, ZoneId, T> biFunction) {
        super(clazz);
        this.parse = function;
        this.fromMilliseconds = function2;
        this.fromNanoseconds = function3;
        this.adjust = biFunction == null ? (temporal, zoneId) -> temporal : biFunction;
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentToken()) {
            case VALUE_NUMBER_FLOAT: {
                BigDecimal bigDecimal = jsonParser.getDecimalValue();
                long l = bigDecimal.longValue();
                int n = DecimalUtils.extractNanosecondDecimal(bigDecimal, l);
                return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(l, n, this.getZone(deserializationContext))));
            }
            case VALUE_NUMBER_INT: {
                if (deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                    return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(jsonParser.getLongValue(), 0, this.getZone(deserializationContext))));
                }
                return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(jsonParser.getLongValue(), this.getZone(deserializationContext))));
            }
            case VALUE_STRING: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                if (deserializationContext.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE)) {
                    return (T)((Temporal)this.adjust.apply(this.parse.apply(string), this.getZone(deserializationContext)));
                }
                return (T)((Temporal)this.parse.apply(string));
            }
        }
        throw deserializationContext.mappingException("Expected type float, integer, or string.");
    }

    private ZoneId getZone(DeserializationContext deserializationContext) {
        return this._valueClass == Instant.class ? null : deserializationContext.getTimeZone().toZoneId();
    }

    private static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        private FromDecimalArguments(long l, int n, ZoneId zoneId) {
            this.integer = l;
            this.fraction = n;
            this.zoneId = zoneId;
        }
    }

    private static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        private FromIntegerArguments(long l, ZoneId zoneId) {
            this.value = l;
            this.zoneId = zoneId;
        }
    }
}

