/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.MonthDay;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.function.Function;

public final class JSR310StringParsableDeserializer<T>
extends JSR310DeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    public static final JSR310StringParsableDeserializer<MonthDay> MONTH_DAY = new JSR310StringParsableDeserializer<MonthDay>(MonthDay.class, MonthDay::parse);
    public static final JSR310StringParsableDeserializer<Period> PERIOD = new JSR310StringParsableDeserializer<Period>(Period.class, Period::parse);
    public static final JSR310StringParsableDeserializer<YearMonth> YEAR_MONTH = new JSR310StringParsableDeserializer<YearMonth>(YearMonth.class, YearMonth::parse);
    public static final JSR310StringParsableDeserializer<ZoneId> ZONE_ID = new JSR310StringParsableDeserializer<ZoneId>(ZoneId.class, ZoneId::of);
    public static final JSR310StringParsableDeserializer<ZoneOffset> ZONE_OFFSET = new JSR310StringParsableDeserializer<ZoneOffset>(ZoneOffset.class, ZoneOffset::of);
    private final Function<String, T> parse;

    private JSR310StringParsableDeserializer(Class<T> clazz, Function<String, T> function) {
        super(clazz);
        this.parse = function;
    }

    public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string = jsonParser.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return this.parse.apply(string);
    }
}

