/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.LocalDate;

public class LocalDateDeserializer
extends JSR310DeserializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateDeserializer INSTANCE = new LocalDateDeserializer();

    private LocalDateDeserializer() {
        super(LocalDate.class);
    }

    public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentToken()) {
            case START_ARRAY: {
                if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                int n = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n2 = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n3 = jsonParser.getIntValue();
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    throw deserializationContext.wrongTokenException(jsonParser, JsonToken.END_ARRAY, "Expected array to end.");
                }
                return LocalDate.of(n, n2, n3);
            }
            case VALUE_STRING: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return LocalDate.parse(string);
            }
        }
        throw deserializationContext.wrongTokenException(jsonParser, JsonToken.START_ARRAY, "Expected array or string.");
    }
}

