/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.LocalDateTime;

public class LocalDateTimeDeserializer
extends JSR310DeserializerBase<LocalDateTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateTimeDeserializer INSTANCE = new LocalDateTimeDeserializer();

    private LocalDateTimeDeserializer() {
        super(LocalDateTime.class);
    }

    public LocalDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentToken()) {
            case START_ARRAY: {
                if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                int n = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n2 = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n3 = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n4 = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n5 = jsonParser.getIntValue();
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    int n6 = jsonParser.getIntValue();
                    if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        int n7 = jsonParser.getIntValue();
                        if (n7 < 1000 && !deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            n7 *= 1000000;
                        }
                        if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                            throw deserializationContext.wrongTokenException(jsonParser, JsonToken.END_ARRAY, "Expected array to end.");
                        }
                        return LocalDateTime.of(n, n2, n3, n4, n5, n6, n7);
                    }
                    return LocalDateTime.of(n, n2, n3, n4, n5, n6);
                }
                return LocalDateTime.of(n, n2, n3, n4, n5);
            }
            case VALUE_STRING: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return LocalDateTime.parse(string);
            }
        }
        throw deserializationContext.wrongTokenException(jsonParser, JsonToken.START_ARRAY, "Expected array or string.");
    }
}

