/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.LocalTime;

public class LocalTimeDeserializer
extends JSR310DeserializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalTimeDeserializer INSTANCE = new LocalTimeDeserializer();

    private LocalTimeDeserializer() {
        super(LocalTime.class);
    }

    public LocalTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentToken()) {
            case START_ARRAY: {
                if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                int n = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n2 = jsonParser.getIntValue();
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    int n3 = jsonParser.getIntValue();
                    if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        int n4 = jsonParser.getIntValue();
                        if (n4 < 1000 && !deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            n4 *= 1000000;
                        }
                        if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                            throw deserializationContext.wrongTokenException(jsonParser, JsonToken.END_ARRAY, "Expected array to end.");
                        }
                        return LocalTime.of(n, n2, n3, n4);
                    }
                    return LocalTime.of(n, n2, n3);
                }
                return LocalTime.of(n, n2);
            }
            case VALUE_STRING: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return LocalTime.parse(string);
            }
        }
        throw deserializationContext.wrongTokenException(jsonParser, JsonToken.START_ARRAY, "Expected array or string.");
    }
}

