/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.OffsetTime;
import java.time.ZoneOffset;

public class OffsetTimeDeserializer
extends JSR310DeserializerBase<OffsetTime> {
    private static final long serialVersionUID = 1L;
    public static final OffsetTimeDeserializer INSTANCE = new OffsetTimeDeserializer();

    private OffsetTimeDeserializer() {
        super(OffsetTime.class);
    }

    public OffsetTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentToken()) {
            case START_ARRAY: {
                if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                    return null;
                }
                int n = jsonParser.getIntValue();
                jsonParser.nextToken();
                int n2 = jsonParser.getIntValue();
                int n3 = 0;
                int n4 = 0;
                if (jsonParser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                    n3 = jsonParser.getIntValue();
                    if (jsonParser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                        n4 = jsonParser.getIntValue();
                        if (n4 < 1000 && !deserializationContext.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                            n4 *= 1000000;
                        }
                        jsonParser.nextToken();
                    }
                }
                if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
                    return OffsetTime.of(n, n2, n3, n4, ZoneOffset.of(jsonParser.getText()));
                }
                throw deserializationContext.wrongTokenException(jsonParser, JsonToken.VALUE_STRING, "Expected string");
            }
            case VALUE_STRING: {
                String string = jsonParser.getText().trim();
                if (string.length() == 0) {
                    return null;
                }
                return OffsetTime.parse(string);
            }
        }
        throw deserializationContext.wrongTokenException(jsonParser, JsonToken.START_ARRAY, "Expected array or string.");
    }
}

