/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310SerializerBase;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class InstantSerializer<T extends Temporal>
extends JSR310SerializerBase<T> {
    public static final InstantSerializer<Instant> INSTANT = new InstantSerializer<Instant>(Instant.class, Instant::toEpochMilli, Instant::getEpochSecond, Instant::getNano);
    public static final InstantSerializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantSerializer<OffsetDateTime>(OffsetDateTime.class, offsetDateTime -> offsetDateTime.toInstant().toEpochMilli(), OffsetDateTime::toEpochSecond, OffsetDateTime::getNano);
    public static final InstantSerializer<ZonedDateTime> ZONED_DATE_TIME = new InstantSerializer<ZonedDateTime>(ZonedDateTime.class, zonedDateTime -> zonedDateTime.toInstant().toEpochMilli(), ChronoZonedDateTime::toEpochSecond, ZonedDateTime::getNano);
    private final ToLongFunction<T> getEpochMillis;
    private final ToLongFunction<T> getEpochSeconds;
    private final ToIntFunction<T> getNanoseconds;

    private InstantSerializer(Class<T> clazz, ToLongFunction<T> toLongFunction, ToLongFunction<T> toLongFunction2, ToIntFunction<T> toIntFunction) {
        super(clazz);
        this.getEpochMillis = toLongFunction;
        this.getEpochSeconds = toLongFunction2;
        this.getNanoseconds = toIntFunction;
    }

    public void serialize(T t, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                jsonGenerator.writeNumber(DecimalUtils.toDecimal(this.getEpochSeconds.applyAsLong(t), this.getNanoseconds.applyAsInt(t)));
            } else {
                jsonGenerator.writeNumber(this.getEpochMillis.applyAsLong(t));
            }
        } else {
            jsonGenerator.writeString(t.toString());
        }
    }
}

