/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310ArraySerializerBase;
import java.io.IOException;
import java.time.LocalDate;

public class LocalDateSerializer
extends JSR310ArraySerializerBase<LocalDate> {
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();

    private LocalDateSerializer() {
        super(LocalDate.class);
    }

    public void serialize(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeNumber(localDate.getYear());
            jsonGenerator.writeNumber(localDate.getMonthValue());
            jsonGenerator.writeNumber(localDate.getDayOfMonth());
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(localDate.toString());
        }
    }
}

