/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310ArraySerializerBase;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;

public class LocalDateTimeSerializer
extends JSR310ArraySerializerBase<LocalDateTime> {
    public static final LocalDateTimeSerializer INSTANCE = new LocalDateTimeSerializer();

    private LocalDateTimeSerializer() {
        super(LocalDateTime.class);
    }

    public void serialize(LocalDateTime localDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS)) {
            jsonGenerator.writeStartArray();
            jsonGenerator.writeNumber(localDateTime.getYear());
            jsonGenerator.writeNumber(localDateTime.getMonthValue());
            jsonGenerator.writeNumber(localDateTime.getDayOfMonth());
            jsonGenerator.writeNumber(localDateTime.getHour());
            jsonGenerator.writeNumber(localDateTime.getMinute());
            if (localDateTime.getSecond() > 0 || localDateTime.getNano() > 0) {
                jsonGenerator.writeNumber(localDateTime.getSecond());
                if (localDateTime.getNano() > 0) {
                    if (serializerProvider.isEnabled(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
                        jsonGenerator.writeNumber(localDateTime.getNano());
                    } else {
                        jsonGenerator.writeNumber(localDateTime.get(ChronoField.MILLI_OF_SECOND));
                    }
                }
            }
            jsonGenerator.writeEndArray();
        } else {
            jsonGenerator.writeString(localDateTime.toString());
        }
    }
}

